/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.style;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.internal.css.CSSUtil;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.vida.rave.render.internal.nodes.LinearGradientSceneItem;
import com.ibm.vida.rave.render.internal.nodes.NodeUtil;
import com.ibm.vida.rave.render.internal.nodes.RadialGradientSceneItem;
import com.ibm.vida.rave.render.internal.nodes.StopSceneItem;
import com.ibm.vida.rave.render.internal.style.AbstractStyle;
import com.ibm.vida.rave.render.internal.style.FillStyle;
import com.ibm.vida.rave.render.internal.style.FontStyle;
import com.ibm.vida.rave.render.internal.style.GradientFillStyle;
import com.ibm.vida.rave.render.internal.style.GradientStop;
import com.ibm.vida.rave.render.internal.style.LinearGradientFillStyle;
import com.ibm.vida.rave.render.internal.style.RadialGradientFillStyle;
import com.ibm.vida.rave.render.internal.style.StrokeStyle;

public final class RenderStyleManager {
    @InlineStringConstant
    private static final String NONE = "none";
    @InlineStringConstant
    private static final String BUTT = "butt";
    @InlineStringConstant
    private static final String MITER = "miter";

    public static AbstractStyle getFill(AbstractSceneNode node) {
        Object fill = node.getComputedStyleValue(28);
        AbstractStyle style = null;
        if (fill != null && !NONE.equals(fill)) {
            String id = CSSUtil.parseIdUrlLink((Object)fill);
            if (id != null) {
                SceneNode gradientNode = NodeUtil.findSceneNode(node, id, new int[]{1011, 1012});
                if (gradientNode != null) {
                    switch (gradientNode.getDrawType()) {
                        case 1011: {
                            LinearGradientSceneItem linearGradient = (LinearGradientSceneItem)gradientNode;
                            style = new LinearGradientFillStyle(linearGradient.getX1(node), linearGradient.getY1(node), linearGradient.getX2(node), linearGradient.getY2(node));
                            RenderStyleManager.addGradientStops((GradientFillStyle)style, linearGradient);
                            break;
                        }
                        case 1012: {
                            RadialGradientSceneItem radialGradient = (RadialGradientSceneItem)gradientNode;
                            style = new RadialGradientFillStyle(radialGradient.getCX(node), radialGradient.getCY(node), radialGradient.getR(node), radialGradient.getFX(node), radialGradient.getFY(node));
                            RenderStyleManager.addGradientStops((GradientFillStyle)style, radialGradient);
                        }
                    }
                }
            } else {
                Object oOpacity = node.getComputedStyleValue(30);
                Object oFillOpacity = node.getComputedStyleValue(33);
                double opacity = oOpacity != null ? ((Number)oOpacity).doubleValue() : 1.0;
                double fillOpacity = oFillOpacity != null ? ((Number)oFillOpacity).doubleValue() : 1.0;
                if ((opacity *= fillOpacity) > 0.0) {
                    style = new FillStyle(fill, Math.min(opacity, 1.0));
                }
            }
        }
        return style;
    }

    private static void addGradientStops(GradientFillStyle gradientStyle, SceneNode gradientNode) {
        for (SceneNode child : gradientNode.getChildNodes()) {
            if (child.getDrawType() != 1016) continue;
            StopSceneItem stopItem = (StopSceneItem)child;
            gradientStyle.addStop(new GradientStop(stopItem.getOffset(), stopItem.getColor(), stopItem.getOpacity()));
        }
    }

    public static StrokeStyle getStroke(AbstractSceneNode node) {
        Object stroke = node.getComputedStyleValue(29);
        if (stroke == null || NONE.equals(stroke)) {
            return null;
        }
        double strokeWidth = node.getComputedSizePx(31);
        if (strokeWidth > 0.0) {
            Object oOpacity = node.getComputedStyleValue(30);
            Object oStrokeOpacity = node.getComputedStyleValue(32);
            double opacity = oOpacity != null ? ((Number)oOpacity).doubleValue() : 1.0;
            double strokeOpacity = oStrokeOpacity != null ? ((Number)oStrokeOpacity).doubleValue() : 1.0;
            if ((opacity *= strokeOpacity) > 0.0) {
                double miterLimit = ((Number)node.getComputedStyleValue(38)).doubleValue();
                String lineJoin = (String)node.getComputedStyleValue(37);
                String lineCap = (String)node.getComputedStyleValue(36);
                float[] dashArray = (float[])node.getComputedStyleValue(34);
                double dashOffset = node.getComputedSizePx(35);
                return new StrokeStyle(stroke, strokeWidth, Math.min(opacity, 1.0), miterLimit, lineJoin, lineCap, dashArray, dashOffset);
            }
        }
        return null;
    }

    public static FontStyle getFont(AbstractSceneNode node) {
        String style = (String)node.getComputedStyleValue(23);
        String family = (String)node.getComputedStyleValue(21);
        CSSSize size = (CSSSize)node.getComputedStyleValue(22);
        String weight = (String)node.getComputedStyleValue(24);
        String lineHeight = ObjectConverter.toString((Object)node.getComputedStyleValue(14));
        String variant = (String)node.getComputedStyleValue(25);
        return new FontStyle(style, family, size, weight, lineHeight, variant);
    }
}

