/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.axis;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.Dim;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.LinearScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.AbstractTickHandler;
import com.ibm.vida.rave.core.svg.Axis;
import com.ibm.vida.rave.core.transition.Transition;
import com.ibm.vida.rave.ext.animation.TextCrossfader;
import com.ibm.vida.rave.ext.axis.tickLabel.TickLabelDrop;
import com.ibm.vida.rave.ext.axis.tickLabel.TickLabelHandler;
import com.ibm.vida.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.vida.rave.ext.text.wrap.TextFlow;
import java.util.List;

public class AxisComponentUtil
implements RunFunction<Object> {
    @InlineStringConstant
    private static final String VISIBILITY = "visibility";
    @InlineStringConstant
    private static final String HIDDEN = "hidden";
    @InlineStringConstant
    public static final String LABEL_HIDDEN_FLAG = "__tickLabelHidden__";
    @InlineStringConstant
    public static final String PANZOOM_HIDDEN_FLAG = "__panZoomHidden__";
    @InlineStringConstant
    public static final String HIDDEN_COUNT = "__hiddenCount__";
    private final FontChecker _fontChecker;
    private TickLabelHandler _tickLabelHandler;
    private TickLabelDrop _tickLabelDrop;
    private boolean _hideOverlappingLabels;
    private final RunFunction<Selection<?>> _axisLineProperties;
    private final RunFunction<Selection<?>> _axisTickProperties;
    private final RunFunction<Selection<?>> _axisTickLabelProperties;
    private final CallbackFunction<SceneNode> _displayHideLabels;
    private final CallbackFunction<SceneNode> _panZoomLabels;
    private Axis _axis;
    private AbstractScale<?, ?> _scale;
    private String _orient;
    private boolean _isNumericAxis;
    @InlineStringConstant
    public static final double MIN_TICK_SPACE = 20.0;
    @InlineStringConstant
    public static final double PREFERRED_TICK_COUNT = 10.0;
    @InlineStringConstant
    public static final double TICK_PADDING = 10.0;
    private int _outerTickSize = 0;
    private int _innerTickSize = 6;
    private Double _tickInterval = null;
    private double _tickCount;
    private Number _tickGap = null;
    public boolean _displayAxisLine;
    public String _lineColor;
    public boolean _displayTicks;
    public String _tickColor;
    public boolean _displayTickLabels;
    int _padding;
    private ValueFunction<Object, String> _tickFormat;
    public boolean _showPanZoomTickLabels;
    public OMap<String, Object> _labelStyle;
    public boolean _displayAxisTitle;
    private Dim _titleSize;
    public String _axisTitle;
    public OMap<String, Object> _titleStyle;
    private RectStruct _bounds;
    private TextFlow _textFlow;
    private boolean _renderedShapes;
    protected boolean _pendingLabelTimer;
    private String _axisLabelClass = "axis-label";
    private String _axisTitleClass = "axis-title";
    private boolean _layoutNeeded;
    private final AxisTickHandler _tickHandler;

    public AxisComponentUtil() {
        final AxisComponentUtil self = this;
        this._axisLineProperties = new RunFunction<Selection<?>>(){

            public Object run(Selection<?> ticks, Object ... args) {
                Selection line = ticks.selectAll("path.domain");
                if (self._lineColor != null) {
                    line.style("stroke", (Object)self._lineColor);
                }
                if (self._displayAxisLine) {
                    line.attr(AxisComponentUtil.VISIBILITY, null);
                } else {
                    line.attr(AxisComponentUtil.VISIBILITY, (Object)AxisComponentUtil.HIDDEN);
                }
                return null;
            }
        };
        this._axisTickProperties = new RunFunction<Selection<?>>(){

            public Object run(Selection<?> ticks, Object ... args) {
                Selection tickLines = ticks.selectAll("line");
                if (self._displayTicks) {
                    tickLines.attr(AxisComponentUtil.VISIBILITY, null);
                } else {
                    tickLines.attr(AxisComponentUtil.VISIBILITY, (Object)AxisComponentUtil.HIDDEN);
                }
                if (self._lineColor != null) {
                    tickLines.style("stroke", (Object)self._tickColor);
                }
                return null;
            }
        };
        this._axisTickLabelProperties = new RunFunction<Selection<?>>(){

            public Object run(Selection<?> ticks, Object ... args) {
                Selection labels = ticks.selectAll("text");
                labels.each(self._displayHideLabels);
                labels.each(self._panZoomLabels);
                self._axis.ticksHandler(null);
                return null;
            }
        };
        this._displayHideLabels = new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object obj, int group, int index) {
                if (self._displayTickLabels) {
                    if (context.hasProperty(AxisComponentUtil.LABEL_HIDDEN_FLAG)) {
                        context.removeProperty(AxisComponentUtil.LABEL_HIDDEN_FLAG);
                        int count = ObjectConverter.toInt((Object)context.getProperty(AxisComponentUtil.HIDDEN_COUNT));
                        if (count <= 1) {
                            context.removeProperty(AxisComponentUtil.HIDDEN_COUNT);
                            context.removeAttribute(AxisComponentUtil.VISIBILITY);
                        } else {
                            context.setProperty(AxisComponentUtil.HIDDEN_COUNT, (Object)(count - 1));
                        }
                    }
                } else if (!context.hasProperty(AxisComponentUtil.LABEL_HIDDEN_FLAG)) {
                    context.setAttribute(AxisComponentUtil.VISIBILITY, (Object)AxisComponentUtil.HIDDEN);
                    context.setProperty(AxisComponentUtil.LABEL_HIDDEN_FLAG, (Object)AxisComponentUtil.HIDDEN);
                    int count = ObjectConverter.toInt((Object)context.getProperty(AxisComponentUtil.HIDDEN_COUNT));
                    context.setProperty(AxisComponentUtil.HIDDEN_COUNT, (Object)(count + 1));
                }
            }
        };
        this._panZoomLabels = new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object obj, int group, int index) {
                if (self._showPanZoomTickLabels) {
                    if (context.hasProperty(AxisComponentUtil.PANZOOM_HIDDEN_FLAG)) {
                        context.removeProperty(AxisComponentUtil.PANZOOM_HIDDEN_FLAG);
                        int count = ObjectConverter.toInt((Object)context.getProperty(AxisComponentUtil.HIDDEN_COUNT));
                        if (count <= 1) {
                            context.removeProperty(AxisComponentUtil.HIDDEN_COUNT);
                            context.removeAttribute(AxisComponentUtil.VISIBILITY);
                        } else {
                            context.setProperty(AxisComponentUtil.HIDDEN_COUNT, (Object)(count - 1));
                        }
                    }
                } else if (!context.hasProperty(AxisComponentUtil.PANZOOM_HIDDEN_FLAG)) {
                    context.setAttribute(AxisComponentUtil.VISIBILITY, (Object)AxisComponentUtil.HIDDEN);
                    context.setProperty(AxisComponentUtil.PANZOOM_HIDDEN_FLAG, (Object)AxisComponentUtil.HIDDEN);
                    int count = ObjectConverter.toInt((Object)context.getProperty(AxisComponentUtil.HIDDEN_COUNT));
                    context.setProperty(AxisComponentUtil.HIDDEN_COUNT, (Object)(count + 1));
                }
            }
        };
        this._tickHandler = new AxisTickHandler(this._axisTickLabelProperties, this._axisTickProperties);
        this._axis = null;
        this._scale = null;
        this._orient = "bottom";
        this._bounds = null;
        this._displayAxisTitle = true;
        this._axisTitle = null;
        this._titleStyle = new OMap();
        this._lineColor = null;
        this._tickColor = null;
        this._displayTicks = true;
        this._displayTickLabels = true;
        this._displayAxisLine = true;
        this._displayAxisTitle = true;
        this._labelStyle = new OMap();
        this._hideOverlappingLabels = true;
        this._tickFormat = null;
        this._showPanZoomTickLabels = true;
        this._padding = 16;
        this._fontChecker = new FontChecker();
        this._tickLabelHandler = new TickLabelHandler();
        this._tickLabelDrop = new TickLabelDrop();
        this._renderedShapes = false;
        this._tickInterval = null;
        this._textFlow = new TextFlow();
        this._titleSize = new Dim(0.0, 0.0);
        this._layoutNeeded = true;
    }

    private ArrayEx<Object> ticks(double start, double stop, double step, int maxTickCount) {
        if (step <= 0.0 || maxTickCount == 0) {
            return null;
        }
        ArrayEx ticks = new ArrayEx();
        boolean reverse = false;
        if (start == stop && step > 0.0) {
            ticks.add((Object)start);
            return ticks;
        }
        reverse = stop < start;
        if (reverse) {
            double n = start;
            start = stop;
            stop = n;
        }
        double totalTicks = Math.ceil(Math.floor(stop / step) - Math.ceil(start / step) + 1.0);
        int skipTickCount = 0;
        if (totalTicks > (double)maxTickCount) {
            skipTickCount = (int)(totalTicks / (double)maxTickCount);
        }
        if (start < 0.0 && stop > 0.0) {
            this.tickIncrement(start, 0.0, step, skipTickCount, (ArrayEx<Object>)ticks, true);
            this.tickIncrement(0.0, stop, step, skipTickCount, (ArrayEx<Object>)ticks, false);
        } else {
            this.tickIncrement(start, stop, step, skipTickCount, (ArrayEx<Object>)ticks, stop <= 0.0);
        }
        if (reverse) {
            ticks.reverse();
        }
        return ticks;
    }

    private void tickIncrement(double start, double stop, double step, int skipCount, ArrayEx<Object> ticks, boolean reverse) {
        if (step <= 0.0) {
            return;
        }
        int i = 0;
        start = Math.ceil(start / step);
        stop = Math.floor(stop / step);
        double n = Math.ceil(stop - start + 1.0);
        if (reverse) {
            while ((double)i < n) {
                ticks.add((Object)((stop - (double)i) * step));
                i = i + skipCount + 1;
            }
        } else {
            while ((double)i < n) {
                ticks.add((Object)((start + (double)i) * step));
                i = i + skipCount + 1;
            }
        }
    }

    public Object run(Object context, Object ... args) {
        Selector g = (Selector)args[0];
        if (this._scale == null || this._bounds == null) {
            g.selectAll("*").remove();
            this._axis = null;
            this._renderedShapes = false;
            return null;
        }
        this._renderedShapes = true;
        this.createAxis(g);
        if (this._layoutNeeded) {
            this.drawTitle(g, false);
        }
        g.selectAll("g.tick").selectAll("text").style(this._labelStyle);
        if (this._displayTickLabels) {
            this.handleAxisText(g);
            this._titleSize = this._tickLabelHandler.layoutTitleSize();
        } else if (this._layoutNeeded) {
            this._titleSize.setHeight(0.0);
            this._titleSize.setWidth(0.0);
            SceneNode titleNode = g.selectAll("text." + this._axisTitleClass).node();
            if (titleNode != null) {
                RaveRect bbox = Rave.util.getBBox(titleNode);
                this._titleSize.setHeight(bbox.height);
                this._titleSize.setWidth(bbox.width);
            }
        }
        this.drawTitle(g, true);
        this._layoutNeeded = false;
        return null;
    }

    public void createAxis(Selector g) {
        Selector axisSelector = g.selectAll("g.axis").data(new Object[]{0});
        axisSelector.enter().append("g").classed("axis", true).classed(this._orient, true);
        if (this._axis == null) {
            this._axis = new Axis();
        }
        this._axis.ticksHandler((AbstractTickHandler)this._tickHandler);
        this._axis.orient(this._orient);
        this._axis.tickFormat(this._tickFormat);
        this._axis.tickPadding((Object)10.0);
        this._axis.scale(this._scale);
        this._axis.tickSize((Object)this._innerTickSize, (Object)this._outerTickSize);
        this._axis.tickValues(null);
        if (this._isNumericAxis) {
            this.handleNumericAxisTicks();
            this._hideOverlappingLabels = true;
        } else {
            this.handleOrdinalAxisTicks();
            this._hideOverlappingLabels = false;
        }
        axisSelector.call((RunFunction)this._axis, new Object[0]);
        Rave.transition((Selection)axisSelector);
        axisSelector.selectAll("path.domain").classed("axis-line", true);
        axisSelector.selectAll("g.tick line").classed("axis-tick", true);
        if (this._fontChecker != null) {
            axisSelector.selectAll("g.tick text").classed(this._axisLabelClass.replace(".", " "), true).call((RunFunction)this._fontChecker, new Object[0]);
        } else {
            axisSelector.selectAll("g.tick text").classed(this._axisLabelClass.replace(".", " "), true);
        }
        axisSelector.call(this._axisLineProperties, new Object[0]);
        this._tickLabelHandler.axis(this._axis);
    }

    private void handleOrdinalAxisTicks() {
        boolean isHorizontal;
        double labelHeight = 20.0;
        boolean bl = isHorizontal = this._orient.equals("bottom") || this._orient.equals("top");
        if (isHorizontal) {
            labelHeight /= 0.7071;
        }
        List rangeExtent = this._scale.rangeExtent.getValue();
        double rangeStart = ObjectConverter.toDouble(rangeExtent.get(0));
        double rangeEnd = ObjectConverter.toDouble(rangeExtent.get(rangeExtent.size() - 1));
        rangeStart = Math.min(rangeStart, rangeEnd);
        rangeEnd = Math.max(rangeStart, rangeEnd);
        double maxTickCount = (rangeEnd - rangeStart) / labelHeight;
        if (rangeEnd - rangeStart != 0.0 && this._scale.rangeBand.getValue().doubleValue() == 0.0 && this._scale.rangeStep.getValue().doubleValue() == 0.0) {
            List domain = this._scale.domain();
            if ((double)domain.size() <= maxTickCount) {
                this._axis.tickValues(domain);
            } else {
                ArrayEx tickArray = new ArrayEx();
                double lastTickPx = -labelHeight;
                for (int i = 0; i < domain.size(); ++i) {
                    double curretTickPos = ObjectConverter.toDouble((Object)this._scale.getValue(null, domain.get(i), 0, 0));
                    if (!(curretTickPos >= rangeStart) || !(curretTickPos <= rangeEnd) || !(curretTickPos - lastTickPx > labelHeight)) continue;
                    tickArray.push(new Object[]{domain.get(i)});
                    lastTickPx = curretTickPos;
                }
                this._axis.tickValues((List)tickArray);
            }
        } else {
            this._axis.ticks(new Object[]{maxTickCount});
        }
    }

    private void handleNumericAxisTicks() {
        List range = this._scale.range();
        double extent = Math.abs(ObjectConverter.toDouble(range.get(range.size() - 1)) - ObjectConverter.toDouble(range.get(0)));
        if (this._scale instanceof LinearScale && this._tickInterval != null && this._tickInterval > 0.0) {
            int tickCount = (int)(extent / 20.0);
            ArrayEx<Object> tickArray = this.ticks(ObjectConverter.toDouble(this._scale.domain().get(0)), ObjectConverter.toDouble(this._scale.domain().get(1)), this._tickInterval, tickCount);
            this._axis.tickValues(tickArray);
            if (tickArray == null) {
                this._axis.ticks(new Object[]{10.0});
            } else {
                this._axis.ticks(new Object[]{tickArray.size()});
            }
        } else if (this._tickGap != null) {
            long preferredTickCount = Math.min(10L, Math.round(extent / this._tickGap.doubleValue()));
            this._axis.ticks(new Object[]{preferredTickCount});
        } else if (this._tickCount > 0.0) {
            this._axis.ticks(new Object[]{this._tickCount});
        } else {
            this._axis.ticks(new Object[]{10.0});
        }
    }

    private void drawTitle(Selector g, boolean _usePreferredSize) {
        if (!this._displayAxisTitle || this._axisTitle == null || this._axisTitle.trim().length() == 0 || this._bounds == null) {
            g.selectAll("text." + this._axisTitleClass + "." + this._orient).remove();
            return;
        }
        double x = 0.0;
        double y = 0.0;
        String dy = "";
        String transform = null;
        double axisWidth = 0.0;
        axisWidth = "top".equals(this._orient) || "bottom".equals(this._orient) ? this._bounds.height : this._bounds.width;
        if (_usePreferredSize) {
            axisWidth = Math.min(this.getPreferredSize(), axisWidth);
        }
        List axisRange = null;
        axisRange = !this._isNumericAxis ? this._scale.rangeExtent.getValue() : this._scale.range();
        double extent = ObjectConverter.toDouble(axisRange.get(0)) + ObjectConverter.toDouble(axisRange.get(1));
        if ("top".equals(this._orient)) {
            x = extent / 2.0;
            y = -axisWidth + (double)(this._padding / 4);
            dy = "0.75em";
        } else if ("bottom".equals(this._orient)) {
            x = extent / 2.0;
            y = axisWidth - (double)(this._padding / 4);
            dy = "-0.25em";
        } else if ("left".equals(this._orient)) {
            x = -extent / 2.0;
            y = -axisWidth + (double)(this._padding / 4);
            dy = "0.75em";
            transform = "rotate(-90)";
        } else {
            x = -extent / 2.0;
            y = axisWidth - this._titleSize.getHeight();
            dy = "0.75em";
            transform = "rotate(-90)";
        }
        Selector label = g.selectAll("text." + this._axisTitleClass + "." + this._orient);
        if (label.size() == 0) {
            ((Selector)label.data(new Object[]{0}).enter().append("text").attr("class", (Object)(this._axisTitleClass.replace(".", " ") + " " + this._orient)).style("text-anchor", (Object)"middle").attr("x", (Object)x).attr("y", (Object)y).attr("transform", (Object)transform).attr("dy", (Object)dy).style(this._titleStyle)).text((Object)this._axisTitle);
            if (this._fontChecker != null) {
                g.selectAll("text." + this._axisTitleClass + "." + this._orient).call((RunFunction)this._fontChecker, new Object[0]);
            }
        }
        Selection<?> titleSelection = g.selectAll("text." + this._axisTitleClass + "." + this._orient).style(this._titleStyle);
        if (label.text() == null) {
            label.text((Object)this._axisTitle);
        } else if (_usePreferredSize && !label.text().equals(this._axisTitle)) {
            Selector tmp = g.append("text").attr("class", (Object)(this._axisTitleClass.replace(".", " ") + " " + this._orient));
            Object fillOpacity = tmp.style("fill-opacity");
            tmp.remove();
            titleSelection = TextCrossfader.textCrossFade(Rave.transition((Selection)label), label.text(), this._axisTitle, fillOpacity, 0.25);
        }
        titleSelection.style("text-anchor", (Object)"middle").attr("x", (Object)x).attr("y", (Object)y).attr("transform", (Object)transform).attr("dy", (Object)dy);
        Double width = Math.abs(ObjectConverter.toDouble(axisRange.get(0)) - ObjectConverter.toDouble(axisRange.get(1)));
        if (_usePreferredSize && this._titleSize.getWidth() > width) {
            Double height = axisWidth;
            this._textFlow.wrap(false).truncate(true).textTruncateIndicator("...").extent(width.intValue(), height.intValue());
            Selector text = g.selectAll("text." + this._axisTitleClass + "." + this._orient);
            final AxisComponentUtil self = this;
            if (Rave.getTransitions((SceneNode)text.node(), null).size() > 0) {
                Rave.transition((Selection)text).each("end", (RunFunction)new RunFunction<SceneNode>(){

                    public Object run(SceneNode context, Object ... args) {
                        Rave.select((SceneNode)context).call((RunFunction)self._textFlow, new Object[0]);
                        return null;
                    }
                });
            } else {
                text.call((RunFunction)this._textFlow, new Object[0]);
            }
        }
    }

    private void handleAxisText(Selector g) {
        FontChecker fontChecker;
        Selector axisSelector = g.selectAll("g.axis");
        this.stopLabelDroppingUpdate();
        Selector labels = axisSelector.selectAll("g.tick").selectAll("text");
        double duration = 0.0;
        double delay = 0.0;
        Selection g2 = Rave.transition((Selection)g);
        if (g2.isTransition()) {
            Transition t2 = (Transition)g2;
            duration = t2.duration();
            delay = t2.delay();
        }
        if ((fontChecker = new FontChecker()) != null) {
            labels.call((RunFunction)fontChecker, new Object[0]);
        }
        g.call((RunFunction)this._tickLabelHandler, new Object[0]);
        if (this._hideOverlappingLabels) {
            List range = this._scale.range();
            double extent = ObjectConverter.toDouble(range.get(1)) - ObjectConverter.toDouble(range.get(0));
            int tickCount = axisSelector.selectAll("g.tick").size();
            if (this._tickLabelHandler.layoutSpillOver() * 2.0 > Math.abs(extent / (double)tickCount)) {
                this.updateLabelDropping(g, duration, delay);
            } else {
                this._tickLabelDrop.reset((Selection<?>)g);
            }
        }
    }

    private void stopLabelDroppingUpdate() {
        this._pendingLabelTimer = false;
    }

    private void updateLabelDropping(final Selector axis, double duration, double delay) {
        final AxisComponentUtil self = this;
        final double start = delay + duration;
        this._tickLabelDrop.remove(false);
        TimerEvent labelCollideCallback = new TimerEvent(){

            public boolean run(double elapsed) {
                if (!self._pendingLabelTimer) {
                    return true;
                }
                axis.call((RunFunction)self._tickLabelDrop, new Object[0]);
                if (elapsed >= start) {
                    self._pendingLabelTimer = false;
                    return true;
                }
                return false;
            }
        };
        if (duration > 0.0) {
            this._pendingLabelTimer = true;
            Rave.timer.addEvent(labelCollideCallback, start);
        } else {
            axis.call((RunFunction)self._tickLabelDrop, new Object[0]);
        }
    }

    public AxisComponentUtil scale(AbstractScale scale) {
        this._scale = scale != null ? scale : null;
        return this;
    }

    public AxisComponentUtil orient(String orient) {
        if ("left".equals(orient) || "bottom".equals(orient) || "right".equals(orient) || "top".equals(orient)) {
            this._orient = orient;
        }
        return this;
    }

    public AxisComponentUtil bounds(RectStruct bounds) {
        this._bounds = bounds;
        this._tickLabelHandler.bounds(bounds);
        return this;
    }

    public AxisComponentUtil tickFormat(ValueFunction<Object, String> tickFormat) {
        this._tickFormat = tickFormat;
        return this;
    }

    public AxisComponentUtil outerTickSize(int outerTickSize) {
        this._outerTickSize = outerTickSize;
        return this;
    }

    public AxisComponentUtil innerTickSize(int innerTickSize) {
        this._innerTickSize = innerTickSize;
        return this;
    }

    public AxisComponentUtil tickInterval(Double tickInterval) {
        this._tickInterval = tickInterval;
        return this;
    }

    public AxisComponentUtil displayAxisTitle(boolean displayAxisTitle) {
        this._displayAxisTitle = displayAxisTitle;
        return this;
    }

    public AxisComponentUtil displayAxisLine(boolean displayAxisLine) {
        this._displayAxisLine = displayAxisLine;
        return this;
    }

    public AxisComponentUtil displayTicks(boolean displayTicks) {
        this._displayTicks = displayTicks;
        return this;
    }

    public AxisComponentUtil displayTickLabels(boolean displayTickLabels) {
        this._tickLabelHandler.displayLabels(displayTickLabels);
        this._displayTickLabels = displayTickLabels;
        return this;
    }

    public AxisComponentUtil showPanZoomTickLabels(boolean showPanZoomTickLabels) {
        this._showPanZoomTickLabels = showPanZoomTickLabels;
        return this;
    }

    public AxisComponentUtil axisTitle(String axisTitle) {
        this._axisTitle = axisTitle;
        return this;
    }

    public AxisComponentUtil axisColor(String axisColor) {
        this._lineColor = axisColor;
        this._tickColor = axisColor;
        return this;
    }

    public AxisComponentUtil lineColor(String lineColor) {
        this._lineColor = lineColor;
        return this;
    }

    public AxisComponentUtil ticks(double tickCount) {
        this._tickCount = tickCount;
        return this;
    }

    public AxisComponentUtil tickGap(Number tickGap) {
        this._tickGap = tickGap;
        this._tickCount = 0.0;
        return this;
    }

    public AxisComponentUtil tickColor(String tickColor) {
        this._tickColor = tickColor;
        return this;
    }

    public AxisComponentUtil labelColor(String labelColor) {
        this._labelStyle.put((Object)"fill", (Object)labelColor);
        return this;
    }

    public AxisComponentUtil labelStyle(String fill, String fontSize, String fontFamily) {
        this._labelStyle.put((Object)"fill", (Object)fill);
        this._labelStyle.put((Object)"font-size", (Object)fontSize);
        this._labelStyle.put((Object)"font-family", (Object)fontFamily);
        return this;
    }

    public AxisComponentUtil titleColor(String titleColor) {
        this._titleStyle.put((Object)"fill", (Object)titleColor);
        return this;
    }

    public AxisComponentUtil titleStyle(String fill, String fontSize, String fontFamily) {
        this._titleStyle.put((Object)"fill", (Object)fill);
        this._titleStyle.put((Object)"font-size", (Object)fontSize);
        this._titleStyle.put((Object)"font-family", (Object)fontFamily);
        return this;
    }

    public AxisComponentUtil padding(int padding) {
        this._padding = padding;
        this._tickLabelHandler.padding(padding);
        return this;
    }

    public AxisComponentUtil allowStagger(boolean allow) {
        this._tickLabelHandler.allowStagger(allow);
        return this;
    }

    public AxisComponentUtil allowRotate45(boolean allow) {
        this._tickLabelHandler.allowRotate45(allow);
        return this;
    }

    public AxisComponentUtil allowRotate90(boolean allow) {
        this._tickLabelHandler.allowRotate90(allow);
        return this;
    }

    public AxisComponentUtil isNumericAxis(boolean _isNumeric) {
        this._tickLabelHandler.isNumericAxis(_isNumeric);
        this._isNumericAxis = _isNumeric;
        return this;
    }

    public AxisComponentUtil labelStyle(OMap<String, Object> labelStyle) {
        this._labelStyle = labelStyle;
        return this;
    }

    public AxisComponentUtil titleStyle(OMap<String, Object> fontStyle) {
        this._titleStyle = fontStyle;
        return this;
    }

    public AxisComponentUtil axisLabelClass(String _className) {
        this._axisLabelClass = _className;
        return this;
    }

    public AxisComponentUtil axisTitleClass(String _className) {
        this._axisTitleClass = _className;
        this._tickLabelHandler.axisTitleSelector("text." + this._axisTitleClass);
        return this;
    }

    public AxisComponentUtil mode(String layoutMode) {
        this._tickLabelHandler.mode(layoutMode);
        return this;
    }

    public AxisComponentUtil rotateAngle(Number angle) {
        this._tickLabelHandler.rotateAngle(angle);
        return this;
    }

    public AxisComponentUtil allowAutomaticAxisLayoutToChangeOrientation(boolean state) {
        this._tickLabelHandler.canChangeLayout(state);
        return this;
    }

    public AxisComponentUtil textTruncateIndicator(String indicator) {
        this._tickLabelHandler.textTruncateIndicator(indicator);
        return this;
    }

    public Axis axis() {
        return this._axis;
    }

    public double layoutSpillOver() {
        return this._tickLabelHandler.layoutSpillOver();
    }

    public double getPreferredSize() {
        double layoutPaddingSize = 0.0;
        double layoutLabelSize = 0.0;
        double titleSize = this._titleSize.getHeight();
        if (this._axis != null) {
            layoutPaddingSize = this._displayTickLabels || this._displayTicks ? this._axis.tickSize() : 0.0;
            double d = layoutLabelSize = this._displayTickLabels ? this._tickLabelHandler.layoutLabelSize() : 0.0;
            if (layoutLabelSize != 0.0) {
                layoutPaddingSize += (double)this._padding;
                layoutPaddingSize += 2.0;
            } else if (titleSize != 0.0) {
                layoutPaddingSize += (double)this._padding;
            }
        }
        return layoutLabelSize + titleSize + layoutPaddingSize;
    }

    public boolean displayTickLabels() {
        return this._displayTickLabels;
    }

    public void invalidateLayout() {
        this._tickLabelHandler.invalidateLayout();
        this._layoutNeeded = true;
    }

    public boolean renderedShapes() {
        return this._renderedShapes;
    }

    public String orient() {
        return this._orient;
    }

    private class AxisTickHandler
    extends AbstractTickHandler {
        private final RunFunction<Selection<?>> _label;
        private final RunFunction<Selection<?>> _tick;

        AxisTickHandler(RunFunction<Selection<?>> label, RunFunction<Selection<?>> tick) {
            this._label = label;
            this._tick = tick;
        }

        public Object run(Object context, Object ... args) {
            this.handle((Selection)args[0]);
            return null;
        }

        public void handle(Selection<?> ticks) {
            ticks.call(this._tick, new Object[0]);
            ticks.call(this._label, new Object[0]);
        }
    }
}

