/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.axis;

import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.svg.AbstractTickHandler;
import com.ibm.vida.rave.core.svg.Axis;
import java.util.List;

public class GridComponentUtil
implements RunFunction<Object> {
    private Axis _axis = null;
    private String _orient = "bottom";
    private RectStruct _bounds = null;
    private boolean _displayGridlines = true;
    private boolean _renderedShapes = false;
    private String _stroke;
    private String _dashArray;
    private AbstractScale<?, ?> _scale;
    private Object[] _ticks = null;
    private List<Object> _tickValues = null;

    public Object run(Object context, Object ... args) {
        Selector g = (Selector)args[0];
        if (!this._displayGridlines || this._scale == null || this._bounds == null) {
            g.selectAll("*").remove();
            this._renderedShapes = false;
            return null;
        }
        if (this._axis == null) {
            this._axis = new Axis();
        }
        this._renderedShapes = true;
        double size = "bottom".equals(this._orient) || "top".equals(this._orient) ? this._bounds.height : this._bounds.width;
        AbstractTickHandler ticksHandler = (AbstractTickHandler)this._axis.ticksHandler();
        double tickSize = this._axis.tickSize();
        double outerTickSize = this._axis.outerTickSize();
        Object tickFormat = this._axis.tickFormat();
        Axis ax = this._axis.scale(this._scale).ticks(this._ticks).tickSize((Object)(-size), (Object)0).tickFormat((Object)"").ticksHandler(null).orient(this._orient);
        ax.tickValues(this._tickValues);
        g.call((RunFunction)ax, new Object[0]);
        this._axis.tickSize((Object)tickSize, (Object)outerTickSize).tickFormat(tickFormat).ticksHandler(ticksHandler);
        g.selectAll("g.tick line").classed("grid-tick", true);
        g.selectAll(".grid-tick").style("stroke", (Object)this._stroke).style("stroke-dasharray", (Object)this._dashArray);
        g.selectAll("path.domain").remove();
        return null;
    }

    public GridComponentUtil scale(AbstractScale<?, ?> _scale) {
        this._scale = _scale;
        return this;
    }

    public GridComponentUtil orient(String orient) {
        if ("left".equals(orient) || "right".equals(orient) || "bottom".equals(orient) || "top".equals(orient)) {
            this._orient = orient;
        }
        return this;
    }

    public GridComponentUtil bounds(RectStruct bounds) {
        this._bounds = bounds;
        return this;
    }

    public GridComponentUtil ticks(Object[] _ticks) {
        this._ticks = _ticks;
        return this;
    }

    public GridComponentUtil tickValues(List<Object> ticks) {
        this._tickValues = ticks;
        return this;
    }

    public GridComponentUtil displayGridlines(boolean displayGridlines) {
        this._displayGridlines = displayGridlines;
        return this;
    }

    public GridComponentUtil gridlineStyle(String gridlineColor, String dashArray) {
        this.gridlineColor(gridlineColor);
        this.dashArray(dashArray);
        return this;
    }

    public GridComponentUtil gridlineColor(String gridlineColor) {
        this._stroke = gridlineColor != null && gridlineColor.length() > 0 ? gridlineColor : null;
        return this;
    }

    public GridComponentUtil dashArray(String dashArray) {
        this._dashArray = dashArray != null && dashArray.length() > 0 ? dashArray : null;
        return this;
    }

    public String orient() {
        return this._orient;
    }

    public boolean displayGridlines() {
        return this._displayGridlines;
    }

    public String gridlineColor() {
        return this._stroke;
    }

    public String dashArray() {
        return this._dashArray;
    }

    public boolean renderedShapes() {
        return this._renderedShapes;
    }
}

