/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.axis.tickLabel;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.AbstractTickHandler;
import com.ibm.vida.rave.core.transition.Transition;
import com.ibm.vida.rave.core.transition.Tween;
import com.ibm.vida.rave.ext.position.drop.DropOverlap;

public final class TickLabelDrop
extends AbstractTickHandler {
    @InlineStringConstant
    private static final String TEXT = "text";
    private boolean removeOverlapping = true;
    private final DropOverlap drop = new DropOverlap();
    private int labelCount = 0;
    private static final double OVERLAP_GAP = 4.0;

    public TickLabelDrop remove(boolean remove) {
        this.removeOverlapping = remove;
        this.drop.remove(this.removeOverlapping);
        return this;
    }

    public boolean remove() {
        return this.removeOverlapping;
    }

    public Object run(Object context, Object ... args) {
        this.drop.setOverlapGap(4.0);
        this.tickLabelDrop((Selection)args[0]);
        return null;
    }

    public void reset(Selection<?> ticks) {
        if (!this.removeOverlapping) {
            Selection labels = ticks.selectAll(TEXT);
            this.drop.reset(labels);
        }
    }

    public void tickLabelDrop(Selection<?> axis) {
        final Selection labels = axis.selectAll(".tick").filter((ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            @SwiftMethodOverload(skipParameters={1})
            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (context.hasProperty("isExit")) {
                    return false;
                }
                return true;
            }
        }).selectAll(TEXT);
        if (!axis.selectAll(TEXT).isTransition()) {
            this.applyLabelDrop(labels);
        } else {
            final ArrayEx steps = new ArrayEx((Object[])new Integer[]{0, 25, 75});
            final TickLabelDrop self = this;
            ((Transition)labels).tween("__pointLabelDrop__", (ValueFunction)new ValueFunction<SceneNode, Tween<SceneNode>>(){

                public Tween<SceneNode> getValue(SceneNode node, Object data, int index, int groupIndex) {
                    if (index == 0) {
                        return new Tween<SceneNode>(){

                            public Object tween(SceneNode _node, double t, boolean apply) {
                                double currentStep = Math.floor(t * 100.0);
                                if (steps.size() > 0 && currentStep < 100.0 && currentStep >= (double)((Integer)steps.get(0)).intValue()) {
                                    steps.remove(0);
                                    self.applyLabelDrop(labels);
                                }
                                return null;
                            }
                        };
                    }
                    return null;
                }
            });
            this.labelCount = 0;
            ((Transition)labels).each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    ++self.labelCount;
                }
            }).each("end", (RunFunction)new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    if (--self.labelCount == 0) {
                        self.applyLabelDrop(labels);
                    }
                    return null;
                }
            });
        }
    }

    private final void applyLabelDrop(Selection<?> labels) {
        labels.call((RunFunction)this.drop, new Object[0]);
    }
}

