/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.axis.tickLabel;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.geom.Dim;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.OrdinalScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.SelectorGroup;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.AbstractTickHandler;
import com.ibm.vida.rave.core.svg.Axis;
import com.ibm.vida.rave.ext.text.wrap.TextFlow;
import java.util.List;

public class TickLabelHandler
extends AbstractTickHandler {
    @InlineStringConstant
    public static final String BOTTOM_ORIENTATION = "bottom";
    @InlineStringConstant
    public static final String TOP_ORIENTATION = "top";
    @InlineStringConstant
    public static final String LEFT_ORIENTATION = "left";
    @InlineStringConstant
    public static final String RIGHT_ORIENTATION = "right";
    private static final int AUTOMODE = -1;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int ROTATE = 2;
    private static final int STAGGER = 3;
    private static final double HORIZONTAL_WEIGHT = 1.1;
    private static final double DEFAULT_ROTATE_RADIENT = 0.7853981633974483;
    private static final double TEXTFLOW_SPACING = 1.2;
    public static final String START = "start";
    public static final String END = "end";
    public static final String MIDDLE = "middle";
    private Axis _axis;
    private boolean _isNumeric;
    private String _axisTitleSelector = "text.axis-title";
    private int _layoutMode = -1;
    private boolean _allowAutoAxisLayoutToChangeOrientaiton = true;
    private int _lastAutomaticAxisLayoutOrientation = -1;
    private double _rotateRadient = 0.7853981633974483;
    private boolean _allowStagger = true;
    private boolean _allowRotate45 = true;
    private boolean _allowRotate90 = true;
    private RectStruct _bounds;
    private double _layoutLabelHeight = 0.0;
    private Dim _layoutTitleSize;
    private double _layoutSpillOver = 0.0;
    private double _layoutLabelSize = 0.0;
    private int _padding = 16;
    private boolean _displayTickLabels = true;
    private String _textTruncationIndicator = "...";
    private final TextFlow _textFlow = new TextFlow();
    OMap<String, RaveRect> cachedBounds;
    private boolean _layoutNeeded = true;
    private Dim _labelExtent;
    private double _averageLabelCharPx = 0.0;

    public TickLabelHandler() {
        this._bounds = new RectStruct(0.0, 0.0, 0.0, 0.0);
        this._layoutTitleSize = new Dim(0.0, 0.0);
        this._labelExtent = new Dim(0.0, 0.0);
    }

    public TickLabelHandler axis(Axis _axis) {
        this._axis = _axis;
        return this;
    }

    public TickLabelHandler bounds(RectStruct _bounds) {
        this._bounds = _bounds;
        return this;
    }

    public TickLabelHandler mode(String layoutMode) {
        this._layoutMode = -1;
        if (layoutMode != null) {
            if (layoutMode.equals("horizontal")) {
                this._layoutMode = 0;
            } else if (layoutMode.equals("stagger")) {
                this._layoutMode = 3;
            } else if (layoutMode.equals("rotate")) {
                this._layoutMode = 2;
            } else if (layoutMode.equals("vertical")) {
                this._layoutMode = 1;
            }
        }
        return this;
    }

    public TickLabelHandler rotateAngle(Number angle) {
        this._rotateRadient = angle != null && this._layoutMode == 2 ? angle.doubleValue() * Math.PI / 180.0 : 0.7853981633974483;
        return this;
    }

    public TickLabelHandler isNumericAxis(boolean _isNumeric) {
        this._isNumeric = _isNumeric;
        return this;
    }

    public TickLabelHandler axisTitleSelector(String _titleSelector) {
        this._axisTitleSelector = _titleSelector;
        return this;
    }

    public TickLabelHandler canChangeLayout(boolean _allowAutoAxisLayoutToChangeOrientaiton) {
        this._allowAutoAxisLayoutToChangeOrientaiton = _allowAutoAxisLayoutToChangeOrientaiton;
        return this;
    }

    public TickLabelHandler displayLabels(boolean _displayTickLabels) {
        this._displayTickLabels = _displayTickLabels;
        return this;
    }

    public TickLabelHandler textTruncateIndicator(String indicator) {
        this._textTruncationIndicator = indicator;
        return this;
    }

    public TickLabelHandler allowRotate90(boolean allow) {
        this._allowRotate90 = allow;
        return this;
    }

    public TickLabelHandler allowRotate45(boolean allow) {
        this._allowRotate45 = allow;
        return this;
    }

    public TickLabelHandler allowStagger(boolean allow) {
        this._allowRotate90 = allow;
        return this;
    }

    public TickLabelHandler padding(int padding) {
        this._padding = padding;
        return this;
    }

    public boolean isAllowAutomaticAxisLayoutToChangeOrientation() {
        return this._allowAutoAxisLayoutToChangeOrientaiton;
    }

    public Object run(Object context, Object ... args) {
        this.handleLabels((Selector)args[0]);
        return null;
    }

    private int determineWhichAutoMode(Selector labels) {
        boolean isHorizontal = this._axis.orient().equals(BOTTOM_ORIENTATION) || this._axis.orient().equals(TOP_ORIENTATION);
        double cellWidth = this._labelExtent.getWidth();
        double cellWidth90 = this._labelExtent.getHeight();
        double labelHeight = 0.0;
        double widestLabel = 0.0;
        double horizontalScore = 0.0;
        double staggerScore = 0.0;
        double rotate45Score = 0.0;
        double rotate90Score = 0.0;
        if (this._isNumeric) {
            int mode = 0;
            if (isHorizontal) {
                mode = this._layoutMode == 1 ? 1 : 0;
            }
            this.measureNumericLabel(labels, mode);
            return mode;
        }
        boolean calcStagger = this._allowStagger && this._layoutMode == -1 || this._layoutMode == 3;
        boolean calcRotate45 = this._allowRotate45 && this._layoutMode == -1;
        boolean calcRotate90 = this._allowRotate90 && this._layoutMode == -1 || this._layoutMode == 1;
        int labelCount = labels.size();
        double spaceFor45Label = 0.0;
        for (int i = 0; i < labelCount; ++i) {
            SceneNode node = (SceneNode)((SelectorGroup)labels.get(0)).get(i);
            RaveRect labelBounds = (RaveRect)this.cachedBounds.get((Object)node.getData().toString());
            if (labelBounds == null || labelBounds.height == 0.0 || labelBounds.width == 0.0) continue;
            double labelWidth = labelBounds.width;
            if (labelWidth > widestLabel) {
                widestLabel = labelWidth;
            }
            labelHeight = labelBounds.height;
            if (this._layoutMode != -1) continue;
            horizontalScore += labelWidth <= cellWidth ? 1.0 : cellWidth / labelWidth;
            if (!isHorizontal) continue;
            if (calcStagger) {
                double spaceForLabel = cellWidth * 2.0;
                if (i == 0 && i == labelCount - 1) {
                    spaceForLabel *= 0.5;
                } else if (i == 0 || i == labelCount - 1) {
                    spaceForLabel *= 0.75;
                }
                staggerScore += labelWidth <= spaceForLabel ? 1.0 : spaceForLabel / labelWidth;
            }
            if (calcRotate45) {
                double space;
                if (spaceFor45Label == 0.0) {
                    spaceFor45Label = cellWidth90 / Math.cos(0.7853981633974483) - labelHeight;
                }
                rotate45Score += labelWidth <= (space = this.calculateRotateDegreeSpace(node, i, spaceFor45Label)) ? 1.0 : space / labelWidth;
            }
            if (!calcRotate90) continue;
            rotate90Score += labelWidth <= cellWidth90 ? 1.0 : cellWidth90 / labelWidth;
        }
        int mode = 0;
        if (this._layoutMode == -1) {
            if (isHorizontal && this._allowStagger) {
                horizontalScore *= 1.1;
                staggerScore *= 1.1;
            }
            if (staggerScore > horizontalScore && staggerScore >= rotate45Score && staggerScore >= rotate90Score) {
                mode = 3;
            } else if (rotate45Score > horizontalScore && rotate45Score >= rotate90Score) {
                mode = 2;
            } else if (rotate90Score > horizontalScore) {
                mode = 1;
            }
        } else {
            mode = !isHorizontal ? 0 : this._layoutMode;
        }
        if (isHorizontal) {
            switch (mode) {
                case 3: {
                    this._layoutLabelSize = labelHeight * 2.0;
                    break;
                }
                case 1: 
                case 2: {
                    double rotationRadient = mode == 1 ? 1.5707963267948966 : this._rotateRadient;
                    double rotatedWidth = widestLabel * Math.sin(rotationRadient) + labelHeight * Math.abs(Math.cos(rotationRadient));
                    if (cellWidth < Math.abs(labelHeight * 0.5 * Math.cos(this._rotateRadient))) {
                        this._layoutLabelSize = Math.min(Math.abs(cellWidth / Math.cos(this._rotateRadient)), rotatedWidth);
                        break;
                    }
                    this._layoutLabelSize = rotatedWidth;
                    break;
                }
                default: {
                    this._layoutLabelSize = labelHeight;
                    break;
                }
            }
        } else {
            this._layoutLabelSize = widestLabel;
            this._layoutSpillOver = labelHeight / 2.0;
        }
        this._layoutLabelHeight = labelHeight;
        return mode;
    }

    private void noLabelLayout(Selector axisSelector) {
        AbstractScale.TickFormatValueFunction tickFunc;
        boolean isHorizontal = this._axis.orient().equals(BOTTOM_ORIENTATION) || this._axis.orient().equals(TOP_ORIENTATION);
        Selector tick = axisSelector.append("g").classed("tick", true);
        Selector tickText = tick.append("text");
        Object singleValue = this._axis.scale().domain().get(0);
        SceneNode node = (SceneNode)((SelectorGroup)tickText.get(0)).get(0);
        Object formatter = this._axis.tickFormat();
        if (formatter == null && (tickFunc = this._axis.scale().tickFormat) != null) {
            formatter = tickFunc.getValue(new Object[]{singleValue});
        }
        ValueFunction tickFormatFn = null;
        String formattedTickText = null;
        if (formatter != null) {
            if (formatter instanceof ValueFunction) {
                tickFormatFn = (ValueFunction)formatter;
            } else {
                formattedTickText = formatter.toString();
            }
        }
        String stringValue = null;
        stringValue = formattedTickText != null ? formattedTickText : (tickFormatFn != null ? (String)tickFormatFn.getValue((Object)node, singleValue, 0, 0) : ObjectConverter.toString(singleValue));
        tickText.text((Object)stringValue);
        RaveRect dim = Rave.util.getBBox(node);
        this._layoutLabelSize = isHorizontal ? dim.height : dim.width;
        this._layoutLabelHeight = dim.height;
        double d = this._layoutSpillOver = isHorizontal ? this._layoutLabelSize / 2.0 : this._layoutLabelHeight / 2.0;
        if (!isHorizontal || this._layoutMode != 0) {
            tickText.text((Object)".0");
            this._layoutLabelSize += Rave.util.getBBox((SceneNode)node).width;
        }
        tick.remove();
    }

    public double layoutLabelSize() {
        return this._layoutLabelSize;
    }

    public void handleLabels(Selector axisSelector) {
        int mode;
        final TickLabelHandler self = this;
        Selector labels = axisSelector.selectAll(".tick").filter((ValueFunction)new ValueFunction<SceneNode, Boolean>(){

            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (context.hasProperty("isExit")) {
                    return false;
                }
                return true;
            }
        }).select((Object)"text");
        double totalChar = 0.0;
        double totalLabelWidthPx = 0.0;
        if (this.cachedBounds == null || this._layoutNeeded) {
            this.cachedBounds = new OMap();
            for (int i = 0; i < labels.size(); ++i) {
                SceneNode label = (SceneNode)((SelectorGroup)labels.get(0)).get(i);
                RaveRect labelBBox = Rave.util.getBBox(label);
                this.cachedBounds.put((Object)label.getData().toString(), (Object)labelBBox);
                totalChar += (double)label.getText().length();
                totalLabelWidthPx += labelBBox.width;
            }
            this._averageLabelCharPx = totalLabelWidthPx / totalChar;
            this.calcTitleExtent(axisSelector);
            this._labelExtent = this.labelExtent(labels);
            if (this._allowAutoAxisLayoutToChangeOrientaiton) {
                this._lastAutomaticAxisLayoutOrientation = mode = this.determineWhichAutoMode(labels);
            }
            if (this._isNumeric) {
                if (labels.size() == 0) {
                    this.noLabelLayout(axisSelector);
                } else {
                    this.measureNumericLabel(labels, this._lastAutomaticAxisLayoutOrientation);
                }
            }
        }
        this._labelExtent = this.labelExtent(labels);
        mode = this._lastAutomaticAxisLayoutOrientation;
        if (!this._isNumeric && this._displayTickLabels) {
            this.doLabelWrapping(labels, mode);
        }
        labels.attr("transform", (ValueFunction)new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                return self.transformPosition(context, index, mode);
            }
        });
        if (mode == 2 || mode == 1) {
            boolean isBottomAxis = this._axis.orient().equals(BOTTOM_ORIENTATION);
            boolean isTopAxis = this._axis.orient().equals(TOP_ORIENTATION);
            if (this._rotateRadient <= 1.5707963267948966 && isBottomAxis || this._rotateRadient > 1.5707963267948966 && isTopAxis) {
                labels.style("text-anchor", (Object)END);
            } else {
                labels.style("text-anchor", (Object)START);
            }
        }
        if (!this._displayTickLabels) {
            this._layoutLabelSize = 0.0;
        }
        this._layoutNeeded = false;
    }

    private String transformPosition(SceneNode context, int i, int mode) {
        double x = 0.0;
        double y = 0.0;
        boolean isBottom = this._axis.orient().equals(BOTTOM_ORIENTATION);
        double rotationAngle = 0.0;
        if (mode == 3) {
            int cellIndex = i;
            if (cellIndex != -1 && cellIndex % 2 == 1) {
                double staggerDirection = isBottom ? 1.0 : -1.0;
                y += this._layoutLabelHeight * staggerDirection;
            }
        } else if (mode == 2 || mode == 1) {
            rotationAngle = mode == 1 ? 1.5707963267948966 : this._rotateRadient;
            double d = rotationAngle = rotationAngle > 1.5707963267948966 ? Math.PI - rotationAngle : -rotationAngle;
            if (isBottom) {
                x = rotationAngle <= 0.0 ? (x -= this._axis.tickSize() - (double)this._padding * 0.25 * Math.sin(rotationAngle)) : (x += this._axis.tickSize() + (double)this._padding * 0.25 * Math.sin(rotationAngle));
                y -= this._axis.tickSize() + this._layoutLabelHeight - this._layoutLabelHeight * Math.cos(rotationAngle);
            } else {
                x = rotationAngle <= 0.0 ? (x += this._axis.tickSize() - (double)this._padding * 0.25 * Math.sin(rotationAngle)) : (x -= this._axis.tickSize() + (double)this._padding * 0.25 * Math.sin(rotationAngle));
                y += this._axis.tickSize() + this._layoutLabelHeight - this._layoutLabelHeight * Math.cos(rotationAngle);
            }
        }
        double rotationDegrees = rotationAngle * 180.0 / Math.PI;
        return "rotate(" + rotationDegrees + ",0,0) translate(" + x + "," + y + ") ";
    }

    private void doLabelWrapping(final Selector labels, final int mode) {
        boolean isHorizontal;
        this._textFlow.valignment(TOP_ORIENTATION);
        if (this._labelExtent == null || this._labelExtent.getWidth() < 0.0 || this._labelExtent.getHeight() < 0.0) {
            return;
        }
        double w = this._labelExtent.getWidth();
        double h = this._labelExtent.getHeight();
        if (mode == 2) {
            w = Math.abs(w * Math.sin(this._rotateRadient)) < Math.abs(this._layoutLabelHeight * 0.5 * Math.cos(this._rotateRadient)) ? Math.abs(w / Math.cos(this._rotateRadient)) : Math.abs(h / Math.sin(this._rotateRadient));
            h = Math.abs(this._layoutLabelHeight / Math.cos(this._rotateRadient));
        } else if (mode == 1) {
            double tmp = w;
            w = h;
            h = tmp;
        }
        boolean allowWrap = mode == 1;
        int hActual = ObjectConverter.toInt((Object)(this._layoutLabelHeight * 1.2));
        if ((double)hActual > h) {
            h = hActual;
        }
        boolean bl = isHorizontal = this._axis.orient().equals(BOTTOM_ORIENTATION) || this._axis.orient().equals(TOP_ORIENTATION);
        if (mode == 0 && !isHorizontal) {
            allowWrap = true;
        }
        final TickLabelHandler self = this;
        final double cellWidth = w;
        final double cellHeight = h;
        ValueFunction<SceneNode, Dim> textExtent = new ValueFunction<SceneNode, Dim>(){

            public Dim getValue(SceneNode context, Object data, int index, int groupIndex) {
                double width = cellWidth;
                double height = cellHeight;
                if (mode == 2) {
                    width = (int)self.calculateRotateDegreeSpace(context, index, cellWidth);
                } else if (mode == 3) {
                    width = index == 0 && index == labels.size() - 1 ? cellWidth : (index == 0 || index == labels.size() - 1 ? cellWidth * 3.0 / 2.0 : cellWidth * 2.0);
                    height = cellHeight / 2.0;
                }
                return new Dim(width, height);
            }
        };
        Selector labelsWrapNeeded = labels.filter((ValueFunction)new ValueFunction<SceneNode, Boolean>((ValueFunction)textExtent){
            final /* synthetic */ ValueFunction val$textExtent;
            {
                this.val$textExtent = valueFunction;
            }

            public Boolean getValue(SceneNode context, Object data, int index, int groupIndex) {
                Dim availableTextSpace;
                RaveRect bounds = (RaveRect)self.cachedBounds.get((Object)context.getData().toString());
                double labelWidth = bounds == null ? (double)context.getText().length() * self._averageLabelCharPx : bounds.width;
                if (labelWidth > (availableTextSpace = (Dim)this.val$textExtent.getValue((Object)context, data, index, groupIndex)).getWidth()) {
                    return true;
                }
                return false;
            }
        });
        this._textFlow.wrap(allowWrap).truncate(true).textTruncateIndicator(this._textTruncationIndicator != null ? this._textTruncationIndicator : "...").spacing(1.2).extent(textExtent);
        if (!labelsWrapNeeded.empty()) {
            labelsWrapNeeded.call((RunFunction)this._textFlow, new Object[0]);
        }
    }

    private void measureNumericLabel(Selector labels, int mode) {
        boolean isHorizontal = this._axis.orient().equals(BOTTOM_ORIENTATION) || this._axis.orient().equals(TOP_ORIENTATION);
        int labelCount = labels.size();
        double widestLabel = 0.0;
        for (int i = 0; i < labelCount; ++i) {
            SceneNode label = (SceneNode)((SelectorGroup)labels.get(0)).get(i);
            RaveRect labelBbox = (RaveRect)this.cachedBounds.get((Object)label.getData().toString());
            if (labelBbox.width > widestLabel) {
                widestLabel = labelBbox.width;
            }
            if (!(labelBbox.height > this._layoutLabelHeight)) continue;
            this._layoutLabelHeight = labelBbox.height;
        }
        if (isHorizontal) {
            this._layoutSpillOver = mode == 1 ? this._layoutLabelHeight / 2.0 : widestLabel / 2.0 + 2.0;
            this._layoutLabelSize = mode == 1 ? widestLabel : this._layoutLabelHeight;
        } else {
            this._layoutSpillOver = this._layoutLabelHeight / 2.0;
            this._layoutLabelSize = widestLabel;
        }
    }

    public Dim labelExtent(Selector labels) {
        boolean isHorizontal = this._axis.orient().equals(BOTTOM_ORIENTATION) || this._axis.orient().equals(TOP_ORIENTATION);
        double w = this._bounds.width;
        double h = this._bounds.height;
        double tickCount = labels.size();
        List range = this._axis.scale().rangeExtent != null ? this._axis.scale().rangeExtent.getValue() : this._axis.scale().range();
        double tickSpace = Math.abs(ObjectConverter.toDouble(range.get(0)) - ObjectConverter.toDouble(range.get(range.size() - 1))) / tickCount;
        if (isHorizontal) {
            w = tickSpace;
        } else {
            h = tickSpace;
        }
        if (isHorizontal) {
            h -= this._axis.tickSize();
            h -= (double)(this._padding / 2);
            if (this._layoutTitleSize.getHeight() != 0.0) {
                h -= this._layoutTitleSize.getHeight();
                h -= (double)(this._padding / 2);
            }
        } else {
            w -= this._axis.tickSize();
            w -= (double)(this._padding / 2);
            if (this._layoutTitleSize.getHeight() != 0.0) {
                w -= this._layoutTitleSize.getHeight();
                w -= (double)(this._padding / 2);
            }
        }
        return new Dim(w, h);
    }

    private void calcTitleExtent(Selector g) {
        String titleText;
        this._layoutTitleSize = new Dim(0.0, 0.0);
        Selector title = g.selectAll(this._axisTitleSelector);
        if (title.size() > 0 && (titleText = title.node().getText()).length() > 0) {
            RaveRect bbox = Rave.util.getBBox(title.node());
            this._layoutTitleSize.setWidth(bbox.width);
            this._layoutTitleSize.setHeight(bbox.height);
        }
    }

    private double calculateRotateDegreeSpace(SceneNode node, int index, double maxWidth) {
        double width = maxWidth;
        double rotatedCosAngle = Math.abs(Math.cos(this._rotateRadient));
        OrdinalScale scale = (OrdinalScale)this._axis.scale();
        double xLabelPos = ObjectConverter.toDouble((Object)scale.getValue(null, Rave.select((SceneNode)node).datum(), index, 0)) + ObjectConverter.toDouble((Object)scale.rangeBand.getValue()) * 0.5;
        RaveRect labelBBox = (RaveRect)this.cachedBounds.get((Object)node.getData().toString());
        double originalLabelWidth = labelBBox != null ? labelBBox.width : (double)node.getText().length() * this._averageLabelCharPx;
        double rotatedLabelWidth = originalLabelWidth * rotatedCosAngle;
        boolean isBottom = this._axis.orient().equals(BOTTOM_ORIENTATION);
        if (isBottom) {
            if (this._rotateRadient <= 1.5707963267948966) {
                if ((xLabelPos -= this._layoutLabelHeight / 4.0) - rotatedLabelWidth < this._bounds.x) {
                    rotatedLabelWidth = xLabelPos - this._bounds.x;
                    width = rotatedLabelWidth / rotatedCosAngle;
                }
            } else {
                rotatedLabelWidth = this._bounds.x + this._bounds.width - xLabelPos;
                width = rotatedLabelWidth / rotatedCosAngle;
            }
        } else if (this._rotateRadient <= 1.5707963267948966) {
            if (xLabelPos + rotatedLabelWidth > this._bounds.x + this._bounds.width) {
                rotatedLabelWidth = this._bounds.x + this._bounds.width - xLabelPos;
                width = rotatedLabelWidth / rotatedCosAngle;
            }
        } else if ((xLabelPos -= this._layoutLabelHeight / 4.0) - rotatedLabelWidth < this._bounds.x) {
            rotatedLabelWidth = xLabelPos - this._bounds.x;
            width = rotatedLabelWidth / rotatedCosAngle;
        }
        if (width > maxWidth) {
            width = maxWidth;
        }
        return Math.abs(width);
    }

    public double layoutSpillOver() {
        return this._layoutSpillOver;
    }

    public Dim layoutTitleSize() {
        return this._layoutTitleSize;
    }

    public TickLabelHandler invalidateLayout() {
        this._layoutLabelSize = 0.0;
        this._layoutTitleSize = new Dim(0.0, 0.0);
        this._layoutLabelHeight = 0.0;
        this._layoutSpillOver = 0.0;
        this.cachedBounds = new OMap();
        this._layoutNeeded = true;
        return this;
    }
}

