/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.geo;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.ExtensionFactory;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.ext.geo.tile.TileLayout;
import com.ibm.vida.rave.ext.geo.tile.TiledMapGenerator;

public final class RaveGeo {
    public static final String Tile_LAYOUT = "tile";
    public static final String TILED_MAP = "tiledMapGenerator";
    @InlineStringConstant
    private static final String EXTENSION_REGISTRATION_STATUS_KEY = "RAVEGEO_EXTENSION_REGISTRATION_STATUS_KEY";

    public static TileLayout tile() {
        return new TileLayout();
    }

    public static TiledMapGenerator tiledMapGenerator() {
        return new TiledMapGenerator();
    }

    private static RegistrationStatus getRegistrationStatus() {
        RegistrationStatus registrationStatus = (RegistrationStatus)RaveContextManager.INSTANCE.getRaveContext().getData(EXTENSION_REGISTRATION_STATUS_KEY);
        if (registrationStatus == null) {
            registrationStatus = new RegistrationStatus();
            RaveContextManager.INSTANCE.getRaveContext().putData(EXTENSION_REGISTRATION_STATUS_KEY, (Object)registrationStatus);
        }
        return registrationStatus;
    }

    public static boolean init() {
        RegistrationStatus registrationStatus = RaveGeo.getRegistrationStatus();
        if (!registrationStatus.registered) {
            registrationStatus.registered = Rave.geo.extension(Tile_LAYOUT, (ExtensionFactory)new ExtensionFactory<TileLayout>(){

                public TileLayout create() {
                    return RaveGeo.tile();
                }
            });
            registrationStatus.registered &= Rave.geo.extension(TILED_MAP, (ExtensionFactory)new ExtensionFactory<TiledMapGenerator>(){

                public TiledMapGenerator create() {
                    return RaveGeo.tiledMapGenerator();
                }
            });
        }
        return registrationStatus.registered;
    }

    private static class RegistrationStatus {
        boolean registered = false;

        private RegistrationStatus() {
        }
    }
}

