/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.geo.tile;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.behavior.Zoom;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geo.BasicProjection;
import com.ibm.vida.rave.core.geo.GeoPathGenerator;
import com.ibm.vida.rave.core.geo.Projection;
import com.ibm.vida.rave.core.geom.Dim;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.nativeImpl.arrays.ArraysUtil;
import com.ibm.vida.rave.core.nativeImpl.xhr.Xhr;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrResult;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.util.Comparator;
import com.ibm.vida.rave.ext.geo.RaveGeo;
import com.ibm.vida.rave.ext.geo.tile.TileLayout;
import com.ibm.vida.rave.ext.geo.tile.TileProviderInfo;
import java.util.Collections;

public class TiledMapGenerator
implements RunFunction<Object> {
    private static final int TILE_SIZE = 256;
    private static final String JSON_KIND = "kind";
    private static final String JSON_SORT_KEY = "sort_key";
    private static final String JSON_PROPERTIES_FEATURE = "properties";
    private static final String TILE_CLASS = "tile";
    private static final String TYPE_PATH = "path";
    private static final String TYPE_IMAGE = "image";
    private static final String CONTAINER_CLASS = "mContainers";
    private double widthVal = 960.0;
    private double heightVal = 960.0;
    private double[] centerPointVal = new double[]{-100.0, 40.0};
    private TileLayout tileLayout;
    private Object vecData;
    private Zoom zoomVal;
    private Projection projectionVal;
    private Selector vectorLayer;
    private GeoPathGenerator path;
    private TileProviderInfo[] providerInfoVal;
    private double[] zoomExtentVal = new double[]{0.0, Double.POSITIVE_INFINITY};
    private double projectionScaleVal = 2097152.0;
    private URLGenerator urlBuilderFn = DEFAULT_URL_GEN;
    private static URLGenerator DEFAULT_URL_GEN = new URLGenerator(){

        @Override
        public String generate(TileProviderInfo providerInfo, ArrayEx<Double> tileInfo) {
            return "http://" + providerInfo.url + tileInfo.get(2) + "/" + tileInfo.get(0) + "/" + tileInfo.get(1) + "." + providerInfo.extension + (providerInfo.access_token == null ? "" : "?access_token=" + providerInfo.access_token);
        }
    };
    private static final ValueFunction<Object, String> TRANSLATE_FUN = new ValueFunction<Object, String>(){

        public String getValue(Object context, Object data, int index, int groupIndex) {
            ArrayEx currentData = (ArrayEx)data;
            return "translate(" + (Double)currentData.get(0) * 256.0 + "," + (Double)currentData.get(1) * 256.0 + ")";
        }
    };
    private static ValueFunction<Object, Object> DATA_FUN = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return data;
        }
    };
    private static final ValueFunction<Object, Object> X_VALUEFUNCTION = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((ArrayEx)data).get(0);
        }
    };
    private static final ValueFunction<Object, Object> Y_VALUEFUNCTION = new ValueFunction<Object, Object>(){

        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((ArrayEx)data).get(1);
        }
    };
    private static final Comparator<JSONObject> SORTKEY_COMPARATOR = new Comparator<JSONObject>(){

        public int compare(JSONObject o1, JSONObject o2) {
            int sort_key1 = (Integer)((JSONObject)o1.get((Object)TiledMapGenerator.JSON_PROPERTIES_FEATURE)).get((Object)TiledMapGenerator.JSON_SORT_KEY);
            int sort_key2 = (Integer)((JSONObject)o2.get((Object)TiledMapGenerator.JSON_PROPERTIES_FEATURE)).get((Object)TiledMapGenerator.JSON_SORT_KEY);
            return sort_key1 - sort_key2;
        }
    };
    private static final ValueFunction<Object, String> CLASS_NAME_EXTRACTOR = new ValueFunction<Object, String>(){

        public String getValue(Object context, Object data, int index, int groupIndex) {
            JSONObject currentData = (JSONObject)data;
            return (String)((JSONObject)currentData.get((Object)TiledMapGenerator.JSON_PROPERTIES_FEATURE)).get((Object)TiledMapGenerator.JSON_KIND);
        }
    };

    public Object run(Object context, Object ... args) {
        this.createTiles((Selector)args[0]);
        return null;
    }

    public void createTiles(final Selector selector) {
        this.tileLayout = RaveGeo.tile().size(new double[]{this.widthVal, this.heightVal});
        this.projectionVal = Rave.geo.mercator.create().scale((Object)(this.projectionScaleVal / 2.0 / Math.PI)).translate(new ArrayEx((Object[])new Double[]{-this.widthVal / 2.0, -this.heightVal / 2.0}));
        ArrayEx projectedCenetr = this.projectionVal.project(new ArrayEx((Object[])new Double[]{this.centerPointVal[0], this.centerPointVal[1]}));
        this.path = Rave.geo.path().projection((BasicProjection)this.projectionVal);
        if (this.zoomVal == null) {
            this.zoomVal = Rave.behavior.zoom();
        }
        ArrayEx invertedCenter = projectedCenetr.map((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Double, Double>(){

            public Double getValue(Double currentValue, int index, ArrayEx<Double> array) {
                return -1.0 * currentValue;
            }
        });
        this.zoomVal.scale(this.projectionVal.scale() * 2.0 * Math.PI).scaleExtent(new Dim(this.zoomExtentVal[0], this.zoomExtentVal[1])).translate(new Point(((Double)invertedCenter.get(0)).doubleValue(), ((Double)invertedCenter.get(1)).doubleValue()));
        final TiledMapGenerator outer = this;
        RunFunction<SceneNode> zoomedFn = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                Point translatePoint = outer.zoomVal.translate();
                ArrayEx arrayExVal = new ArrayEx((Object[])new Double[]{translatePoint.getX(), translatePoint.getY()});
                double zoomScale = outer.zoomVal.scale();
                outer.tileLayout.scale(zoomScale).translate(new double[]{translatePoint.getX(), translatePoint.getY()});
                outer.projectionVal.scale((Object)(zoomScale / 2.0 / Math.PI)).translate(arrayExVal);
                final TileLayout.TilesData tiles = outer.tileLayout.tile();
                if (outer.vectorLayer != null) {
                    outer.vectorLayer.attr("d", (ValueFunction)outer.path);
                }
                Selector groups = selector.selectAll("g.mContainers").data((Object[])outer.providerInfoVal);
                groups.exit().remove();
                groups.enter().append("g").classed(TiledMapGenerator.CONTAINER_CLASS, true);
                groups.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                    public void run(SceneNode context, Object data, int index, int groupIndex) {
                        Selector g = Rave.select((SceneNode)context);
                        TileProviderInfo providerInfo = (TileProviderInfo)data;
                        if (providerInfo.type == TiledMapGenerator.TYPE_IMAGE) {
                            outer.handleImages(g, tiles, providerInfo);
                        } else if (providerInfo.type == TiledMapGenerator.TYPE_PATH) {
                            outer.handleVector(g, tiles, providerInfo);
                        }
                    }
                });
                return null;
            }
        };
        selector.call((RunFunction)this.zoomVal, new Object[0]);
        zoomedFn.run(null, new Object[0]);
        this.zoomVal.on("zoom", (RunFunction)zoomedFn);
        if (this.vecData != null) {
            this.vectorLayer = selector.append(TYPE_PATH);
            this.vectorLayer.datum(this.vecData);
        }
    }

    public double width() {
        return this.widthVal;
    }

    public TiledMapGenerator width(double newVal) {
        this.widthVal = newVal;
        return this;
    }

    public double height() {
        return this.heightVal;
    }

    public TiledMapGenerator height(double newVal) {
        this.heightVal = newVal;
        return this;
    }

    public double projectionScale() {
        return this.projectionScaleVal;
    }

    public TiledMapGenerator projectionScale(double newProjectionScaleVal) {
        this.projectionScaleVal = newProjectionScaleVal;
        return this;
    }

    public TileProviderInfo[] providerInfo() {
        return this.providerInfoVal;
    }

    public TiledMapGenerator providerInfo(TileProviderInfo[] newProviderInfoVal) {
        this.providerInfoVal = newProviderInfoVal;
        return this;
    }

    public double[] center() {
        return this.centerPointVal;
    }

    public TiledMapGenerator center(double[] newCenterPointVal) {
        this.centerPointVal = newCenterPointVal;
        return this;
    }

    public Zoom zoom() {
        return this.zoomVal;
    }

    public TiledMapGenerator zoom(Zoom newZoomVal) {
        this.zoomVal = newZoomVal;
        return this;
    }

    public Projection projection() {
        return this.projectionVal;
    }

    public TiledMapGenerator projection(Projection newProjectionVal) {
        this.projectionVal = newProjectionVal;
        return this;
    }

    public double[] zoomExtent() {
        return this.zoomExtentVal;
    }

    public TiledMapGenerator zoomExtent(double[] newZoomExtent) {
        this.zoomExtentVal = newZoomExtent;
        return this;
    }

    public Object vectorOverlayData() {
        return this.vecData;
    }

    @SwiftMethodOverload(skipParameters={1})
    public TiledMapGenerator vectorOverlayData(Object newVecData) {
        this.vecData = newVecData;
        return this;
    }

    public URLGenerator urlBuilder() {
        return this.urlBuilderFn;
    }

    public TiledMapGenerator urlBuilder(URLGenerator newGen) {
        this.urlBuilderFn = newGen;
        return this;
    }

    private void handleImages(Selector g, TileLayout.TilesData tiles, final TileProviderInfo providerInfo) {
        Selector imageSelector = g.attr("transform", (Object)("scale(" + tiles.scale + ")translate(" + tiles.translate + ")")).selectAll(TYPE_IMAGE).data(tiles.toArray(), DATA_FUN);
        imageSelector.exit().remove();
        final TiledMapGenerator outer = this;
        imageSelector.enter().append(TYPE_IMAGE).attr("xlink:href", (ValueFunction)new ValueFunction<Object, String>(){

            public String getValue(Object context, Object data, int index, int groupIndex) {
                return outer.urlBuilderFn.generate(providerInfo, (ArrayEx<Double>)((ArrayEx)data));
            }
        }).attr("width", (Object)1).attr("height", (Object)1).attr("x", X_VALUEFUNCTION).attr("y", Y_VALUEFUNCTION);
    }

    private void handleVector(Selector g, TileLayout.TilesData tiles, final TileProviderInfo providerInfo) {
        final GeoPathGenerator tilePath = Rave.geo.path().projection((BasicProjection)this.projectionVal);
        Selector vectorTiles = g.attr("transform", (Object)this.matrix2d(tiles.scale, tiles.translate)).selectAll("g.tile").data(tiles.toArray(), DATA_FUN);
        vectorTiles.exit().each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                ((Xhr)context.getProperty("_xhr")).abort();
            }
        }).remove();
        final TiledMapGenerator outer = this;
        vectorTiles.enter().append("g").attr("class", (Object)TILE_CLASS).attr("transform", TRANSLATE_FUN).each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                final Selector current = Rave.select((SceneNode)context);
                final ArrayEx tileInfo = (ArrayEx)data;
                String url = outer.urlBuilderFn.generate(providerInfo, (ArrayEx<Double>)tileInfo);
                context.setProperty("_xhr", (Object)Rave.json.create(url, (Xhr.Callback)new Xhr.Callback<JSONArtifact>(){

                    public void callback(XhrResult error, JSONArtifact response) {
                        double k = Math.pow(2.0, (Double)tileInfo.get(2)) * 256.0;
                        ((Projection)tilePath.projection()).translate(new ArrayEx((Object[])new Double[]{k / 2.0 - (Double)tileInfo.get(0) * 256.0, k / 2.0 - (Double)tileInfo.get(1) * 256.0})).scale((Object)(k / 2.0 / Math.PI));
                        JSONObject jsonResponse = (JSONObject)response;
                        JSONArray features = (JSONArray)jsonResponse.get((Object)"features");
                        Collections.sort(features, SORTKEY_COMPARATOR);
                        current.selectAll(TiledMapGenerator.TYPE_PATH).data(features.toArray()).enter().append(TiledMapGenerator.TYPE_PATH).attr("class", CLASS_NAME_EXTRACTOR).attr("d", (ValueFunction)tilePath);
                    }
                }));
            }
        });
    }

    private String matrix2d(double scale, double[] translate) {
        double k = scale / 256.0;
        double[] transform = new double[]{k, 0.0, 0.0, k, Math.round(translate[0] * scale), Math.round(translate[1] * scale)};
        return "matrix(" + ArraysUtil.toString((double[])transform) + ")";
    }

    @FunctionClass(value="generate")
    public static interface URLGenerator {
        public String generate(TileProviderInfo var1, ArrayEx<Double> var2);
    }
}

