/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.position.drop;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.NodeRect;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.geom.QuadTree;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.geom.RectStruct;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.transform.Matrix;
import com.ibm.vida.rave.core.transform.MatrixUtil;
import java.util.List;

public class DropOverlap
implements RunFunction<Object> {
    @InlineStringConstant
    private static final String VISIBILITY = "visibility";
    @InlineStringConstant
    private static final String HIDDEN = "hidden";
    @InlineStringConstant
    public static final String HIDDEN_FLAG = "__raveOverlapHidden__";
    public static final String HIDDEN_COUNT = "__hiddenCount__";
    private static final QuadTree.ValueFunction<OverlapNode> fx = new QuadTree.ValueFunction<OverlapNode>(){

        public double getValue(OverlapNode node, int index) {
            return node.x;
        }
    };
    private static final QuadTree.ValueFunction<OverlapNode> fy = new QuadTree.ValueFunction<OverlapNode>(){

        public double getValue(OverlapNode node, int index) {
            return node.y;
        }
    };
    private QuadTree<OverlapNode> quadTree = new QuadTree().x(fx).y(fy);
    private boolean removeOverlapping = true;
    private boolean collisionFound = false;
    private double maxRadius = 0.0;
    private Point[] extentPts;
    private double labelGap = 0.0;
    private boolean clippingAllowed = true;
    private boolean changeVisibility = false;
    private RunFunction<SceneNode> hideCallback;
    private RunFunction<SceneNode> clampCallback;
    private RunFunction<SceneNode> showCallback;

    public DropOverlap() {
        final DropOverlap self = this;
        this.hideCallback = new RunFunction<SceneNode>(){

            public SceneNode run(SceneNode context, Object ... args) {
                if (self.removeOverlapping) {
                    context.getParentNode().removeChild(context);
                } else if (!context.hasProperty(DropOverlap.HIDDEN_FLAG)) {
                    context.setAttribute(DropOverlap.VISIBILITY, (Object)DropOverlap.HIDDEN);
                    context.setProperty(DropOverlap.HIDDEN_FLAG, (Object)DropOverlap.HIDDEN);
                    int count = ObjectConverter.toInt((Object)context.getProperty(DropOverlap.HIDDEN_COUNT));
                    context.setProperty(DropOverlap.HIDDEN_COUNT, (Object)(count + 1));
                }
                return null;
            }
        };
        this.clampCallback = new RunFunction<SceneNode>(){

            public SceneNode run(SceneNode context, Object ... args) {
                double moveX = 0.0;
                double moveY = 0.0;
                RaveRect rect = Rave.util.getBBox(context);
                Point[] extent = self.quadTree.extent();
                if (rect == null) {
                    return null;
                }
                if (rect.x < extent[0].getX()) {
                    moveX = extent[0].getX() - rect.x;
                } else if (rect.x + rect.width > extent[1].getX()) {
                    moveX = extent[1].getX() - (rect.x + rect.width);
                }
                if (rect.y < extent[0].getY()) {
                    moveY = extent[0].getY() - rect.y;
                } else if (rect.y + rect.height > extent[1].getY()) {
                    moveY = extent[1].getY() - (rect.y + rect.height);
                }
                Selector node = Rave.select((SceneNode)context);
                Object nodeXcoordinate = node.attr("x");
                Object nodeYcoordinate = node.attr("y");
                double x = nodeXcoordinate == null ? rect.x : ObjectConverter.toDouble((Object)nodeXcoordinate);
                double y = nodeYcoordinate == null ? rect.y : ObjectConverter.toDouble((Object)nodeYcoordinate);
                node.attr("x", (Object)(x + moveX));
                node.attr("y", (Object)(y + moveY));
                return null;
            }
        };
        this.showCallback = new RunFunction<SceneNode>(){

            public SceneNode run(SceneNode context, Object ... args) {
                if (context.hasProperty(DropOverlap.HIDDEN_FLAG)) {
                    context.removeProperty(DropOverlap.HIDDEN_FLAG);
                    int count = ObjectConverter.toInt((Object)context.getProperty(DropOverlap.HIDDEN_COUNT));
                    if (count <= 1) {
                        context.removeProperty(DropOverlap.HIDDEN_COUNT);
                        context.removeAttribute(DropOverlap.VISIBILITY);
                    } else {
                        context.setProperty(DropOverlap.HIDDEN_COUNT, (Object)(count - 1));
                    }
                }
                if (self.changeVisibility) {
                    context.removeAttribute(DropOverlap.VISIBILITY);
                }
                return null;
            }
        };
    }

    public Object run(Object context, Object ... args) {
        this.dropOverlap((Selection)args[0]);
        return null;
    }

    public void setOverlapGap(double gap) {
        this.labelGap = gap;
    }

    public void noClipping() {
        this.clippingAllowed = false;
    }

    public void dropOverlap(Selection<?> s) {
        SceneNode node;
        if (s != null && (node = s.node()) != null) {
            Point[] extent = this.extentPts;
            if (extent == null) {
                RaveRect bbox = Rave.util.getBBox(node.getOwner());
                Point[] ownerExtent = new Point[]{new Point(bbox.x, bbox.y), new Point(bbox.x + bbox.width, bbox.y + bbox.height)};
                extent = ownerExtent;
            }
            final Point[] extentPoints = extent;
            final QuadTree.RootQTNode root = this.quadTree.extent(extent).quadtree((List)new ArrayEx());
            final DropOverlap self = this;
            s.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode sceneNode, Object data, int index, int groupIndex) {
                    if (sceneNode != null) {
                        self.collisionFound = false;
                        OverlapNode overlapNode = new OverlapNode(sceneNode, self.labelGap);
                        if (self.isCollisionCandidate(sceneNode, overlapNode, extentPoints)) {
                            root.visit(self.collide(overlapNode, self.maxRadius));
                            if (!self.collisionFound) {
                                self.showCallback.run((Object)sceneNode, new Object[0]);
                                root.add((Object)overlapNode);
                                self.maxRadius = Math.max(self.maxRadius, overlapNode.radius);
                            } else {
                                self.hideCallback.run((Object)sceneNode, new Object[0]);
                            }
                        }
                    }
                }
            });
        }
    }

    private final boolean isCollisionCandidate(SceneNode sceneNode, OverlapNode overlapNode, Point[] extentPoints) {
        boolean isCandidate;
        Point point0 = extentPoints[0];
        double extentLeft = point0.getX();
        double extentTop = point0.getY();
        Point point1 = extentPoints[1];
        double extentRight = point1.getX();
        double extentBottom = point1.getY();
        if (this.clippingAllowed) {
            isCandidate = ((OverlapNode)overlapNode).boundingRect.left <= extentRight && ((OverlapNode)overlapNode).boundingRect.top <= extentBottom && ((OverlapNode)overlapNode).boundingRect.right >= extentLeft && ((OverlapNode)overlapNode).boundingRect.bottom >= extentTop;
        } else {
            boolean isFullyInside;
            boolean isHalfInside = false;
            boolean bl = isFullyInside = ((OverlapNode)overlapNode).boundingRect.left + this.labelGap / 2.0 >= extentLeft && ((OverlapNode)overlapNode).boundingRect.top >= extentTop && ((OverlapNode)overlapNode).boundingRect.right - this.labelGap / 2.0 <= extentRight && ((OverlapNode)overlapNode).boundingRect.bottom <= extentBottom;
            if (!isFullyInside) {
                boolean bl2 = isHalfInside = (((OverlapNode)overlapNode).boundingRect.left + ((OverlapNode)overlapNode).boundingRect.width / 2.0 < extentRight && ((OverlapNode)overlapNode).boundingRect.right > extentRight || ((OverlapNode)overlapNode).boundingRect.left < extentLeft && ((OverlapNode)overlapNode).boundingRect.right - ((OverlapNode)overlapNode).boundingRect.width / 2.0 > extentLeft) && ((OverlapNode)overlapNode).boundingRect.top > extentTop && ((OverlapNode)overlapNode).boundingRect.bottom < extentBottom || (((OverlapNode)overlapNode).boundingRect.top < extentTop && ((OverlapNode)overlapNode).boundingRect.top + ((OverlapNode)overlapNode).boundingRect.height / 2.0 > extentTop || ((OverlapNode)overlapNode).boundingRect.top + ((OverlapNode)overlapNode).boundingRect.height / 2.0 < extentBottom && ((OverlapNode)overlapNode).boundingRect.bottom > extentBottom) && ((OverlapNode)overlapNode).boundingRect.left > extentLeft && ((OverlapNode)overlapNode).boundingRect.right < extentRight;
                if (isHalfInside) {
                    this.clampCallback.run((Object)sceneNode, new Object[0]);
                    overlapNode.update();
                } else {
                    this.hideCallback.run((Object)sceneNode, new Object[0]);
                }
            }
            isCandidate = isFullyInside || isHalfInside;
        }
        return isCandidate;
    }

    private QuadTree.Visitor<OverlapNode> collide(final OverlapNode node, double radius) {
        final double nx1 = ((OverlapNode)node).boundingRect.left - radius;
        final double nx2 = ((OverlapNode)node).boundingRect.right + radius;
        final double ny1 = ((OverlapNode)node).boundingRect.top - radius;
        final double ny2 = ((OverlapNode)node).boundingRect.bottom + radius;
        final DropOverlap self = this;
        return new QuadTree.Visitor<OverlapNode>(){

            public boolean visit(QuadTree.QTNode<OverlapNode> qtNode, double x1, double y1, double x2, double y2) {
                if (self.collisionFound) {
                    return true;
                }
                if (qtNode.point != null && ((OverlapNode)qtNode.point).node != node.node) {
                    self.collisionFound = DropOverlap.intersect(node.boundingRect, ((OverlapNode)qtNode.point).boundingRect);
                }
                boolean isOutsideQuad = x1 > nx2 || x2 < nx1 || y1 > ny2 || y2 < ny1;
                return self.collisionFound || isOutsideQuad;
            }
        };
    }

    private static boolean intersect(NodeRect r1, NodeRect r2) {
        return !(r2.left > r1.right || r2.right < r1.left || r2.top > r1.bottom || r2.bottom < r1.top);
    }

    public DropOverlap remove(boolean remove) {
        this.removeOverlapping = remove;
        return this;
    }

    public DropOverlap changeVisibilityAllowed(boolean changeVisibility) {
        this.changeVisibility = changeVisibility;
        return this;
    }

    public boolean remove() {
        return this.removeOverlapping;
    }

    public Point[] extent() {
        return this.extentPts;
    }

    public DropOverlap extent(Point[] pt) {
        this.extentPts = pt;
        return this;
    }

    public DropOverlap reset(Selection<?> s) {
        final DropOverlap self = this;
        s.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                self.showCallback.run((Object)context, new Object[0]);
            }
        });
        return this;
    }

    private final class OverlapNode {
        private final SceneNode node;
        private final double gap;
        private final double radius;
        private NodeRect boundingRect;
        private double x;
        private double y;

        public OverlapNode(SceneNode sceneNode, double gap) {
            this.node = sceneNode;
            this.gap = gap;
            this.calculateBounds();
            this.radius = 0.5 * Math.max(this.boundingRect.width, this.boundingRect.height);
        }

        public void update() {
            this.calculateBounds();
        }

        private void calculateBounds() {
            Matrix transform;
            RaveRect bbox = Rave.util.getBBox(this.node);
            RectStruct bounding = new RectStruct(bbox.x, bbox.y, bbox.width, bbox.height);
            if (this.node.getAttribute("transform") != null && (transform = this.node.getCTM()) != null) {
                bounding = MatrixUtil.transformBounds((RectStruct)bounding, (Matrix)transform);
            }
            this.boundingRect = new NodeRect(bounding.x - this.gap / 2.0, bounding.x + bounding.width + this.gap / 2.0, bounding.y + bounding.height, bounding.y, bounding.width + this.gap, bounding.height);
            this.x = bounding.x + 0.5 * bounding.width;
            this.y = bounding.y + 0.5 * bounding.height;
        }
    }
}

