/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.position.place;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.event.Dispatcher;
import com.ibm.vida.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.ext.position.place.AnchorPoint;
import com.ibm.vida.rave.ext.position.place.LabelBox;
import java.util.ArrayList;
import java.util.List;

public final class LabelPositioning {
    private double totalDistance = Double.MAX_VALUE;
    private Dispatcher<EventObject> event = Dispatcher.create((String[])new String[]{"start", "tick", "end"});
    private List<LabelBox> lab = new ArrayList<LabelBox>();
    private List<AnchorPoint> anc = new ArrayList<AnchorPoint>();
    private Object _energy = null;
    private ValueFunction<? super LabelPositioning, Number> _schedule = null;
    private double w = 1.0;
    private double h = 1.0;
    private double malpha = 0.0;
    private double max_move = 5.0;
    private double max_angle = 0.5;
    private double acc = 0.0;
    private double rej = 0.0;
    private double w_len = 0.2;
    private double w_inter = 1.0;
    private double w_lab2 = 30.0;
    private double w_lab_anc = 30.0;
    private double w_orient = 3.0;
    private double currT;
    private int nsweeps = 500;

    public LabelPositioning energy(ValueFunction<? super LabelPositioning, Number> valueFn) {
        this._energy = valueFn;
        return this;
    }

    public LabelPositioning energy(Number value) {
        this._energy = value;
        return this;
    }

    public Object energy() {
        return this._energy;
    }

    public LabelPositioning schedule(ValueFunction<? super LabelPositioning, Number> valueFn) {
        this._schedule = valueFn;
        return this;
    }

    public Object schedule() {
        return this._schedule;
    }

    private double calculateEnergy(int index) {
        int m = this.lab.size();
        double ener = 0.0;
        LabelBox currentLabel = this.lab.get(index);
        AnchorPoint currentAnchor = this.anc.get(index);
        double dx = currentLabel.x - currentAnchor.x;
        double dy = currentAnchor.y - currentLabel.y;
        double dist = Math.sqrt(dx * dx + dy * dy);
        boolean overlap = true;
        if (dist > 0.0) {
            ener += dist * this.w_len;
        }
        ener = dx > 0.0 && dy > 0.0 ? (ener += 0.0 * this.w_orient) : (dx < 0.0 && dy > 0.0 ? (ener += 1.0 * this.w_orient) : ((dx /= dist) < 0.0 && (dy /= dist) < 0.0 ? (ener += 2.0 * this.w_orient) : (ener += 3.0 * this.w_orient)));
        double x21 = currentLabel.x;
        double y21 = currentLabel.y - currentLabel.height + 2.0;
        double x22 = currentLabel.x + currentLabel.width;
        double y22 = currentLabel.y + 2.0;
        for (int i = 0; i < m; ++i) {
            double overlap_area;
            double y_overlap;
            double x_overlap;
            double y12;
            double x12;
            double y11;
            double x11;
            LabelBox otherLabel = this.lab.get(i);
            AnchorPoint otherAnchor = this.anc.get(i);
            if (i != index) {
                overlap = LabelPositioning.leaderLinesIntersect(otherAnchor.x, otherLabel.x, otherAnchor.x, otherLabel.x, otherAnchor.y, otherLabel.y, otherAnchor.y, otherLabel.y);
                if (overlap) {
                    ener += this.w_inter;
                }
                x11 = otherLabel.x;
                y11 = otherLabel.y - otherLabel.height + 2.0;
                x12 = otherLabel.x + otherLabel.width;
                y12 = otherLabel.y + 2.0;
                x_overlap = Math.max(0.0, Math.min(x12, x22) - Math.max(x11, x21));
                y_overlap = Math.max(0.0, Math.min(y12, y22) - Math.max(y11, y21));
                overlap_area = x_overlap * y_overlap;
                ener += overlap_area * this.w_lab2;
            }
            double r = otherAnchor.r * 2.0;
            x11 = otherAnchor.x - r;
            y11 = otherAnchor.y - r;
            x12 = otherAnchor.x + r;
            y12 = otherAnchor.y + r;
            x_overlap = Math.max(0.0, Math.min(x12, x22) - Math.max(x11, x21));
            y_overlap = Math.max(0.0, Math.min(y12, y22) - Math.max(y11, y21));
            overlap_area = x_overlap * y_overlap;
            ener += overlap_area * this.w_lab_anc;
        }
        return ener;
    }

    private void mcmove(double currTemp, double old_energy, int i) {
        LabelBox currentLabel = this.lab.get(i);
        AnchorPoint currentAnchor = this.anc.get(i);
        double x_old = currentLabel.x;
        double y_old = currentLabel.y;
        currentLabel.x += (Math.random() - 0.5) * this.max_move;
        currentLabel.y += (Math.random() - 0.5) * this.max_move;
        this.compareOldEnergy(currTemp, old_energy, i, currentLabel, currentAnchor, x_old, y_old);
    }

    private void mcrotate(double currTemp, double old_energy, int i) {
        LabelBox currentLabel = this.lab.get(i);
        AnchorPoint currentAnchor = this.anc.get(i);
        double x_old = currentLabel.x;
        double y_old = currentLabel.y;
        double angle = (Math.random() - 0.5) * this.max_angle;
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        currentLabel.x -= currentAnchor.x;
        currentLabel.y -= currentAnchor.y;
        double x_new = currentLabel.x * c - currentLabel.y * s;
        double y_new = currentLabel.x * s + currentLabel.y * c;
        currentLabel.x = x_new + currentAnchor.x;
        currentLabel.y = y_new + currentAnchor.y;
        this.compareOldEnergy(currTemp, old_energy, i, currentLabel, currentAnchor, x_old, y_old);
    }

    private void compareOldEnergy(double currTemp, double old_energy, int i, LabelBox currentLabel, AnchorPoint currentAnchor, double x_old, double y_old) {
        if (currentLabel.x > this.w) {
            currentLabel.x = x_old;
        }
        if (currentLabel.x < 0.0) {
            currentLabel.x = x_old;
        }
        if (Math.abs(currentLabel.x - currentAnchor.x) > this.totalDistance) {
            currentLabel.x = x_old;
        }
        if (currentLabel.y > this.h) {
            currentLabel.y = y_old;
        }
        if (currentLabel.y < 0.0) {
            currentLabel.y = y_old;
        }
        if (Math.abs(currentLabel.y - currentAnchor.y) > this.totalDistance) {
            currentLabel.y = y_old;
        }
        double new_energy = this._energy != null ? ObjectConverter.toDouble((Object)(this._energy instanceof ValueFunction ? ((ValueFunction)this._energy).getValue((Object)this, this.lab, i, -1) : this._energy)) : this.calculateEnergy(i);
        double delta_energy = new_energy - old_energy;
        if (Math.random() < Math.exp(-delta_energy / currTemp)) {
            this.acc += 1.0;
        } else {
            currentLabel.x = x_old;
            currentLabel.y = y_old;
            this.rej += 1.0;
        }
    }

    public RunFunction<? super EventObject> on(String type) {
        return this.event.on(type);
    }

    public LabelPositioning on(String type, RunFunction<EventObject> listener) {
        this.event.on(type, listener);
        return this;
    }

    public LabelPositioning start() {
        this.currT = 1.0;
        this.alpha(0.1);
        return this;
    }

    public boolean tick() {
        int m = this.lab.size();
        double initialT = 1.0;
        if (this.currT < 0.005) {
            this.malpha = 0.0;
            EventObject eo = new EventObject("end", 0.0);
            ((Dispatcher.DispatcherEvent)this.event.get((Object)eo.type)).fire((Object)eo, new Object[]{eo});
            return true;
        }
        for (int j = 0; j < m; ++j) {
            int i = (int)Math.floor(Math.random() * (double)this.lab.size());
            double old_energy = this._energy != null ? ObjectConverter.toDouble((Object)(this._energy instanceof ValueFunction ? ((ValueFunction)this._energy).getValue((Object)this, this.lab, i, -1) : this._energy)) : this.calculateEnergy(i);
            if (!(old_energy > 500.0)) continue;
            if (Math.random() < 0.5) {
                this.mcmove(this.currT, old_energy, i);
                continue;
            }
            this.mcrotate(this.currT, old_energy, i);
        }
        this.currT = this._schedule != null ? ObjectConverter.toDouble((Object)this._schedule.getValue((Object)this, this.lab, -1, -1)) : (this.currT -= initialT / (double)this.nsweeps);
        EventObject eo = new EventObject("tick", this.malpha);
        ((Dispatcher.DispatcherEvent)this.event.get((Object)eo.type)).fire((Object)eo, new Object[]{eo});
        return false;
    }

    public LabelPositioning stop() {
        return this.alpha(0.0);
    }

    private LabelPositioning alpha(double x) {
        if (this.malpha != 0.0) {
            this.malpha = x > 0.0 ? x : 0.0;
        } else if (x > 0.0) {
            this.malpha = x;
            EventObject eo = new EventObject("start", x);
            ((Dispatcher.DispatcherEvent)this.event.get((Object)eo.type)).fire((Object)eo, new Object[]{eo});
            final LabelPositioning labelers = this;
            Rave.timer.addEvent(new TimerEvent(){

                public boolean run(double elapsed) {
                    return labelers.tick();
                }
            });
        }
        return this;
    }

    static boolean leaderLinesIntersect(double anc1x, double lab1x, double anc2x, double lab2x, double anc1y, double lab1y, double anc2y, double lab2y) {
        double denom = (lab2y - anc2y) * (lab1x - anc1x) - (lab2x - anc2x) * (lab1y - anc1y);
        double numera = (lab2x - anc2x) * (anc1y - anc2y) - (lab2y - anc2y) * (anc1x - anc2x);
        double numerb = (lab1x - anc1x) * (anc1y - anc2y) - (lab1y - anc1y) * (anc1x - anc2x);
        double mua = numera / denom;
        double mub = numerb / denom;
        return !(mua < 0.0 || mua > 1.0 || mub < 0.0 || mub > 1.0);
    }

    public double maxDistance() {
        return this.totalDistance;
    }

    public LabelPositioning maxDistance(double maxDistance) {
        this.totalDistance = maxDistance;
        return this;
    }

    public LabelPositioning numberOfSweeps(int sweeps) {
        this.nsweeps = sweeps;
        return this;
    }

    public int numberOfSweeps() {
        return this.nsweeps;
    }

    public double currentTemperature() {
        return this.currT;
    }

    public LabelPositioning width(double width) {
        this.w = width;
        return this;
    }

    public double width() {
        return this.w;
    }

    public LabelPositioning height(double height) {
        this.h = height;
        return this;
    }

    public double height() {
        return this.h;
    }

    public List<LabelBox> label() {
        return this.lab;
    }

    public LabelPositioning label(List<LabelBox> labelList) {
        this.lab = labelList;
        return this;
    }

    public LabelPositioning anchor(List<AnchorPoint> anchorList) {
        this.anc = anchorList;
        return this;
    }

    public List<AnchorPoint> anchor() {
        return this.anc;
    }

    public static final class EventObject {
        public final String type;
        public final double alpha;

        EventObject(String type, double alpha) {
            this.type = type;
            this.alpha = alpha;
        }
    }
}

