/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.statistics.outliersUtility;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.ext.statistics.outliersUtility.RaveOutlier;
import java.util.ArrayList;
import java.util.List;

@FunctionClass(value="peirceCriterion")
public class PeirceCriterion
extends RaveOutlier {
    private int mUnknowns = 1;

    private static double pNorm(double x) {
        double _x = x;
        double a1 = 0.254829592;
        double a2 = -0.284496736;
        double a3 = 1.421413741;
        double a4 = -1.453152027;
        double a5 = 1.061405429;
        double p = 0.3275911;
        double sign = 1.0;
        if (_x < 0.0) {
            sign = -1.0;
        }
        _x = Math.abs(_x);
        double t = 1.0 / (1.0 + 0.3275911 * _x);
        double y = 1.0 - ((((1.061405429 * t + -1.453152027) * t + 1.421413741) * t + -0.284496736) * t + 0.254829592) * t * Math.exp(-_x * _x);
        return sign * y;
    }

    public double modelUnknowns() {
        return this.mUnknowns;
    }

    public PeirceCriterion modelUnknowns(int unknowns) {
        this.mUnknowns = unknowns;
        return this;
    }

    private ArrayEx<Integer> identifyOutliers(List<Number> values) {
        Object[] dataArray = values.toArray();
        double mean = Rave.mean((Object[])dataArray).doubleValue();
        double variance = Rave.variance((Object[])dataArray).doubleValue();
        double std = Math.sqrt(variance);
        ArrayEx remainingDataIndexes = Rave.range((Object)0, (Object)values.size());
        ArrayEx outliers = new ArrayEx();
        boolean foundOutliers = true;
        int lastOutlierSize = 0;
        while (foundOutliers) {
            foundOutliers = this.findOutliers(values, (List<Number>)remainingDataIndexes, (List<Integer>)outliers, mean, std, lastOutlierSize + 1);
            lastOutlierSize = outliers.size() - lastOutlierSize;
        }
        return outliers;
    }

    private boolean findOutliers(List<Number> originalData, List<Number> remainingDataIndexes, List<Integer> outliers, double originalMean, double standardDev, int outliersToRemove) {
        int i;
        double r = Math.sqrt(PeirceCriterion.calculateMaxDeviation(originalData.size(), outliersToRemove, this.mUnknowns));
        double maxDeviation = r * standardDev;
        ArrayList<Integer> foundOutliers = new ArrayList<Integer>();
        for (i = 0; i < remainingDataIndexes.size(); ++i) {
            int dataIndex = remainingDataIndexes.get(i).intValue();
            double input = originalData.get(dataIndex).doubleValue();
            if (!(Math.abs(input - originalMean) > maxDeviation)) continue;
            outliers.add(dataIndex);
            foundOutliers.add(i);
        }
        for (i = foundOutliers.size() - 1; i >= 0; --i) {
            int index = (Integer)foundOutliers.get(i);
            remainingDataIndexes.remove(index);
        }
        return foundOutliers.size() > 0;
    }

    private static double calculateMaxDeviation(int size, int outliers, int model_unknowns) {
        double _outliers = outliers;
        double x2 = 0.0;
        if (size > 1) {
            double q = Math.pow(_outliers, _outliers / (double)size) * Math.pow((double)size - _outliers, ((double)size - _outliers) / (double)size) / (double)size;
            double rNew = 1.0;
            double rOld = 0.0;
            while (Math.abs(rNew - rOld) > (double)size * 2.0E-16) {
                double lamda;
                double ldiv = Math.pow(rNew, _outliers);
                if (ldiv == 0.0) {
                    ldiv = 1.0E-6;
                }
                if ((x2 = 1.0 + ((double)(size - model_unknowns) - _outliers) / _outliers * (1.0 - Math.pow(lamda = Math.pow(Math.pow(q, size) / ldiv, 1.0 / ((double)size - _outliers)), 2.0))) < 0.0) {
                    x2 = 0.0;
                    rOld = rNew;
                    continue;
                }
                rOld = rNew;
                rNew = Math.exp((x2 - 1.0) / 2.0) * (1.0 - PeirceCriterion.pNorm(Math.sqrt(x2) / Math.sqrt(2.0)));
            }
        }
        return x2;
    }

    @Override
    public <E> ArrayEx<Integer> outliers(List<E> data) {
        final PeirceCriterion self = this;
        ArrayEx values = ArrayEx.map(data, (ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<E, Number>(){

            public Number getValue(E currentValue, int i, ArrayEx<E> array) {
                return (Number)self._value.getValue((Object)self, currentValue, i, -1);
            }
        });
        return this.identifyOutliers((List<Number>)values);
    }
}

