/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.text;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.ExtensionFactory;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.ext.text.nativeImpl.FontChecker;
import com.ibm.vida.rave.ext.text.wrap.TextFlow;

public class TextExtensions {
    private static final String TEXTFLOW_EXTENSION = "textflow";
    private static final String FONTCHECKER_EXTENSION = "fontchecker";
    @InlineStringConstant
    private static final String EXTENSION_REGISTRATION_STATUS_KEY = "TEXTEXTENSIONS_EXTENSION_REGISTRATION_STATUS_KEY";

    private static RegistrationStatus getRegistrationStatus() {
        RegistrationStatus registrationStatus = (RegistrationStatus)RaveContextManager.INSTANCE.getRaveContext().getData(EXTENSION_REGISTRATION_STATUS_KEY);
        if (registrationStatus == null) {
            registrationStatus = new RegistrationStatus();
            RaveContextManager.INSTANCE.getRaveContext().putData(EXTENSION_REGISTRATION_STATUS_KEY, (Object)registrationStatus);
        }
        return registrationStatus;
    }

    public static boolean init() {
        RegistrationStatus registrationStatus = TextExtensions.getRegistrationStatus();
        if (!registrationStatus.registered) {
            registrationStatus.registered &= Rave.capabilities.extension(TEXTFLOW_EXTENSION, (ExtensionFactory)new ExtensionFactory<TextFlow>(){

                public TextFlow create() {
                    return new TextFlow();
                }
            });
            registrationStatus.registered &= Rave.capabilities.extension(FONTCHECKER_EXTENSION, (ExtensionFactory)new ExtensionFactory<FontChecker>(){

                public FontChecker create() {
                    return new FontChecker();
                }
            });
        }
        return registrationStatus.registered;
    }

    private static class RegistrationStatus {
        boolean registered = false;

        private RegistrationStatus() {
        }
    }
}

