/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.text.internal.wrap;

import com.ibm.vida.rave.ext.text.internal.nativeImpl.TextLength;
import com.ibm.vida.rave.ext.text.internal.wrap.TextData;
import com.ibm.vida.rave.ext.text.internal.wrap.TextOperation;

public class FitOperation
extends TextOperation {
    @Override
    protected boolean _runPrecondition() {
        return this._text == null || Math.min(this._maxFontSize, this._minFontSize) > this._height || Math.min(this._maxFontSize, this._minFontSize) > this._width || this._text.isEmpty();
    }

    @Override
    protected void _doRun(TextData textData) {
        double min_font;
        this.createContext();
        double optimalFontSize = this._approximate();
        double d = min_font = this._minFontSize > this._maxFontSize ? this._maxFontSize : this._minFontSize;
        if (optimalFontSize > this._maxFontSize) {
            this._forceFontSize((int)this._maxFontSize, this._font);
            this._initFont(textData, this._font, this._maxFontSize);
            this._truncateOrClip(this._text, textData);
            textData.font = this._font;
            textData.fontSize = this._maxFontSize;
            return;
        }
        if (optimalFontSize <= min_font) {
            this._forceFontSize((int)min_font, this._font);
            this._initFont(textData, this._font, min_font);
            this._truncateOrClip(this._text, textData);
            textData.font = this._font;
            textData.fontSize = min_font;
            return;
        }
        int size = (int)optimalFontSize;
        this._forceFontSize(size, this._font);
        this._initFont(textData, this._font, size);
        boolean tooWide = false;
        while ((tooWide = this._measureText(this._text) > this._width) && (double)size > min_font) {
            this._forceFontSize(--size, this._font);
            this._initFont(textData, this._font, size);
        }
        if (tooWide) {
            this._truncateOrClip(this._text, textData);
        } else {
            textData.add(this._text);
        }
        textData.font = this._font;
        textData.fontSize = size;
    }

    protected double _approximate() {
        double tenPtWidth = TextLength.getTenPtLength(this._text, this._font.fontFamily, this._font.fontStyle);
        double optimal = Math.ceil(this._width * 10.0 / tenPtWidth);
        return Math.min(optimal, this._height);
    }
}

