/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.text.internal.wrap;

import com.ibm.vida.rave.ext.text.internal.wrap.TextData;
import com.ibm.vida.rave.ext.text.internal.wrap.WrapOperation;
import java.util.ArrayList;

public class FitWrapOperation
extends WrapOperation {
    @Override
    protected boolean _runPrecondition() {
        return this._text == null || Math.min(this._maxFontSize, this._minFontSize) > this._height || Math.min(this._maxFontSize, this._minFontSize) > this._width || this._text.isEmpty();
    }

    @Override
    protected void _doRun(TextData textData) {
        double min_font;
        String[] words = this._splitTextIntoWords(this._text);
        this.createContext();
        double optimalFontSize = this._approximate();
        double d = min_font = this._minFontSize > this._maxFontSize ? this._maxFontSize : this._minFontSize;
        if (optimalFontSize >= this._maxFontSize) {
            this._forceFontSize((int)this._maxFontSize, this._font);
            this._initFont(textData, this._font, this._maxFontSize);
            this._wrap(textData, words);
            textData.font = this._font;
            textData.fontSize = this._maxFontSize;
            return;
        }
        if (optimalFontSize <= min_font) {
            this._forceFontSize((int)min_font, this._font);
            this._initFont(textData, this._font, min_font);
            this._wrap(textData, words);
            textData.font = this._font;
            textData.fontSize = min_font;
            return;
        }
        double size = optimalFontSize;
        while (size - min_font > 0.0 && (textData.length() == 0 || textData.truncated || textData.clipped)) {
            textData.tooTall = false;
            this._forceFontSize((int)size, this._font);
            textData.lines = new ArrayList<String>();
            this._initFont(textData, this._font, size);
            this._wrap(textData, words);
            textData.font = this._font;
            textData.fontSize = size;
            size -= 1.0;
        }
    }

    protected double _approximate() {
        int L = this._text.length();
        double sqrt = Math.sqrt(L);
        double cell_width = this._width / sqrt;
        double cell_height = this._height / sqrt;
        cell_height = Math.min(cell_height, this._width);
        cell_width = Math.min(this._height, cell_width);
        return Math.ceil((cell_width + cell_height) / 2.0);
    }
}

