/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.text.internal.wrap;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.nativeImpl.graphicUtils.RenderingContext;
import com.ibm.vida.rave.ext.text.internal.nativeImpl.WordSplitter;
import com.ibm.vida.rave.ext.text.internal.wrap.FitOperation;
import com.ibm.vida.rave.ext.text.internal.wrap.FitWrapOperation;
import com.ibm.vida.rave.ext.text.internal.wrap.FontStyleStruct;
import com.ibm.vida.rave.ext.text.internal.wrap.TextData;
import com.ibm.vida.rave.ext.text.internal.wrap.TruncateOperation;
import com.ibm.vida.rave.ext.text.internal.wrap.WrapOperation;

@FunctionClass(value="run")
public abstract class TextOperation {
    public static final byte NONE = 0;
    public static final byte WRAP = 1;
    public static final byte FIT = 2;
    public static final byte WRAP_FIT = 3;
    private RenderingContext _context;
    protected String _text;
    protected double _width = 0.0;
    protected double _height = 0.0;
    protected double _ems = 1.0;
    protected double _maxFontSize = Double.POSITIVE_INFINITY;
    protected double _fontSize = 10.0;
    protected double _minFontSize = 4.0;
    protected FontStyleStruct _font = new FontStyleStruct();
    protected String _textOverflow = "...";
    protected int _overflowMin = 0;

    public TextOperation text(String text) {
        this._text = text;
        return this;
    }

    public TextOperation size(double width, double height) {
        this._width = width;
        this._height = height;
        return this;
    }

    public TextOperation font(FontStyleStruct font) {
        this._font = font;
        return this;
    }

    public TextOperation em(double ems) {
        this._ems = ems;
        return this;
    }

    public TextOperation maxFontSize(double size) {
        this._maxFontSize = size;
        return this;
    }

    public TextOperation fontSize(double size) {
        this._fontSize = size;
        return this;
    }

    public TextOperation minFontSize(double size) {
        this._minFontSize = size;
        return this;
    }

    protected abstract void _doRun(TextData var1);

    public TextData run() {
        TextData lines = new TextData();
        lines.font = this._font;
        if (this._runPrecondition()) {
            return lines;
        }
        this._doRun(lines);
        if (this._context != null) {
            Rave.canvas.disposeContext(this._context);
            this._context = null;
        }
        return lines;
    }

    protected boolean _runPrecondition() {
        return this._text == null || this._fontSize > this._height || this._text.isEmpty();
    }

    protected void createContext() {
        this._context = Rave.canvas.create(2.0, 2.0).getContext("2d", new Object[0]);
    }

    protected double _measureText(String text) {
        return this._context.measureText((String)text).width;
    }

    protected void _forceFontSize(int size, FontStyleStruct font) {
        font.fontSize = size + "px";
    }

    protected boolean _truncate() {
        return this._textOverflow != null;
    }

    protected boolean _clip() {
        return !this._truncate();
    }

    protected String _truncateOrClip(String testLine, TextData lines) {
        String line;
        boolean truncate = this._truncate();
        String string = line = truncate ? this._ellipsize(testLine, lines) : this._clip(testLine, lines);
        if (line == null || line.isEmpty()) {
            return line;
        }
        lines.add(line);
        return line;
    }

    protected String _clip(String text, TextData lines) {
        lines.truncated = false;
        int index = text.length();
        if (index == 0) {
            lines.clipped = false;
            return text;
        }
        String testLine = text.substring(0, index);
        while (this._measureText(testLine) > this._width && --index > 0) {
            testLine = testLine.substring(0, index);
            lines.clipped = true;
        }
        return testLine;
    }

    protected String _doEllipsize(String text, TextData lines) {
        int marker = text.length();
        marker = marker < this._overflowMin ? 0 : marker;
        String testLine = text.substring(0, marker) + " ";
        ++marker;
        boolean exit = false;
        while (this._measureText(testLine.concat(this._textOverflow)) > this._width && !exit) {
            if (--marker < this._overflowMin) {
                marker = 0;
                exit = true;
            }
            testLine = testLine.substring(0, marker);
        }
        if (this._measureText(testLine.concat(this._textOverflow)) > this._width) {
            lines.truncated = false;
            return null;
        }
        lines.truncated = true;
        return testLine.concat(this._textOverflow);
    }

    protected String _ellipsize(String text, TextData lines) {
        lines.clipped = false;
        if (this._measureText(text) <= this._width) {
            lines.truncated = false;
            return text;
        }
        return this._doEllipsize(text, lines);
    }

    public static TextOperation getOperation(byte operation, String text_overflow) {
        switch (operation) {
            case 1: {
                WrapOperation fitter = new WrapOperation();
                fitter.textOverflow(text_overflow);
                return fitter;
            }
            case 2: {
                FitOperation fitter = new FitOperation();
                fitter.textOverflow(text_overflow);
                return fitter;
            }
            case 3: {
                FitWrapOperation fitter = new FitWrapOperation();
                fitter.textOverflow(text_overflow);
                return fitter;
            }
        }
        if (text_overflow != null) {
            TruncateOperation fitter = new TruncateOperation();
            fitter.textOverflow(text_overflow);
            return fitter;
        }
        return null;
    }

    public void textOverflow(String _overflow) {
        this._textOverflow = _overflow;
    }

    public void overflowMin(int _min) {
        this._overflowMin = Math.abs(_min);
    }

    protected void _initFont(TextData lines, FontStyleStruct font, double font_size) {
        lines.lineHeight = Math.ceil(font_size * this._ems);
        this._context.font = font.toString();
    }

    protected String[] _splitTextIntoWords(String _text) {
        return WordSplitter.spaceBasedSplit(_text);
    }
}

