/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.ext.text.nativeImpl;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.css.CSSStyleDeclaration;
import com.ibm.vida.rave.core.css.CSSStyleRule;
import com.ibm.vida.rave.core.css.CSSStyleSheet;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.render.internal.properties.SceneNodeDefaultStyles;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class FontChecker
implements RunFunction<Selector> {
    private static final String FONT_FAMILY_SEPARATOR = ",";
    private static final String FONT_FAMILY_SELECTOR = ".vizlibrary";
    private static final String FONT_FAMILY = "font-family";
    private static final String FONT = "font";
    private static final String FONT_CHECKED = "fontChecked";
    private static final String FONT_ORIGINAL = "origFontFamily";
    private static final String FONT_FAMILY_SET = "fontFamilySet";
    private static HashMap<String, Font> FONTS = new HashMap();
    private static ArrayEx<Font> CSS_FONTS;
    private static boolean _noCSS_Fonts;
    private String FALLBACK_FONT;
    public CallbackFunction<SceneNode> nodeFontChecker;

    public FontChecker() {
        this.FALLBACK_FONT = SceneNodeDefaultStyles.defaultStyles[21].rawValue.toString();
        this.nodeFontChecker = new CallbackFunction<SceneNode>(){

            public void run(SceneNode node, Object data, int index, int group) {
                FontChecker.this.replaceLimitedFonts(node);
            }
        };
    }

    public boolean replaceLimitedFonts(SceneNode textNode) {
        boolean found;
        boolean replace;
        FontChecker.prepareFonts();
        if (_noCSS_Fonts) {
            return false;
        }
        String text = textNode.getText();
        if (text == null || "".equals(text)) {
            return false;
        }
        String fontProp = (String)textNode.getProperty(FONT_CHECKED);
        String familyName = (String)textNode.getStyle(FONT_FAMILY);
        if (fontProp != null && fontProp.equals(text)) {
            if (!FontChecker.fontHasChanged(textNode, familyName)) {
                return false;
            }
            textNode.removeProperty(FONT_CHECKED);
        }
        if ((fontProp = (String)textNode.getProperty(FONT_ORIGINAL)) != null) {
            textNode.setStyle(FONT_FAMILY, (Object)fontProp);
        }
        int CSS_Index = 0;
        Font font = FontChecker.getFontFamily(familyName);
        boolean bl = replace = font == null;
        if (font == null) {
            CSS_Index = 1;
            font = (Font)CSS_FONTS.get(0);
        }
        String newFamilyName = font.getFamily();
        textNode.setProperty(FONT_ORIGINAL, (Object)((String)textNode.getStyle(FONT_FAMILY)));
        int start = font.canDisplayUpTo(text);
        boolean bl2 = found = start < 0;
        while (!found && CSS_Index < CSS_FONTS.length()) {
            font = (Font)CSS_FONTS.get(CSS_Index++);
            start = font.canDisplayUpTo(text);
            newFamilyName = font.getFamily();
            found = start < 0;
        }
        if (found) {
            this.setFontStyle(textNode, newFamilyName);
        } else if (replace) {
            newFamilyName = this.FALLBACK_FONT;
            this.setFontStyle(textNode, this.FALLBACK_FONT);
        }
        textNode.setProperty(FONT_CHECKED, (Object)textNode.getText());
        textNode.setProperty(FONT_FAMILY_SET, (Object)FontChecker.cleanFamilyName(newFamilyName));
        return found || replace;
    }

    public Object run(Selector text, Object ... args) {
        text.each(this.nodeFontChecker);
        return null;
    }

    private void setFontStyle(SceneNode textNode, String newFamilyName) {
        textNode.setStyle(FONT_FAMILY, (Object)newFamilyName, "important");
        String fontString = (String)textNode.getStyle(FONT);
        if (fontString == null || fontString.trim().equals("")) {
            return;
        }
        int pos = fontString.indexOf("/");
        pos = fontString.indexOf(" ", pos) + 1;
        fontString = fontString.substring(0, pos) + newFamilyName;
        textNode.setStyle(FONT, (Object)fontString, "important");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareFonts() {
        if (FONTS.size() == 0) {
            HashMap<String, Font> hashMap = FONTS;
            synchronized (hashMap) {
                if (FONTS.size() == 0) {
                    CSS_FONTS = new ArrayEx();
                    HashMap<String, Object> systemFonts = new HashMap<String, Object>();
                    Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                    for (Font font : fonts) {
                        String family = font.getFamily().toLowerCase(Locale.ROOT);
                        if (FONTS.containsKey(family)) continue;
                        FONTS.put(family, font);
                    }
                    for (String fontFamily : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                        systemFonts.put(fontFamily.toLowerCase(Locale.ROOT), fontFamily);
                    }
                    ArrayEx styleSheets = Rave.css.styleSheets();
                    for (CSSStyleSheet styleSheet : styleSheets) {
                        List rules = styleSheet.getCssRules();
                        for (CSSStyleRule rule : rules) {
                            String[] fontNames;
                            CSSStyleDeclaration style;
                            String fontstr;
                            if (!rule.getSelectorText().contains(FONT_FAMILY_SELECTOR) || (fontstr = (style = rule.getStyle()).getPropertyValue(FONT_FAMILY)) == null) continue;
                            for (String font : fontNames = fontstr.split(FONT_FAMILY_SEPARATOR)) {
                                if (!FONTS.containsKey(font = FontChecker.cleanFamilyName(font))) continue;
                                CSS_FONTS.add((Object)FONTS.get(font));
                            }
                        }
                    }
                    _noCSS_Fonts = CSS_FONTS.size() == 0;
                }
            }
        }
    }

    private static String cleanFamilyName(String name) {
        String fontName = name.trim();
        fontName = fontName.replaceAll("'", "");
        fontName = fontName.replaceAll("\"", "");
        return fontName.toLowerCase(Locale.ROOT);
    }

    private static boolean fontHasChanged(SceneNode textNode, String familyName) {
        int pos;
        String fontString;
        String fontSet = (String)textNode.getProperty(FONT_FAMILY_SET);
        return fontSet == null || !fontSet.equals(FontChecker.cleanFamilyName(familyName)) || (fontString = (String)textNode.getStyle(FONT)) == null || (pos = fontString.indexOf("/")) <= 0 || !(fontString = fontString.substring(pos = fontString.indexOf(" ", pos) + 1, fontString.length())).equals(familyName);
    }

    private static Font getFontFamily(String families) {
        String[] choices;
        if (families == null) {
            return null;
        }
        String familyStr = families + FONT_FAMILY_SEPARATOR;
        for (String choice : choices = familyStr.split(FONT_FAMILY_SEPARATOR)) {
            Font found = FONTS.get(FontChecker.cleanFamilyName(choice));
            if (found == null) continue;
            return found;
        }
        return null;
    }

    static {
        _noCSS_Fonts = true;
    }
}

