/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.awt.internal.service.context;

import com.ibm.vida.rave.awt.internal.service.context.AbstractServerTimer;
import com.ibm.vida.rave.core.nativeImpl.timer.Timer;

class ServerTimer
extends AbstractServerTimer {
    ServerTimer() {
    }

    @Override
    public void flushAll() {
        long delay = 0L;
        while (this.head.next != null) {
            delay = this.doRun(System.currentTimeMillis(), delay);
        }
    }

    public void flush() {
        this.doRun(System.currentTimeMillis(), 0L);
    }

    private long doRun(long now, long artificialDelay) {
        Timer.QueueItem last = null;
        if (this.head.next == null) {
            return 0L;
        }
        last = this.tail;
        long artificialTime = now + artificialDelay;
        this.time = now;
        Timer.QueueItem item = this.head.next;
        while (item != null) {
            if ((double)artificialTime >= item.execTime) {
                try {
                    item.complete = item.callback.run((double)artificialTime - item.time);
                }
                catch (Exception e) {
                    item.complete = true;
                }
                if (!item.complete) {
                    double delay = item.delay <= 0.0 ? 15.0 : item.delay;
                    double frameDelay = delay - (double)(System.currentTimeMillis() - now);
                    item.execTime = frameDelay > 0.0 ? (double)now + frameDelay : (double)now;
                }
            }
            if (item == last) break;
            item = item.next;
        }
        long newNow = System.currentTimeMillis();
        double smallestDelayTime = Double.MAX_VALUE;
        Timer.QueueItem previousItem = this.head;
        item = this.head.next;
        while (item != null) {
            if (item.complete) {
                previousItem.next = item.next;
            } else {
                double delay;
                previousItem = item;
                if (smallestDelayTime > 0.0 && (delay = item.execTime - (double)newNow) < smallestDelayTime) {
                    smallestDelayTime = delay;
                }
            }
            item = item.next;
        }
        this.tail = this.head.next != null ? previousItem : this.head;
        if (smallestDelayTime > 0.0 && smallestDelayTime < Double.MAX_VALUE) {
            return (long)smallestDelayTime;
        }
        return 0L;
    }
}

