/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.awt.service;

import com.ibm.vida.rave.awt.internal.service.context.AWTRaveImageServiceContextManager;
import com.ibm.vida.rave.awt.service.AWTRaveImageServiceRootProvider;
import com.ibm.vida.rave.awt.service.AWTRaveImageServiceRunnable;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.context.RaveOperationalMode;

public class AWTRaveImageService {
    private static volatile AWTRaveImageService INSTANCE;

    private AWTRaveImageService() {
        RaveOperationalMode.MODE = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AWTRaveImageService getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AWTRaveImageService> clazz = AWTRaveImageService.class;
        synchronized (AWTRaveImageService.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AWTRaveImageService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(AWTRaveImageServiceRunnable vizRunnable, String rootId) {
        AWTRaveImageServiceRootProvider rootProvider = null;
        try {
            AWTRaveImageServiceContextManager.getInstance().createContext();
            rootProvider = new AWTRaveImageServiceRootProvider(rootId, vizRunnable.getWidth(), vizRunnable.getHeight());
            String css = vizRunnable.css();
            if (css != null && css.length() > 0) {
                Rave.css.importCSS(css);
            }
            vizRunnable.create(Rave.select((String)("#" + rootId)));
            AWTRaveImageServiceContextManager.getInstance().flushAllTimerEvents();
            rootProvider.createImage(vizRunnable);
        }
        catch (Exception ex) {
            vizRunnable.setException(ex);
        }
        finally {
            if (rootProvider != null) {
                rootProvider.dispose();
            }
            AWTRaveImageServiceContextManager.getInstance().disposeContext();
        }
    }
}

