/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.awt.service;

import com.ibm.vida.rave.awt.service.AWTRaveImageServiceRenderer;
import com.ibm.vida.rave.awt.service.AWTRaveImageServiceRootSceneNode;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.nativeImpl.graphicUtils.RenderingContext;
import com.ibm.vida.rave.core.scene.ImageCreatedCallback;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.internal.RendererConfiguration;
import com.ibm.vida.rave.render.internal.nodes.RootProvider;
import com.ibm.vida.rave.render.internal.nodes.cache.SceneNodeCacheManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public final class AWTRaveImageServiceRootProvider
implements RootProvider {
    private final AWTRaveImageServiceRenderer renderer;
    private final AWTRaveImageServiceRootSceneNode sceneRoot = new AWTRaveImageServiceRootSceneNode(this);
    private final SceneNodeCacheManager cacheManager;
    private BufferedImage renderImage;
    private final int _width;
    private final int _height;
    private final String _id;

    public AWTRaveImageServiceRootProvider(String id, int width, int height) {
        this.sceneRoot.setOwner((SceneNode)this.sceneRoot);
        RendererConfiguration.INSTANCE.addRootProvider((RootProvider)this);
        this.cacheManager = new SceneNodeCacheManager();
        this.renderer = new AWTRaveImageServiceRenderer(this.sceneRoot, this);
        this.sceneRoot.setRenderer(this.renderer);
        this.sceneRoot.setCacheManager(this.cacheManager);
        this.sceneRoot.setAttribute("id", id);
        this.sceneRoot.setAttribute("width", width);
        this.sceneRoot.setAttribute("height", height);
        this.sceneRoot.setStyle("fill", "none", null);
        this._width = width;
        this._height = height;
        this._id = id;
    }

    public SceneNode getRoot() {
        return this.sceneRoot;
    }

    public SceneNodeCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void dispose() {
        RendererConfiguration.INSTANCE.removeRootProvider((RootProvider)this);
    }

    public void createImage(ImageCreatedCallback callback) {
        this.renderer.repaint();
        RenderingContext context = Rave.canvas.create((double)this._width, (double)this._height).getContext("2d", new Object[0]);
        Graphics2D graphics = context.getGraphics();
        if (this.renderImage != null) {
            graphics.drawImage((Image)this.renderImage, 0, 0, null);
        }
        callback.ready((Object)context.getImage());
        Rave.canvas.disposeContext(context);
    }

    int getWidth() {
        return this._width;
    }

    int getHeight() {
        return this._height;
    }

    String getId() {
        return this._id;
    }

    void setRenderImage(BufferedImage image) {
        this.renderImage = image;
    }
}

