/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes.awt;

import com.ibm.vida.rave.awt.RavePanel;
import com.ibm.vida.rave.awt.internal.RavePanelDelegate;
import com.ibm.vida.rave.core.event.KeyboardEvent;
import com.ibm.vida.rave.core.event.UIEvent;
import com.ibm.vida.rave.core.event.WheelEvent;
import com.ibm.vida.rave.core.nativeImpl.timer.Timer;
import com.ibm.vida.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.render.event.EventManager;
import com.ibm.vida.rave.render.event.NativeEventListener;
import com.ibm.vida.rave.render.internal.nodes.awt.AWTAbstractRenderer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;

public class AWTRenderer
extends AWTAbstractRenderer {
    private final RavePanelDelegate panelDelegate;

    public AWTRenderer(SceneNode root, RavePanelDelegate panel) {
        super(root);
        this.panelDelegate = panel;
    }

    public void finish() {
        try {
            this.panelDelegate.setRenderImage(this.getRenderImage());
            this.panelDelegate.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected EventManager createEventManager() {
        return new EventManager(this){

            protected Object addNativeEventListener(final String eventType, final NativeEventListener listener) {
                EventListener nativeListener = null;
                if ("wheel".equals(eventType)) {
                    nativeListener = new MouseWheelListener(){
                        private final AWTTimerEvent timerEvent;
                        {
                            this.timerEvent = new AWTTimerEvent(listener, null);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void mouseWheelMoved(MouseWheelEvent e) {
                            WheelEvent event = AWTRenderer.populateWheelEvent(new WheelEvent(eventType, true, true), e);
                            AWTTimerEvent aWTTimerEvent = this.timerEvent;
                            synchronized (aWTTimerEvent) {
                                if (this.timerEvent.event == null) {
                                    this.timerEvent.event = event;
                                    Timer.INSTANCE.addEvent((TimerEvent)this.timerEvent);
                                } else {
                                    this.timerEvent.nextEvent = event;
                                }
                            }
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseWheelListener((MouseWheelListener)nativeListener);
                } else if ("contextmenu".equals(eventType)) {
                    nativeListener = new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            if (e.isPopupTrigger()) {
                                UIEvent event = AWTRenderer.populateUIEvent(new UIEvent(eventType, true, true), e);
                                Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                            }
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseListener((MouseAdapter)nativeListener);
                } else if ("mousemove".equals(eventType)) {
                    nativeListener = new MouseMotionListener(){
                        private final AWTTimerEvent timerEvent;
                        {
                            this.timerEvent = new AWTTimerEvent(listener, null);
                        }

                        @Override
                        public void mouseDragged(MouseEvent e) {
                            this.handleMouseEvent(e);
                        }

                        @Override
                        public void mouseMoved(MouseEvent e) {
                            this.handleMouseEvent(e);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void handleMouseEvent(MouseEvent e) {
                            UIEvent event = AWTRenderer.populateUIEvent(new UIEvent(eventType, true, true), e);
                            AWTTimerEvent aWTTimerEvent = this.timerEvent;
                            synchronized (aWTTimerEvent) {
                                if (this.timerEvent.event == null) {
                                    this.timerEvent.event = event;
                                    Timer.INSTANCE.addEvent((TimerEvent)this.timerEvent);
                                } else {
                                    this.timerEvent.nextEvent = event;
                                }
                            }
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseMotionListener((MouseMotionListener)nativeListener);
                } else if ("mouseenter".equals(eventType) || "mouseover".equals(eventType)) {
                    nativeListener = new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            UIEvent event = AWTRenderer.populateUIEvent(new UIEvent(eventType, true, true), e);
                            Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseListener((MouseAdapter)nativeListener);
                } else if ("mouseleave".equals(eventType) || "mouseout".equals(eventType)) {
                    nativeListener = new MouseAdapter(){

                        @Override
                        public void mouseExited(MouseEvent e) {
                            UIEvent event = AWTRenderer.populateUIEvent(new UIEvent(eventType, true, true), e);
                            Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseListener((MouseAdapter)nativeListener);
                } else if ("mousedown".equals(eventType)) {
                    nativeListener = new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            UIEvent event = AWTRenderer.populateUIEvent(new UIEvent(eventType, true, true), e);
                            Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseListener((MouseAdapter)nativeListener);
                } else if ("mouseup".equals(eventType)) {
                    nativeListener = new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            UIEvent event = AWTRenderer.populateUIEvent(new UIEvent(eventType, true, true), e);
                            Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseListener((MouseAdapter)nativeListener);
                } else if ("click".equals(eventType)) {
                    nativeListener = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            UIEvent event = AWTRenderer.populateUIEvent(new UIEvent(eventType, true, true), e);
                            Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseListener((MouseAdapter)nativeListener);
                } else if ("dblclick".equals(eventType)) {
                    nativeListener = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 1) {
                                UIEvent event = AWTRenderer.populateUIEvent(new UIEvent(eventType, true, true), e);
                                Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                            }
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addMouseListener((MouseAdapter)nativeListener);
                } else if ("keydown".equals(eventType)) {
                    nativeListener = new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            UIEvent event = AWTRenderer.populateKeyEvent(new KeyboardEvent(eventType, true, true), e);
                            Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addKeyListener((KeyAdapter)nativeListener);
                } else if ("keyup".equals(eventType)) {
                    nativeListener = new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent e) {
                            UIEvent event = AWTRenderer.populateKeyEvent(new KeyboardEvent(eventType, true, true), e);
                            Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addKeyListener((KeyAdapter)nativeListener);
                } else if ("keypress".equals(eventType)) {
                    nativeListener = new KeyAdapter(){

                        @Override
                        public void keyTyped(KeyEvent e) {
                            UIEvent event = AWTRenderer.populateKeyEvent(new KeyboardEvent(eventType, true, true), e);
                            Timer.INSTANCE.addEvent((TimerEvent)new AWTTimerEvent(listener, event));
                        }
                    };
                    AWTRenderer.this.panelDelegate.getPanel().addKeyListener((KeyAdapter)nativeListener);
                }
                return nativeListener;
            }

            protected void removeNativeEventListener(String eventType, Object nativeObject) {
                if (nativeObject instanceof MouseMotionListener) {
                    AWTRenderer.this.panelDelegate.getPanel().removeMouseMotionListener((MouseMotionListener)nativeObject);
                } else if (nativeObject instanceof MouseListener) {
                    AWTRenderer.this.panelDelegate.getPanel().removeMouseListener((MouseListener)nativeObject);
                } else if (nativeObject instanceof KeyListener) {
                    AWTRenderer.this.panelDelegate.getPanel().removeKeyListener((KeyListener)nativeObject);
                } else if (nativeObject instanceof MouseWheelListener) {
                    AWTRenderer.this.panelDelegate.getPanel().removeMouseWheelListener((MouseWheelListener)nativeObject);
                }
            }
        };
    }

    private static UIEvent populateUIEvent(UIEvent event, MouseEvent e) {
        event.altKey = e.isAltDown();
        event.button = e.getButton();
        event.clientX = e.getX();
        event.clientY = e.getY();
        event.ctrlKey = e.isControlDown();
        event.metaKey = e.isMetaDown();
        event.pageX = e.getXOnScreen();
        event.pageY = e.getYOnScreen();
        event.shiftKey = e.isShiftDown();
        event.timeStamp = e.getWhen();
        return event;
    }

    private static WheelEvent populateWheelEvent(WheelEvent event, MouseWheelEvent e) {
        AWTRenderer.populateUIEvent((UIEvent)event, e);
        event.deltaY = e.getWheelRotation() * 100;
        event.deltaX = 0.0;
        event.deltaZ = 0.0;
        event.deltaMode = 0;
        return event;
    }

    private static UIEvent populateKeyEvent(KeyboardEvent event, KeyEvent e) {
        event.altKey = e.isAltDown();
        event.ctrlKey = e.isControlDown();
        event.metaKey = e.isMetaDown();
        event.shiftKey = e.isShiftDown();
        event.timeStamp = e.getWhen();
        event.keyCode = e.getKeyCode();
        event.which = e.getKeyChar();
        return event;
    }

    public RavePanel getPanel() {
        return this.panelDelegate.getPanel();
    }

    private static class AWTTimerEvent
    implements TimerEvent {
        private final NativeEventListener listener;
        UIEvent event;
        UIEvent nextEvent;

        AWTTimerEvent(NativeEventListener listener, UIEvent event) {
            this.listener = listener;
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean run(double elapsed) {
            this.listener.onEvent(this.event);
            AWTTimerEvent aWTTimerEvent = this;
            synchronized (aWTTimerEvent) {
                this.event = null;
                if (this.nextEvent != null) {
                    this.event = this.nextEvent;
                    this.nextEvent = null;
                    Timer.INSTANCE.addEvent((TimerEvent)this);
                }
            }
            return true;
        }
    }
}

