/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes.awt;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public class GraphicsUtil {
    public static int getAlpha(int rgba) {
        return rgba >> 24 & 0xFF;
    }

    public static int getRed(int rgba) {
        return rgba >> 16 & 0xFF;
    }

    public static int getGreen(int rgba) {
        return rgba >> 8 & 0xFF;
    }

    public static int getBlue(int rgba) {
        return rgba & 0xFF;
    }

    public static int rgb(int a, int r, int g, int b) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int updateAlpha(int newAlpha, int curRGBA) {
        return GraphicsUtil.rgb(newAlpha, GraphicsUtil.getRed(curRGBA), GraphicsUtil.getGreen(curRGBA), GraphicsUtil.getBlue(curRGBA));
    }

    public static void gaussianBlurBufferedImage(BufferedImage pImage, int featherAmount) {
        if (featherAmount == 0) {
            return;
        }
        int width = pImage.getWidth();
        int height = pImage.getHeight();
        WritableRaster pRasterImage = pImage.getRaster();
        int[] pixelsImage = ((DataBufferInt)pRasterImage.getDataBuffer()).getData();
        int size = pixelsImage.length;
        int[] pixelsOut1 = new int[size];
        int[] pixelsOut2 = new int[size];
        int[] pixelsOut3 = new int[size];
        for (int y = 0; y < height; ++y) {
            GraphicsUtil.boxBlur(pixelsImage, pixelsOut1, y * width, width, 1, featherAmount);
            GraphicsUtil.boxBlur(pixelsOut1, pixelsOut2, y * width, width, 1, featherAmount);
            GraphicsUtil.boxBlur(pixelsOut2, pixelsOut3, y * width, width, 1, featherAmount);
        }
        for (int x = 0; x < width; ++x) {
            GraphicsUtil.boxBlur(pixelsOut3, pixelsOut2, x, height, width, featherAmount);
            GraphicsUtil.boxBlur(pixelsOut2, pixelsOut1, x, height, width, featherAmount);
            GraphicsUtil.boxBlur(pixelsOut1, pixelsImage, x, height, width, featherAmount);
        }
    }

    private static void boxBlur(int[] pixelsIn, int[] pixelsOut, int start, int length, int increment, int feather) {
        int divisor = 2 * feather + 1;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int dividedR = 0;
        int dividedG = 0;
        int dividedB = 0;
        int dividedA = 0;
        int rgbaToSubtract = 0;
        int rgba = 0;
        int currentIdx = 0;
        int divisorIncrement = divisor * increment;
        int featherIncrement = feather * increment;
        for (int i = 0; i < length; ++i) {
            currentIdx = start + i * increment;
            rgba = pixelsIn[currentIdx];
            r += GraphicsUtil.getRed(rgba);
            g += GraphicsUtil.getGreen(rgba);
            b += GraphicsUtil.getBlue(rgba);
            a += GraphicsUtil.getAlpha(rgba);
            if (i >= divisor) {
                rgbaToSubtract = pixelsIn[currentIdx - divisorIncrement];
                r -= GraphicsUtil.getRed(rgbaToSubtract);
                g -= GraphicsUtil.getGreen(rgbaToSubtract);
                b -= GraphicsUtil.getBlue(rgbaToSubtract);
                a -= GraphicsUtil.getAlpha(rgbaToSubtract);
            }
            if (i < feather) continue;
            dividedR = r / divisor;
            dividedG = g / divisor;
            dividedB = b / divisor;
            dividedA = a / divisor;
            pixelsOut[currentIdx - featherIncrement] = GraphicsUtil.rgb(dividedA, dividedR, dividedG, dividedB);
        }
    }
}

