/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.render.internal.nodes.awt;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class TextPathUtility {
    private static final double FLATNESS = 1.0;

    public static Shape transformTextOnPath(Shape shape, String text, Font font, FontRenderContext frc, double totalOfxANDdx, double totalOfyANDdy) {
        if (shape == null) {
            return new GeneralPath();
        }
        boolean stretchToFit = false;
        boolean repeat = false;
        AffineTransform t = new AffineTransform();
        GlyphVector glyphVector = font.createGlyphVector(frc, text);
        GeneralPath result = new GeneralPath();
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        double[] points = new double[6];
        double moveX = 0.0;
        double moveY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        double thisX = 0.0;
        double thisY = 0.0;
        int type = 0;
        boolean first = false;
        double next = 0.0;
        int currentChar = 0;
        int length = glyphVector.getNumGlyphs();
        if (length == 0) {
            return result;
        }
        double factor = stretchToFit ? TextPathUtility.measurePathLength(shape) / glyphVector.getLogicalBounds().getWidth() : 1.0;
        double nextAdvance = 0.0;
        while (currentChar < length && !it.isDone()) {
            type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = points[0];
                    moveY = lastY = points[1];
                    result.moveTo(moveX, moveY);
                    first = true;
                    next = nextAdvance = (double)glyphVector.getGlyphMetrics(currentChar).getAdvance() * 0.5;
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    thisX = points[0];
                    thisY = points[1];
                    double dx = thisX - lastX;
                    double dy = thisY - lastY;
                    double distance = Math.sqrt(dx * dx + dy * dy);
                    if (distance >= next) {
                        double r = 1.0 / distance;
                        double angle = Math.atan2(dy, dx);
                        while (currentChar < length && distance >= next) {
                            Shape glyph = glyphVector.getGlyphOutline(currentChar);
                            Point2D p = glyphVector.getGlyphPosition(currentChar);
                            double px = p.getX();
                            double py = p.getY();
                            double x = lastX + next * dx * r;
                            double y = lastY + next * dy * r;
                            double advance = nextAdvance;
                            nextAdvance = currentChar < length - 1 ? (double)glyphVector.getGlyphMetrics(currentChar + 1).getAdvance() * 0.5 : 0.0;
                            t.setToTranslation(x, y);
                            t.rotate(angle);
                            t.translate(-px - advance + totalOfxANDdx, -py + totalOfyANDdy);
                            result.append(t.createTransformedShape(glyph), false);
                            next += (advance + nextAdvance) * factor;
                            ++currentChar;
                            if (!repeat) continue;
                            currentChar %= length;
                        }
                    }
                    next -= distance;
                    first = false;
                    lastX = thisX;
                    lastY = thisY;
                }
            }
            it.next();
        }
        return result;
    }

    private static double measurePathLength(Shape shape) {
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        double[] points = new double[6];
        double moveX = 0.0;
        double moveY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        double thisX = 0.0;
        double thisY = 0.0;
        int type = 0;
        double total = 0.0;
        while (!it.isDone()) {
            type = it.currentSegment(points);
            switch (type) {
                case 0: {
                    moveX = lastX = points[0];
                    moveY = lastY = points[1];
                    break;
                }
                case 4: {
                    points[0] = moveX;
                    points[1] = moveY;
                }
                case 1: {
                    thisX = points[0];
                    thisY = points[1];
                    double dx = thisX - lastX;
                    double dy = thisY - lastY;
                    total += Math.sqrt(dx * dx + dy * dy);
                    lastX = thisX;
                    lastY = thisY;
                }
            }
            it.next();
        }
        return total;
    }
}

