/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.ext.imagemap.internal;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.SelectorGroup;
import com.ibm.vida.rave.library.ext.imagemap.ImageMapArguments;
import com.ibm.vida.rave.library.ext.imagemap.ImageMapCallback;
import com.ibm.vida.rave.library.ext.imagemap.internal.ImageMapResultImpl;
import com.ibm.vida.rave.library.ext.imagemap.internal.ImageMapSceneItemImpl;
import com.ibm.vida.rave.library.ext.imagemap.internal.geom.ImageMapNodeGeometry;
import com.ibm.vida.rave.library.framework.internal.BundleDatum;
import java.util.Collection;
import java.util.List;

public class ImageMapImpl {
    private static final OMap<String, ArrayEx<String>> GROUP_TYPES_TO_SIMPLE_TYPES = ImageMapImpl.buildGroupTypeMap();
    private static final OMap<String, String> SCENEITEM_TYPES_TO_QUERIES = ImageMapImpl.buildSceneItemMap();
    private static final OMap<String, String> NODE_CLASSES_TO_SCENEITEM_TYPES = ImageMapImpl.buildNodeClassMap();
    private static final OMap<String, Integer> SCENEITEM_TYPES_TO_SCENEITEM_DATATYPES = ImageMapImpl.buildDataTypeMap();

    public void createImageMap(ImageMapArguments args, ImageMapCallback callback) {
        ImageMapResultImpl result = new ImageMapResultImpl();
        if (args == null) {
            result._code = 2;
            callback.ready(result);
            return;
        }
        if (args.node == null) {
            result._code = 3;
            callback.ready(result);
            return;
        }
        String query = ImageMapImpl.makeSelectorQuery(args.types, result);
        if (query != null) {
            Selector s = Rave.select((SceneNode)args.node).selectAll(query);
            ArrayEx list = new ArrayEx();
            ImageMapNodeGeometry geom = new ImageMapNodeGeometry(args);
            for (int i = 0; i < s.length(); ++i) {
                SelectorGroup g = (SelectorGroup)s.get(i);
                for (SceneNode node : g) {
                    String type = ImageMapImpl.getSceneItemType(node);
                    int dataType = ImageMapImpl.getSceneItemDataType(type);
                    Object data = ImageMapImpl.getSceneItemData(node, dataType);
                    list.add((Object)new ImageMapSceneItemImpl(node, type, dataType, data, geom.points(node, result)));
                }
            }
            result._items = list.reverse();
        }
        callback.ready(result);
    }

    private static String makeSelectorQuery(List<String> typesList, ImageMapResultImpl result) {
        if (typesList == null || typesList.size() == 0) {
            return null;
        }
        ArrayEx selectorList = new ArrayEx();
        for (String type : typesList) {
            if (type == null) continue;
            ArrayEx simpleTypes = (ArrayEx)GROUP_TYPES_TO_SIMPLE_TYPES.get((Object)type);
            if (simpleTypes != null) {
                for (String simpleType : simpleTypes) {
                    selectorList.add(SCENEITEM_TYPES_TO_QUERIES.get((Object)simpleType));
                }
                continue;
            }
            String selector = (String)SCENEITEM_TYPES_TO_QUERIES.get((Object)type);
            if (selector != null) {
                selectorList.add(selector);
                continue;
            }
            result._code = 4;
            result._location = type;
            return null;
        }
        ArrayEx uniques = new ArrayEx();
        uniques.addAll((Collection)Rave.set((List)selectorList).values());
        return uniques.join((Object)", ");
    }

    private static String getSceneItemType(SceneNode node) {
        for (String className : NODE_CLASSES_TO_SCENEITEM_TYPES.keySet()) {
            if (!node.containsClass(className)) continue;
            return (String)NODE_CLASSES_TO_SCENEITEM_TYPES.get((Object)className);
        }
        return "TYPE_UNKNOWN";
    }

    private static int getSceneItemDataType(String type) {
        Integer dt = (Integer)SCENEITEM_TYPES_TO_SCENEITEM_DATATYPES.get((Object)type);
        return dt == null ? 0 : dt;
    }

    private static Object getSceneItemData(SceneNode node, int dataType) {
        Object datum = node.getData();
        if (dataType == 1) {
            if (datum instanceof BundleDatum) {
                return ((BundleDatum)datum).originalDataList();
            }
            return datum;
        }
        if (dataType == 2) {
            return datum;
        }
        return null;
    }

    private static OMap<String, ArrayEx<String>> buildGroupTypeMap() {
        OMap result = new OMap();
        result.put((Object)"element-*", (Object)new ArrayEx((Object[])new String[]{"element-shape", "element-label"}));
        result.put((Object)"axis-*", (Object)new ArrayEx((Object[])new String[]{"axis-title", "axis-line", "axis-tick", "axis-label", "axis-gridline"}));
        result.put((Object)"legend-*", (Object)new ArrayEx((Object[])new String[]{"legend-title", "legend-tick", "legend-label"}));
        return result;
    }

    private static OMap<String, String> buildSceneItemMap() {
        OMap result = new OMap();
        result.put((Object)"element-shape", (Object)".element-shape");
        result.put((Object)"element-label", (Object)".element-label");
        result.put((Object)"axis-title", (Object)".axis-title");
        result.put((Object)"axis-line", (Object)".axis-line");
        result.put((Object)"axis-tick", (Object)".axis-tick");
        result.put((Object)"axis-label", (Object)".axis-label");
        result.put((Object)"axis-gridline", (Object)".grid-tick");
        result.put((Object)"legend-title", (Object)".legendTitle");
        result.put((Object)"legend-tick", (Object)".legendShape, .legendTickLine");
        result.put((Object)"legend-label", (Object)".legendLabel");
        return result;
    }

    private static OMap<String, String> buildNodeClassMap() {
        OMap result = new OMap();
        result.put((Object)"element-shape", (Object)"element-shape");
        result.put((Object)"element-label", (Object)"element-label");
        result.put((Object)"axis-title", (Object)"axis-title");
        result.put((Object)"axis-line", (Object)"axis-line");
        result.put((Object)"axis-tick", (Object)"axis-tick");
        result.put((Object)"axis-label", (Object)"axis-label");
        result.put((Object)"grid-tick", (Object)"axis-gridline");
        result.put((Object)"legendTitle", (Object)"legend-title");
        result.put((Object)"legendShape", (Object)"legend-tick");
        result.put((Object)"legendTickLine", (Object)"legend-tick");
        result.put((Object)"legendLabel", (Object)"legend-label");
        return result;
    }

    private static OMap<String, Integer> buildDataTypeMap() {
        OMap result = new OMap();
        result.put((Object)"element-shape", (Object)1);
        result.put((Object)"element-label", (Object)1);
        result.put((Object)"axis-title", (Object)3);
        result.put((Object)"axis-line", (Object)3);
        result.put((Object)"axis-tick", (Object)2);
        result.put((Object)"axis-label", (Object)2);
        result.put((Object)"axis-gridline", (Object)2);
        result.put((Object)"legend-title", (Object)3);
        result.put((Object)"legend-tick", (Object)2);
        result.put((Object)"legend-label", (Object)2);
        return result;
    }
}

