/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.ext.imagemap.internal.geom;

import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.library.ext.imagemap.ImageMapArguments;
import com.ibm.vida.rave.library.ext.imagemap.internal.ImageMapResultImpl;
import com.ibm.vida.rave.library.ext.imagemap.internal.geom.ImageMapPathHandler;
import com.ibm.vida.rave.library.ext.imagemap.internal.geom.ImageMapPathParser;
import java.util.List;

public class ImageMapNodeGeometry {
    private ImageMapPathParser _parser = new ImageMapPathParser();
    private final double _flattenPixels;
    private final double _outlinePixels;
    private final double _expandPixels;

    public ImageMapNodeGeometry(ImageMapArguments args) {
        this._flattenPixels = Math.max(2.0, args.flattenPixels);
        this._outlinePixels = Math.max(0.5, args.outlinePixels);
        this._expandPixels = Math.max(0.0, args.expandPixels);
    }

    public List<PointStruct> points(SceneNode node, ImageMapResultImpl result) {
        ImageMapPathHandler handler = new ImageMapPathHandler(node.getCTM(), this._flattenPixels, this._outlinePixels, this._expandPixels);
        String type = node.getName();
        if ("rect".equals(type)) {
            double x = ObjectConverter.toDouble((Object)node.getAttribute("x"));
            double y = ObjectConverter.toDouble((Object)node.getAttribute("y"));
            double w = ObjectConverter.toDouble((Object)node.getAttribute("width"));
            double h = ObjectConverter.toDouble((Object)node.getAttribute("height"));
            double rx = ObjectConverter.toDouble((Object)node.getAttribute("rx"));
            double ry = ObjectConverter.toDouble((Object)node.getAttribute("ry"));
            if (rx > 0.0 || ry > 0.0) {
                if (rx == 0.0) {
                    rx = ry;
                } else if (ry == 0.0) {
                    ry = rx;
                }
                rx = Math.min(rx, w / 2.0);
                ry = Math.min(ry, h / 2.0);
                handler.moveTo(x + w - rx, y);
                handler.arcTo(x + w - rx, y, rx, ry, 0.0, false, true, x + w, y + ry);
                handler.lineTo(x + w, y + h - ry);
                handler.arcTo(x + w, y + h - ry, rx, ry, 0.0, false, true, x + w - rx, y + h);
                handler.lineTo(x + rx, y + h);
                handler.arcTo(x + rx, y + h, rx, ry, 0.0, false, true, x, y + h - ry);
                handler.lineTo(x, y + ry);
                handler.arcTo(x, y + ry, rx, ry, 0.0, false, true, x + rx, y);
                handler.closePath();
            } else {
                handler.moveTo(x, y);
                handler.lineTo(x + w, y);
                handler.lineTo(x + w, y + h);
                handler.lineTo(x, y + h);
                handler.closePath();
            }
        } else if ("line".equals(type)) {
            double x1 = ObjectConverter.toDouble((Object)node.getAttribute("x1"));
            double y1 = ObjectConverter.toDouble((Object)node.getAttribute("y1"));
            double x2 = ObjectConverter.toDouble((Object)node.getAttribute("x2"));
            double y2 = ObjectConverter.toDouble((Object)node.getAttribute("y2"));
            handler.moveTo(x1, y1);
            handler.lineTo(x2, y2);
        } else if ("circle".equals(type)) {
            double cx = ObjectConverter.toDouble((Object)node.getAttribute("cx"));
            double cy = ObjectConverter.toDouble((Object)node.getAttribute("cy"));
            double r = ObjectConverter.toDouble((Object)node.getAttribute("r"));
            handler.moveTo(cx, cy + r);
            handler.arcTo(cx, cy + r, r, r, 0.0, true, true, cx, cy - r);
            handler.arcTo(cx, cy - r, r, r, 0.0, true, true, cx, cy + r);
            handler.closePath();
        } else if ("ellipse".equals(type)) {
            double cx = ObjectConverter.toDouble((Object)node.getAttribute("cx"));
            double cy = ObjectConverter.toDouble((Object)node.getAttribute("cy"));
            double rx = ObjectConverter.toDouble((Object)node.getAttribute("rx"));
            double ry = ObjectConverter.toDouble((Object)node.getAttribute("ry"));
            handler.moveTo(cx, cy + ry);
            handler.arcTo(cx, cy + ry, rx, ry, 0.0, true, true, cx, cy - ry);
            handler.arcTo(cx, cy - ry, rx, ry, 0.0, true, true, cx, cy + ry);
            handler.closePath();
        } else if ("path".equals(type)) {
            this._parser.parsePath(ObjectConverter.toString((Object)node.getAttribute("d")), handler);
        } else if ("polygon".equals(type)) {
            this._parser.parsePolygon(ObjectConverter.toString((Object)node.getAttribute("points")), handler);
            handler.closePath();
        } else if ("polyline".equals(type)) {
            this._parser.parsePolygon(ObjectConverter.toString((Object)node.getAttribute("points")), handler);
        } else if ("text".equals(type) || "g".equals(type)) {
            RaveRect r = node.getBBox();
            handler.moveTo(r.x, r.y);
            handler.lineTo(r.x + r.width, r.y);
            handler.lineTo(r.x + r.width, r.y + r.height);
            handler.lineTo(r.x, r.y + r.height);
            handler.closePath();
        } else {
            result._code = 5;
            result._location = type;
        }
        return handler.points();
    }
}

