/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.ext.imagemap.internal.geom;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.Path2DHandler;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.transform.Matrix;
import java.util.List;

class ImageMapPathHandler
implements Path2DHandler {
    private final double _flattenPixels;
    private final double _outlinePixels;
    private final double _expandPixels;
    private final double _minimumSize;
    private final double _ma;
    private final double _mb;
    private final double _mc;
    private final double _md;
    private final double _me;
    private final double _mf;
    private final ArrayEx<PointStruct> _points;
    private boolean _closed;
    private PointStruct _curr;
    private PointStruct _start;
    private boolean _lastMoveto;
    private boolean _add;

    ImageMapPathHandler(Matrix nodeMatrix, double flattenPixels, double outlinePixels, double expandPixels) {
        if (nodeMatrix != null) {
            this._ma = nodeMatrix.a;
            this._mb = -nodeMatrix.b;
            this._mc = -nodeMatrix.c;
            this._md = nodeMatrix.d;
            this._me = nodeMatrix.e;
            this._mf = nodeMatrix.f;
        } else {
            this._ma = 1.0;
            this._mb = 0.0;
            this._mc = 0.0;
            this._md = 1.0;
            this._me = 0.0;
            this._mf = 0.0;
        }
        this._flattenPixels = Math.max(2.0, flattenPixels);
        this._outlinePixels = Math.max(0.5, outlinePixels);
        this._expandPixels = Math.max(0.0, expandPixels);
        this._minimumSize = 2.0 * Math.max(this._outlinePixels, this._expandPixels);
        this._points = new ArrayEx();
        this._closed = false;
        this._curr = new PointStruct(0.0, 0.0);
        this._start = null;
        this._lastMoveto = false;
        this._add = true;
    }

    List<PointStruct> points() {
        int n = this._points.size();
        if (n == 0) {
            return this.outlinePoint(-10.0 - this._outlinePixels, -10.0 - this._outlinePixels);
        }
        if (n == 1) {
            return this.outlinePoint(((PointStruct)this._points.get((int)0)).x, ((PointStruct)this._points.get((int)0)).y);
        }
        PointStruct p = (PointStruct)this._points.get(0);
        double minx = p.x;
        double miny = p.y;
        double maxx = p.x;
        double maxy = p.y;
        for (int i = 1; i < n; ++i) {
            p = (PointStruct)this._points.get(i);
            minx = Math.min(minx, p.x);
            miny = Math.min(miny, p.y);
            maxx = Math.max(maxx, p.x);
            maxy = Math.max(maxy, p.y);
        }
        if (maxx - minx <= this._minimumSize && maxy - miny <= this._minimumSize) {
            return this.outlinePoint((minx + maxx) / 2.0, (miny + maxy) / 2.0);
        }
        if (n == 2) {
            return this.outlineLine((PointStruct)this._points.get(0), (PointStruct)this._points.get(1));
        }
        if (this._closed) {
            return this.expandPoly(this._points, (minx + maxx) / 2.0, (miny + maxy) / 2.0);
        }
        return this.outlinePoly(this._points);
    }

    public void fail(int index) {
    }

    public void startPath() {
    }

    public void closePath() {
        this._closed = true;
        this._add = false;
        this._lastMoveto = false;
    }

    public void moveTo(double x, double y) {
        if (this._start != null && !this._lastMoveto) {
            this._add = false;
        }
        if (this._add) {
            PointStruct p = this.pt(x, y);
            this._curr.x = p.x;
            this._curr.y = p.y;
            this._start = new PointStruct(p.x, p.y);
            if (this._lastMoveto) {
                PointStruct oldP = (PointStruct)this._points.get(this._points.size() - 1);
                oldP.x = p.x;
                oldP.y = p.y;
            } else {
                this._points.add((Object)p);
            }
        }
        this._lastMoveto = true;
    }

    public void lineTo(double x, double y) {
        if (this._add) {
            PointStruct p = this.pt(x, y);
            this._curr.x = p.x;
            this._curr.y = p.y;
            this._points.add((Object)p);
        }
        this._lastMoveto = false;
    }

    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        if (this._add) {
            PointStruct p = this.pt(x, y);
            this.doBezierCurveTo(0.0, this._curr, 1.0, p, this._curr, this.pt(cp1x, cp1y), this.pt(cp2x, cp2y), p);
            this._curr.x = p.x;
            this._curr.y = p.y;
        }
        this._lastMoveto = false;
    }

    private void doBezierCurveTo(double t0, PointStruct pt0, double t1, PointStruct pt1, PointStruct p0, PointStruct p1, PointStruct p2, PointStruct p3) {
        double m = (t0 + t1) / 2.0;
        PointStruct pM = ImageMapPathHandler.cubicBezierPoint(m, p0, p1, p2, p3);
        if (ImageMapPathHandler.distance(pt0, pM) <= this._flattenPixels) {
            this._points.add((Object)pM);
        } else {
            this.doBezierCurveTo(t0, pt0, m, pM, p0, p1, p2, p3);
        }
        if (ImageMapPathHandler.distance(pM, pt1) <= this._flattenPixels) {
            this._points.add((Object)pt1);
        } else {
            this.doBezierCurveTo(m, pM, t1, pt1, p0, p1, p2, p3);
        }
    }

    private static PointStruct cubicBezierPoint(double t, PointStruct p0, PointStruct p1, PointStruct p2, PointStruct p3) {
        double xp = (1.0 - t) * (1.0 - t) * (1.0 - t) * p0.x + 3.0 * (1.0 - t) * (1.0 - t) * t * p1.x + 3.0 * (1.0 - t) * (t * t) * p2.x + t * t * t * p3.x;
        double yp = (1.0 - t) * (1.0 - t) * (1.0 - t) * p0.y + 3.0 * (1.0 - t) * (1.0 - t) * t * p1.y + 3.0 * (1.0 - t) * (t * t) * p2.y + t * t * t * p3.y;
        return new PointStruct(xp, yp);
    }

    public void quadraticCurveTo(double cpx, double cpy, double x, double y) {
        if (this._add) {
            PointStruct p = this.pt(x, y);
            this.doBezierQuadTo(0.0, this._curr, 1.0, p, this._curr, this.pt(cpx, cpy), p);
            this._curr.x = p.x;
            this._curr.y = p.y;
        }
        this._lastMoveto = false;
    }

    private void doBezierQuadTo(double t0, PointStruct pt0, double t1, PointStruct pt1, PointStruct p0, PointStruct p1, PointStruct p2) {
        double m = (t0 + t1) / 2.0;
        PointStruct pM = ImageMapPathHandler.quadraticBezierPoint(m, p0, p1, p2);
        if (ImageMapPathHandler.distance(pt0, pM) <= this._flattenPixels) {
            this._points.add((Object)pM);
        } else {
            this.doBezierQuadTo(t0, pt0, m, pM, p0, p1, p2);
        }
        if (ImageMapPathHandler.distance(pM, pt1) <= this._flattenPixels) {
            this._points.add((Object)pt1);
        } else {
            this.doBezierQuadTo(m, pM, t1, pt1, p0, p1, p2);
        }
    }

    private static PointStruct quadraticBezierPoint(double t, PointStruct p0, PointStruct p1, PointStruct p2) {
        double xp = (1.0 - t) * (1.0 - t) * p0.x + 2.0 * (1.0 - t) * t * p1.x + t * t * p2.x;
        double yp = (1.0 - t) * (1.0 - t) * p0.y + 2.0 * (1.0 - t) * t * p1.y + t * t * p2.y;
        return new PointStruct(xp, yp);
    }

    public void arcTo(double x0, double y0, double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        double ryAbs;
        double Pry;
        double Py1;
        double dx2 = (x0 - x) / 2.0;
        double dy2 = (y0 - y) / 2.0;
        if (dx2 == 0.0 && dy2 == 0.0) {
            this.lineTo(x, y);
            return;
        }
        double angle = xAxisRotation % 360.0;
        double angleRad = angle / 180.0 * Math.PI;
        double cosAngle = Math.cos(angleRad);
        double sinAngle = Math.sin(angleRad);
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double Px1 = x1 * x1;
        double rxAbs = Math.abs(rx);
        double Prx = rxAbs * rxAbs;
        double radiiCheck = Px1 / Prx + (Py1 = y1 * y1) / (Pry = (ryAbs = Math.abs(ry)) * ryAbs);
        if (radiiCheck > 1.0) {
            rxAbs = Math.sqrt(radiiCheck) * rxAbs;
            ryAbs = Math.sqrt(radiiCheck) * ryAbs;
            Prx = rxAbs * rxAbs;
            Pry = ryAbs * ryAbs;
        }
        double sign = largeArcFlag == sweepFlag ? -1.0 : 1.0;
        double sq = (Prx * Pry - Prx * Py1 - Pry * Px1) / (Prx * Py1 + Pry * Px1);
        sq = sq < 0.0 ? 0.0 : sq;
        double coef = sign * Math.sqrt(sq);
        double cx1 = coef * (rxAbs * y1 / ryAbs);
        double cy1 = coef * -(ryAbs * x1 / rxAbs);
        double sx2 = (x0 + x) / 2.0;
        double sy2 = (y0 + y) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / rxAbs;
        double uy = (y1 - cy1) / ryAbs;
        double vx = (-x1 - cx1) / rxAbs;
        double vy = (-y1 - cy1) / ryAbs;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        double arccos = Math.max(-1.0, Math.min(1.0, p / n));
        double angleStart = sign * Math.acos(arccos) * 180.0 / Math.PI;
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        arccos = Math.max(-1.0, Math.min(1.0, p / n));
        double angleExtent = sign * Math.acos(arccos) * 180.0 / Math.PI;
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        Matrix ellipseMatrix = new Matrix(cosAngle, -sinAngle, sinAngle, cosAngle, cx, cy);
        PointStruct pp = this.pt(x, y);
        this.doArcTo((angleStart %= 360.0) * Math.PI / 180.0, this.pt(x0, y0), (angleStart + (angleExtent %= 360.0)) * Math.PI / 180.0, pp, rxAbs, ryAbs, ellipseMatrix);
        this._curr.x = pp.x;
        this._curr.y = pp.y;
        this._lastMoveto = false;
    }

    private void doArcTo(double a0, PointStruct p0, double a1, PointStruct p1, double rx, double ry, Matrix m) {
        double aM = (a0 + a1) / 2.0;
        PointStruct pM = this.arcPoint(aM, rx, ry, m);
        if (ImageMapPathHandler.distance(p0, pM) <= this._flattenPixels) {
            this._points.add((Object)pM);
        } else {
            this.doArcTo(a0, p0, aM, pM, rx, ry, m);
        }
        if (ImageMapPathHandler.distance(pM, p1) <= this._flattenPixels) {
            this._points.add((Object)p1);
        } else {
            this.doArcTo(aM, pM, a1, p1, rx, ry, m);
        }
    }

    private PointStruct arcPoint(double a, double rx, double ry, Matrix m) {
        double x = rx * Math.cos(a);
        double y = ry * Math.sin(a);
        return this.pt(m.a * x + m.b * y + m.e, m.c * x + m.d * y + m.f);
    }

    private List<PointStruct> outlinePoint(double cx, double cy) {
        double s = this._minimumSize / 2.0;
        return new ArrayEx((Object[])new PointStruct[]{new PointStruct(cx - s, cy - s), new PointStruct(cx - s, cy + s), new PointStruct(cx + s, cy + s), new PointStruct(cx + s, cy - s)});
    }

    private List<PointStruct> outlineLine(PointStruct p1, PointStruct p2) {
        double[] d = new double[2];
        ImageMapPathHandler.getNormalizedDirection(p1, p2, d);
        d[0] = d[0] * this._outlinePixels;
        d[1] = d[1] * this._outlinePixels;
        return new ArrayEx((Object[])new PointStruct[]{new PointStruct(p1.x - d[0], p1.y - d[1]), new PointStruct(p1.x + d[1], p1.y - d[0]), new PointStruct(p2.x + d[1], p2.y - d[0]), new PointStruct(p2.x + d[0], p2.y + d[1]), new PointStruct(p2.x - d[1], p2.y + d[0]), new PointStruct(p1.x - d[1], p1.y + d[0])});
    }

    private List<PointStruct> expandPoly(ArrayEx<PointStruct> points, double xc, double yc) {
        if (this._expandPixels <= 0.0) {
            return points;
        }
        ArrayEx result = new ArrayEx();
        for (PointStruct p : points) {
            double x = p.x;
            double dx = x - xc;
            double y = p.y;
            double dy = y - yc;
            double l = Math.sqrt(dx * dx + dy * dy);
            if (l > 0.0) {
                x += this._expandPixels * dx / l;
                y += this._expandPixels * dy / l;
            }
            result.add((Object)new PointStruct(x, y));
        }
        return result;
    }

    private List<PointStruct> outlinePoly(ArrayEx<PointStruct> inPoints) {
        ArrayEx<PointStruct> points = ImageMapPathHandler.dropClosePoints(inPoints);
        int N = points.size();
        if (N == 2) {
            return this.outlineLine((PointStruct)points.get(0), (PointStruct)points.get(1));
        }
        ArrayEx result = new ArrayEx();
        result.setLength(2 * N + 2);
        double[] d = new double[2];
        PointStruct p = (PointStruct)points.get(0);
        ImageMapPathHandler.getNormalizedDirection(p, (PointStruct)points.get(1), d);
        d[0] = d[0] * this._outlinePixels;
        d[1] = d[1] * this._outlinePixels;
        result.set(0, (Object)new PointStruct(p.x - d[0], p.y - d[1]));
        result.set(1, (Object)new PointStruct(p.x + d[1], p.y - d[0]));
        result.set(2 * N + 1, (Object)new PointStruct(p.x - d[1], p.y + d[0]));
        for (int i = 1; i < N - 1; ++i) {
            p = (PointStruct)points.get(i);
            ImageMapPathHandler.getNormalizedBisector((PointStruct)points.get(i - 1), p, (PointStruct)points.get(i + 1), d);
            d[0] = d[0] * this._outlinePixels;
            d[1] = d[1] * this._outlinePixels;
            result.set(i + 1, (Object)new PointStruct(p.x + d[0], p.y + d[1]));
            result.set(2 * N + 1 - i, (Object)new PointStruct(p.x - d[0], p.y - d[1]));
        }
        p = (PointStruct)points.get(N - 1);
        ImageMapPathHandler.getNormalizedDirection((PointStruct)points.get(N - 2), p, d);
        d[0] = d[0] * this._outlinePixels;
        d[1] = d[1] * this._outlinePixels;
        result.set(N + 1, (Object)new PointStruct(p.x + d[0], p.y + d[1]));
        result.set(N, (Object)new PointStruct(p.x + d[1], p.y - d[0]));
        result.set(N + 2, (Object)new PointStruct(p.x - d[1], p.y + d[0]));
        return result;
    }

    private static ArrayEx<PointStruct> dropClosePoints(ArrayEx<PointStruct> points) {
        int N = points.size();
        ArrayEx result = new ArrayEx();
        PointStruct prev = (PointStruct)points.get(0);
        result.add((Object)prev);
        for (int i = 1; i < N - 1; ++i) {
            if (!(ImageMapPathHandler.distance(prev, (PointStruct)points.get(i)) >= 1.0)) continue;
            prev = (PointStruct)points.get(i);
            result.add((Object)prev);
        }
        if (ImageMapPathHandler.distance(prev, (PointStruct)points.get(N - 1)) >= 1.0) {
            result.add(points.get(N - 1));
        } else {
            result.set(result.size() - 1, points.get(N - 1));
        }
        return result;
    }

    private PointStruct pt(double x, double y) {
        return new PointStruct(this._ma * x + this._mb * y + this._me, this._mc * x + this._md * y + this._mf);
    }

    private static double distance(PointStruct p0, PointStruct p1) {
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static void getNormalizedDirection(PointStruct p1, PointStruct p2, double[] result) {
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double d = Math.sqrt(dx * dx + dy * dy);
        result[0] = dx / d;
        result[1] = dy / d;
    }

    private static void getNormalizedBisector(PointStruct prev, PointStruct curr, PointStruct next, double[] result) {
        double dx0 = curr.x - prev.x;
        double dy0 = curr.y - prev.y;
        double l = Math.sqrt(dx0 * dx0 + dy0 * dy0);
        dx0 /= l;
        dy0 /= l;
        double dx1 = next.x - curr.x;
        double dy1 = next.y - curr.y;
        l = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        dx1 /= l;
        dy1 /= l;
        if (Math.abs(dx1 - dx0) < 0.001 && Math.abs(dy1 - dy0) < 0.001) {
            result[0] = dy0;
            result[1] = -dx0;
            return;
        }
        if (Math.abs(dx1 + dx0) < 0.001 && Math.abs(dy1 + dy0) < 0.001) {
            result[0] = -dx0;
            result[1] = -dy0;
            return;
        }
        double dx = dx0 + dx1;
        double dy = dy0 + dy1;
        l = Math.sqrt(dx * dx + dy * dy);
        result[0] = dy / l;
        result[1] = -dx / l;
    }
}

