/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.action.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.library.action.internal.ActionImpl;
import com.ibm.vida.rave.library.action.internal.BindingManager;
import com.ibm.vida.rave.library.framework.meta.ActionMeta;
import com.ibm.vida.rave.library.i18n.MessagesRegistry;

public class ActionsManager {
    private OMap<String, ActionImpl> actionMap = new OMap();
    private ArrayEx<ActionMeta> _meta = new ArrayEx();
    private BindingManager bindingManager = new BindingManager();

    public void populate(JSONArray json, MessagesRegistry messages) {
        ArrayEx actionList = new ArrayEx();
        for (int i = 0; i < json.size(); ++i) {
            actionList.add((Object)ActionMeta.parse((JSONObject)json.get(i), messages));
        }
        this.populate((ArrayEx<ActionMeta>)actionList);
    }

    private void populateFromMeta(ActionMeta info) {
        this.actionMap.put((Object)info.id(), (Object)new ActionImpl(info));
        if (info.defaultBindings() != null) {
            for (int j = 0; j < info.defaultBindings().size(); ++j) {
                ActionMeta.BindingMeta b = (ActionMeta.BindingMeta)info.defaultBindings().get(j);
                this.bindingManager.addBinding(info.id(), b.target(), b.event());
            }
        }
    }

    public void populate(ArrayEx<ActionMeta> actions) {
        for (ActionMeta action : actions) {
            this.populateFromMeta(action);
        }
        this._meta = new ArrayEx();
        for (String key : this.actionMap.keySet()) {
            this._meta.add((Object)((ActionImpl)this.actionMap.get((Object)key)).meta());
        }
    }

    public void configure(JSONObject json) {
        json.get((Object)"actions");
    }

    public final ArrayEx<ActionMeta> meta() {
        return this._meta;
    }

    public ActionImpl action(String id) {
        return (ActionImpl)this.actionMap.get((Object)id);
    }

    public void applyBindings() {
        for (String actionKey : this.actionMap.keySet()) {
            if (!((ActionImpl)this.actionMap.get((Object)actionKey)).autoBind()) continue;
            ((ActionImpl)this.actionMap.get((Object)actionKey)).getBinding().call();
        }
    }
}

