/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.datamodel.ext;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.JsonObject;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.datamodel.DataModel;
import com.ibm.vida.rave.library.datamodel.DataModelDescriptor;
import com.ibm.vida.rave.library.datamodel.DataSetDescriptor;
import com.ibm.vida.rave.library.datamodel.ext.Rave1Importer;

public class Rave1HierarchyImporter
extends Rave1Importer {
    @Override
    public boolean importData(DataModel model, Object data) {
        ImportData idata = (ImportData)data;
        if (model == null) {
            return false;
        }
        if (idata == null || idata.visJSONData == null || idata.index == null || idata.dataSetId == null || idata.levels == null || idata.levels.size() == 0) {
            Rave1HierarchyImporter.reportError(model, 401, null);
            return false;
        }
        int index = idata.index;
        if (index < 0 || index >= idata.visJSONData.size()) {
            Rave1HierarchyImporter.reportError(model, 402, null);
            return false;
        }
        JSONObject raveTable = (JSONObject)idata.visJSONData.get(index);
        if (raveTable == null || raveTable.get((Object)"fields") == null) {
            Rave1HierarchyImporter.reportError(model, 403, null);
            return false;
        }
        DataModelDescriptor modelDescriptor = model.getDescriptor();
        DataSetDescriptor setDescriptor = null;
        for (DataSetDescriptor dsd : modelDescriptor.dataSets()) {
            if (!idata.dataSetId.equals(dsd.id())) continue;
            setDescriptor = dsd;
            break;
        }
        if (setDescriptor == null) {
            Rave1HierarchyImporter.reportError(model, 404, null);
            return false;
        }
        if (!"hierarchy".equals(setDescriptor.type())) {
            Rave1HierarchyImporter.reportError(model, 406, null);
            return false;
        }
        boolean reversed = idata.map != null && idata.reverseMap != null && idata.reverseMap != false;
        OMap<String, ArrayEx<String>> map = Rave1HierarchyImporter.makeMap(model, idata.map, reversed, raveTable, setDescriptor);
        if (map == null) {
            return false;
        }
        ArrayEx<Rave1Importer.AccessorInfo> levels = Rave1HierarchyImporter.makeLevelsInfo(model, raveTable, idata.levels);
        if (levels == null) {
            return false;
        }
        final int numFields = ((JSONArray)raveTable.get((Object)"fields")).size();
        JSONArray root = Rave1HierarchyImporter.makeNode(null, numFields, null);
        JSONArray rows = (JSONArray)raveTable.get((Object)"rows");
        if (rows != null) {
            int numRows = rows.size();
            for (int i = 0; i < numRows; ++i) {
                JSONArray row = (JSONArray)rows.get(i);
                ArrayEx<String> keyValues = Rave1HierarchyImporter.makeKeyValues(row, levels);
                if (keyValues == null) continue;
                Rave1HierarchyImporter.addNode(root, keyValues, row, numFields);
            }
        }
        model.setData(idata.dataSetId, root);
        boolean result = Rave1HierarchyImporter.setSlots(model, setDescriptor, raveTable, map, reversed);
        if (result) {
            SingleValueFunction<Object, Object> childrenAccessor;
            String childrenSlotId = idata.childrenSlotId != null ? idata.childrenSlotId : "children";
            if (model.setDataSlot(idata.dataSetId, childrenSlotId, "object", childrenAccessor = new SingleValueFunction<Object, Object>(){

                public Object getValue(Object row) {
                    if (row instanceof JSONArray) {
                        JSONArray children = (JSONArray)Rave1Importer.getRowValue((JSONArray)row, numFields + 1);
                        if (children == null) {
                            return null;
                        }
                        ArrayEx r = new ArrayEx();
                        for (Object o : children) {
                            r.add(o);
                        }
                        return r;
                    }
                    return null;
                }
            }) < 0) {
                result = false;
            }
            if (idata.levelKeySlotIds != null) {
                SingleValueFunction<Object, Object> levelKeyAccessor = new SingleValueFunction<Object, Object>(){

                    public Object getValue(Object row) {
                        if (row instanceof JSONArray) {
                            JSONArray r = (JSONArray)row;
                            Object o = null;
                            if (r.size() > numFields) {
                                o = r.get(numFields);
                            }
                            return o;
                        }
                        return null;
                    }
                };
                for (String key : idata.levelKeySlotIds) {
                    if (model.setDataSlot(idata.dataSetId, key, "string", levelKeyAccessor) >= 0) continue;
                    result = false;
                }
            }
        }
        return result;
    }

    private static void addNode(JSONArray root, ArrayEx<String> keyValues, JSONArray row, int numFields) {
        JSONArray currentNode = root;
        int numLevels = keyValues.size();
        for (int levelIndex = 0; levelIndex < numLevels; ++levelIndex) {
            JSONArray children = (JSONArray)currentNode.get(numFields + 1);
            if (children == null) {
                children = new JSONArray();
                currentNode.set(numFields + 1, (Object)children);
            }
            JSONArray child = null;
            String keyValue = (String)keyValues.get(levelIndex);
            for (int cnum = 0; cnum < children.size(); ++cnum) {
                if (!keyValue.equals(((JSONArray)children.get(cnum)).get(numFields))) continue;
                child = (JSONArray)children.get(cnum);
                break;
            }
            if (child == null) {
                child = Rave1HierarchyImporter.makeNode((JSONArray)(levelIndex == numLevels - 1 ? row : null), numFields, keyValue);
                children.add((Object)child);
            }
            currentNode = child;
        }
    }

    private static ArrayEx<Rave1Importer.AccessorInfo> makeLevelsInfo(DataModel model, JSONObject raveTable, ArrayEx<String> levels) {
        OMap fieldMap = new OMap();
        JSONArray fields = (JSONArray)raveTable.get((Object)"fields");
        for (int i = 0; i < fields.size(); ++i) {
            String id;
            JSONObject field = (JSONObject)fields.get(i);
            String string = id = field != null ? ObjectConverter.toString((Object)field.get((Object)"id")) : null;
            if (id == null) continue;
            fieldMap.put((Object)id, (Object)i);
        }
        ArrayEx result = new ArrayEx();
        for (String level : levels) {
            Integer index = (Integer)fieldMap.get((Object)level);
            if (index == null) {
                Rave1HierarchyImporter.reportError(model, 407, level);
                return null;
            }
            result.add((Object)Rave1HierarchyImporter.makeAccessor((JSONObject)fields.get(index.intValue()), index));
        }
        return result;
    }

    private static ArrayEx<String> makeKeyValues(JSONArray row, ArrayEx<Rave1Importer.AccessorInfo> levels) {
        if (row == null) {
            return null;
        }
        ArrayEx result = new ArrayEx();
        for (Rave1Importer.AccessorInfo info : levels) {
            Object value = info.accessor.getValue((Object)row);
            if (value == null) {
                return null;
            }
            result.add((Object)ObjectConverter.toString((Object)value));
        }
        return result;
    }

    private static JSONArray makeNode(JSONArray array, int numFields, Object keyValue) {
        JSONArray result = array != null ? array : new JSONArray();
        int targetLength = numFields + 2;
        while (result.size() < targetLength) {
            result.add(null);
        }
        result.set(numFields, keyValue);
        result.set(numFields + 1, null);
        return result;
    }

    @JsonObject
    public static class ImportData {
        public JSONArray visJSONData;
        public Integer index;
        public String dataSetId;
        public ArrayEx<String> levels;
        public String childrenSlotId;
        public ArrayEx<String> levelKeySlotIds;
        public OMap<String, Object> map;
        public Boolean reverseMap;
    }
}

