/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.datamodel.ext;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.JsonObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.collections.OSet;
import com.ibm.vida.rave.core.nativeImpl.time.Date;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.datamodel.DataModel;
import com.ibm.vida.rave.library.datamodel.DataSetDescriptor;
import com.ibm.vida.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.vida.rave.library.datamodel.ext.DataImporter;
import com.ibm.vida.rave.library.datamodel.internal.DataSlotEntryImpl;
import com.ibm.vida.rave.library.service.ErrorDispatcher;

public abstract class Rave1Importer
implements DataImporter {
    @Override
    @SwiftMethodOverload(skipParameters={2})
    public abstract boolean importData(DataModel var1, Object var2);

    protected static OMap<String, ArrayEx<String>> makeMap(DataModel model, OMap<String, Object> map, boolean reversed, JSONObject raveTable, DataSetDescriptor setDescriptor) {
        OMap result = new OMap();
        OSet valueSet = new OSet();
        for (DataSlotDescriptor s : setDescriptor.dataSlots()) {
            valueSet.add((Object)s.id());
        }
        OSet keySet = new OSet();
        JSONArray fields = (JSONArray)raveTable.get((Object)"fields");
        int nFields = fields.size();
        for (int i = 0; i < nFields; ++i) {
            String id;
            JSONObject field = (JSONObject)fields.get(i);
            if (field == null || (id = ObjectConverter.asString((Object)field.get((Object)"id"))) == null) continue;
            if (map != null) {
                keySet.add((Object)id);
                continue;
            }
            if (!valueSet.contains((Object)id)) continue;
            ArrayEx values = new ArrayEx();
            values.add((Object)id);
            result.put((Object)id, (Object)values);
        }
        if (map == null) {
            return result;
        }
        if (reversed) {
            OSet t = keySet;
            keySet = valueSet;
            valueSet = t;
        }
        for (String key : map.keySet()) {
            if (!keySet.contains((Object)key)) {
                if (!reversed) continue;
                Rave1Importer.reportError(model, 405, key);
                return null;
            }
            ArrayEx<String> values = Rave1Importer.mapEntries(key, map);
            if (values == null) continue;
            if (!reversed) {
                for (String value : values) {
                    if (valueSet.contains((Object)value)) continue;
                    Rave1Importer.reportError(model, 405, value);
                    return null;
                }
            }
            result.put((Object)key, values);
        }
        return result;
    }

    private static ArrayEx<String> mapEntries(String key, OMap<String, Object> map) {
        Object o = map.get((Object)key);
        if (o != null) {
            if (o instanceof String) {
                ArrayEx result = new ArrayEx();
                result.add((Object)ObjectConverter.asString((Object)o));
                return result;
            }
            return (ArrayEx)o;
        }
        return null;
    }

    protected static boolean setSlots(DataModel model, DataSetDescriptor dataSet, JSONObject raveTable, OMap<String, ArrayEx<String>> map, boolean reversed) {
        String dataSetId = dataSet.id();
        for (DataSlotDescriptor dsd : dataSet.dataSlots()) {
            model.clearDataSlot(dataSetId, dsd.id());
        }
        return reversed ? Rave1Importer.slotToField(model, dataSetId, raveTable, map) : Rave1Importer.fieldToSlot(model, dataSetId, raveTable, map);
    }

    private static boolean fieldToSlot(DataModel model, String dataSetId, JSONObject raveTable, OMap<String, ArrayEx<String>> map) {
        JSONArray fields = (JSONArray)raveTable.get((Object)"fields");
        int nFields = fields.size();
        for (int i = 0; i < nFields; ++i) {
            String fieldId;
            ArrayEx values;
            JSONObject fieldSpec = (JSONObject)fields.get(i);
            if (fieldSpec == null || (values = (ArrayEx)map.get((Object)(fieldId = ObjectConverter.asString((Object)fieldSpec.get((Object)"id"))))) == null) continue;
            AccessorInfo info = Rave1Importer.makeAccessor(fieldSpec, i);
            for (String slotId : values) {
                DataSlotEntryImpl slotEntry = (DataSlotEntryImpl)model.dataset(dataSetId).slot(slotId).push().type(info.type).accessor(info.accessor).label(info.label);
                if (slotEntry.isValid()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean slotToField(DataModel model, String dataSetId, JSONObject raveTable, OMap<String, ArrayEx<String>> map) {
        OMap fieldsMap = new OMap();
        OSet fieldIdSet = new OSet();
        JSONArray fields = (JSONArray)raveTable.get((Object)"fields");
        int nFields = fields.size();
        for (int i = 0; i < nFields; ++i) {
            String id;
            JSONObject field = (JSONObject)fields.get(i);
            if (field == null || (id = ObjectConverter.asString((Object)field.get((Object)"id"))) == null) continue;
            fieldsMap.put((Object)id, (Object)Rave1Importer.makeAccessor(field, i));
            fieldIdSet.add((Object)id);
        }
        for (String slotId : map.keySet()) {
            ArrayEx fieldIds = (ArrayEx)map.get((Object)slotId);
            for (String fieldId : fieldIds) {
                DataSlotEntryImpl slotEntry;
                AccessorInfo info = (AccessorInfo)fieldsMap.get((Object)fieldId);
                if (info == null || (slotEntry = (DataSlotEntryImpl)model.dataset(dataSetId).slot(slotId).push().type(info.type).accessor(info.accessor).label(info.label)).isValid()) continue;
                return false;
            }
        }
        return true;
    }

    protected static AccessorInfo makeAccessor(JSONObject fieldSpec, int fieldIndex) {
        JSONArray categories = (JSONArray)fieldSpec.get((Object)"categories");
        String unit = ObjectConverter.asString((Object)fieldSpec.get((Object)"unit"));
        AccessorInfo info = categories != null ? Rave1Importer.makeCategoriesAccessor(fieldIndex, categories) : ("categorical".equals(unit) ? Rave1Importer.makeCategoricalAccessor(fieldIndex) : ("timestamp".equals(unit) ? Rave1Importer.makeDateAccessor(fieldIndex, 1000L) : ("date".equals(unit) ? Rave1Importer.makeDateAccessor(fieldIndex, 86400000L) : ("string".equals(unit) ? Rave1Importer.makeStringAccessor(fieldIndex) : ("object".equals(unit) ? Rave1Importer.makeObjectAccessor(fieldIndex) : Rave1Importer.makeNumericAccessor(fieldIndex))))));
        info.label = ObjectConverter.asString((Object)fieldSpec.get((Object)"label"));
        return info;
    }

    protected static Object getRowValue(JSONArray row, int fieldIndex) {
        return row != null && fieldIndex < row.size() ? row.get(fieldIndex) : null;
    }

    private static AccessorInfo makeCategoriesAccessor(final int fieldIndex, final JSONArray categories) {
        AccessorInfo result = new AccessorInfo();
        result.type = "string";
        result.accessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object row) {
                if (row instanceof JSONArray) {
                    Double v = ObjectConverter.asDouble((Object)Rave1Importer.getRowValue((JSONArray)row, fieldIndex));
                    if (v == null) {
                        return null;
                    }
                    int ix = ObjectConverter.toInt((Object)Math.round(v));
                    return ix < 0 || ix >= categories.size() ? null : ObjectConverter.toString((Object)categories.get(ix));
                }
                return null;
            }
        };
        return result;
    }

    private static AccessorInfo makeCategoricalAccessor(final int fieldIndex) {
        AccessorInfo result = new AccessorInfo();
        result.type = "string";
        result.accessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object row) {
                Double v = ObjectConverter.asDouble((Object)Rave1Importer.getRowValue((JSONArray)row, fieldIndex));
                if (v == null) {
                    return null;
                }
                int ix = ObjectConverter.toInt((Object)Math.round(v));
                return ix < 0 ? null : "" + ix;
            }
        };
        return result;
    }

    private static AccessorInfo makeDateAccessor(final int fieldIndex, final long msPer) {
        AccessorInfo result = new AccessorInfo();
        result.type = "date";
        result.accessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object row) {
                if (row instanceof JSONArray) {
                    Double v = ObjectConverter.asDouble((Object)Rave1Importer.getRowValue((JSONArray)row, fieldIndex));
                    return v != null ? new Date((long)(v * (double)msPer)) : null;
                }
                return null;
            }
        };
        return result;
    }

    private static AccessorInfo makeStringAccessor(final int fieldIndex) {
        AccessorInfo result = new AccessorInfo();
        result.type = "string";
        result.accessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object row) {
                if (row instanceof JSONArray) {
                    Object v = Rave1Importer.getRowValue((JSONArray)row, fieldIndex);
                    return v != null ? ObjectConverter.toString((Object)v) : null;
                }
                return null;
            }
        };
        return result;
    }

    private static AccessorInfo makeObjectAccessor(final int fieldIndex) {
        AccessorInfo result = new AccessorInfo();
        result.type = "object";
        result.accessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object row) {
                if (row instanceof JSONArray) {
                    return Rave1Importer.getRowValue((JSONArray)row, fieldIndex);
                }
                return null;
            }
        };
        return result;
    }

    private static AccessorInfo makeNumericAccessor(final int fieldIndex) {
        AccessorInfo result = new AccessorInfo();
        result.type = "numeric";
        result.accessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object row) {
                if (row instanceof JSONArray) {
                    return Rave1Importer.getRowValue((JSONArray)row, fieldIndex);
                }
                return null;
            }
        };
        return result;
    }

    protected static void reportError(DataModel model, int code, String location) {
        ErrorDispatcher.INSTANCE.logError(code, location);
    }

    @JsonObject
    protected static final class AccessorInfo {
        public String type;
        public SingleValueFunction<Object, Object> accessor;
        public String label;

        protected AccessorInfo() {
        }
    }
}

