/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.datamodel.internal;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.library.Library;
import com.ibm.vida.rave.library.datamodel.DataModel;
import com.ibm.vida.rave.library.datamodel.DataModelDescriptor;
import com.ibm.vida.rave.library.datamodel.DataSet;
import com.ibm.vida.rave.library.datamodel.DataSetDescriptor;
import com.ibm.vida.rave.library.datamodel.DataSlot;
import com.ibm.vida.rave.library.datamodel.DataSlotEntry;
import com.ibm.vida.rave.library.datamodel.internal.DataModelDescriptorImpl;
import com.ibm.vida.rave.library.datamodel.internal.DataSetImpl;
import com.ibm.vida.rave.library.datamodel.internal.DataSlotEntryImpl;
import com.ibm.vida.rave.library.service.LibraryError;
import java.util.List;

public class DataModelImpl
implements DataModel {
    private final DataModelDescriptorImpl _descriptor;
    private final ArrayEx<DataSet> _dataSets;
    private boolean _dataChanged;

    public DataModelImpl(DataModelDescriptor descriptor) {
        this._descriptor = (DataModelDescriptorImpl)descriptor;
        this._dataChanged = false;
        this._dataSets = new ArrayEx();
        for (DataSetDescriptor dsd : descriptor.dataSets()) {
            this._dataSets.add((Object)new DataSetImpl(dsd, this));
        }
    }

    @Override
    public final void error(LibraryError error) {
        Library.error(error);
    }

    @Override
    public final DataModelDescriptor getDescriptor() {
        return this._descriptor;
    }

    @Override
    public final DataSet dataset(String dataSetId) {
        Integer ix = this._descriptor.dataSetIndex(dataSetId);
        if (ix == null) {
            this.error(LibraryError.create(106, this._descriptor.id() + "." + dataSetId));
            return null;
        }
        return (DataSet)this._dataSets.get(ix.intValue());
    }

    @Override
    public final ArrayEx<DataSet> datasets() {
        return this._dataSets;
    }

    @Override
    public final boolean validate() {
        boolean OK = true;
        for (DataSet ds : this._dataSets) {
            if (((DataSetImpl)ds).validate()) continue;
            OK = false;
        }
        return OK;
    }

    @Override
    public final DataSlot dataslot(String dataSetId, String dataSlotId) {
        DataSet dataSet = this.dataset(dataSetId);
        return dataSet != null ? dataSet.slot(dataSlotId) : null;
    }

    @Override
    public final boolean setData(String dataSetId, Object data) {
        DataSet dataSet = this.dataset(dataSetId);
        if (dataSet != null) {
            dataSet.data(data);
            return true;
        }
        return false;
    }

    @Override
    public final boolean clearData(String dataSetId) {
        DataSet dataSet = this.dataset(dataSetId);
        if (dataSet != null) {
            dataSet.clear();
            return true;
        }
        return false;
    }

    @Override
    public final Object getData(String dataSetId) {
        DataSet dataSet = this.dataset(dataSetId);
        return dataSet != null ? dataSet.data() : null;
    }

    @Override
    public final int setDataSlot(String dataSetId, String dataSlotId, String type, SingleValueFunction<Object, Object> accessor, List<Object> domain) {
        DataSlot slot = this.dataslot(dataSetId, dataSlotId);
        if (slot == null) {
            return -1;
        }
        DataSlotEntryImpl entry = (DataSlotEntryImpl)slot.push().type(type).accessor(accessor).domain(domain);
        if (!entry.isValid()) {
            return -1;
        }
        return slot.size() - 1;
    }

    @Override
    public final int setDataSlot(String dataSetId, String dataSlotId, String type, SingleValueFunction<Object, Object> accessor) {
        return this.setDataSlot(dataSetId, dataSlotId, type, accessor, null);
    }

    @Override
    public boolean clearDataSlot(String dataSetId, String dataSlotId) {
        DataSlot slot = this.dataslot(dataSetId, dataSlotId);
        if (slot != null) {
            slot.clear();
            return true;
        }
        return false;
    }

    @Override
    public final DataSlotEntry getDataSlotValue(String dataSetId, String dataSlotId) {
        DataSlot slot = this.dataslot(dataSetId, dataSlotId);
        return slot != null ? slot.entry() : null;
    }

    @Override
    public final ArrayEx<DataSlotEntry> getDataSlotValues(String dataSetId, String dataSlotId) {
        DataSlot slot = this.dataslot(dataSetId, dataSlotId);
        return slot != null ? slot.entries() : null;
    }

    public final void dataModelDataChanged() {
        this._dataChanged = true;
    }

    public final boolean dataUpdated() {
        return this._dataChanged;
    }

    public final void dataUpdated(boolean b) {
        this._dataChanged = b;
    }
}

