/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.datamodel.internal;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.library.datamodel.DataSet;
import com.ibm.vida.rave.library.datamodel.DataSetDescriptor;
import com.ibm.vida.rave.library.datamodel.DataSlot;
import com.ibm.vida.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.vida.rave.library.datamodel.internal.DataModelImpl;
import com.ibm.vida.rave.library.datamodel.internal.DataSetDescriptorImpl;
import com.ibm.vida.rave.library.datamodel.internal.DataSlotImpl;
import com.ibm.vida.rave.library.service.LibraryError;

public class DataSetImpl
implements DataSet {
    @SwiftWeak
    private final DataModelImpl _dataModel;
    private final DataSetDescriptorImpl _descriptor;
    private final ArrayEx<DataSlot> _slots;
    private final String _errorLocation;
    private Object _data;

    DataSetImpl(DataSetDescriptor descriptor, DataModelImpl dataModel) {
        this._dataModel = dataModel;
        this._descriptor = (DataSetDescriptorImpl)descriptor;
        this._slots = new ArrayEx();
        for (DataSlotDescriptor slotDescriptor : descriptor.dataSlots()) {
            this._slots.add((Object)new DataSlotImpl(slotDescriptor, this._dataModel, this));
        }
        this._errorLocation = (this._dataModel != null ? this._dataModel.getDescriptor().id() : "null") + "." + this._descriptor._id;
    }

    @Override
    public DataSetDescriptor descriptor() {
        return this._descriptor;
    }

    @Override
    public DataSlot slot(String dataSlotId) {
        Integer ix = this._descriptor.dataSlotIndex(dataSlotId);
        if (ix == null) {
            this._dataModel.error(LibraryError.create(107, this._errorLocation + "." + dataSlotId));
            return null;
        }
        return (DataSlot)this._slots.get(ix.intValue());
    }

    @Override
    public ArrayEx<DataSlot> slots() {
        return this._slots;
    }

    @Override
    public Object data() {
        return this._data;
    }

    @Override
    public DataSet data(Object data) {
        if (data != null) {
            this._data = data;
            this._dataModel.dataModelDataChanged();
        }
        return this;
    }

    @Override
    public DataSet clear() {
        this._data = null;
        this._dataModel.dataModelDataChanged();
        return this;
    }

    final boolean validate() {
        boolean OK = true;
        if ("1".equals(this._descriptor.cardinality()) && this._data == null) {
            this._dataModel.error(LibraryError.create(109, this._errorLocation));
            OK = false;
        }
        for (DataSlot ds : this._slots) {
            if (((DataSlotImpl)ds).validate()) continue;
            OK = false;
        }
        return OK;
    }
}

