/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.datamodel.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.vida.rave.library.i18n.MessagesRegistry;

public final class DataSlotDescriptorImpl
extends DataSlotDescriptor {
    final String _id;
    private String _label;
    private final String _labelDefault;
    final String _description;
    final ArrayEx<String> _tags;
    final String _imageIcon;
    private String _svgIcon;
    private final String _svgIconDefault;
    private String _cardinality;
    private final String _cardinalityDefault;
    boolean _hidden = false;
    final ArrayEx<String> _dataTypes;
    ArrayEx<String> _configDataTypes;
    private MessagesRegistry _messages;

    private DataSlotDescriptorImpl(String id, String label, String description, ArrayEx<String> tags, String imageIcon, String svgIcon, String cardinality, ArrayEx<String> dataTypes) {
        this._id = id;
        this._label = label;
        this._labelDefault = label;
        this._description = description;
        this._tags = tags;
        this._imageIcon = imageIcon;
        this._svgIcon = svgIcon;
        this._svgIconDefault = svgIcon;
        this._cardinality = cardinality;
        this._cardinalityDefault = cardinality;
        this._dataTypes = dataTypes;
    }

    public static DataSlotDescriptorImpl create(JSONObject json) {
        String cardinality;
        String id = ObjectConverter.asString((Object)json.get((Object)"id"));
        String label = ObjectConverter.asString((Object)json.get((Object)"label"));
        String description = ObjectConverter.asString((Object)json.get((Object)"description"));
        ArrayEx tags = new ArrayEx();
        JSONArray t = (JSONArray)json.get((Object)"tags");
        if (t != null) {
            int l = t.size();
            for (int i = 0; i < l; ++i) {
                tags.add((Object)ObjectConverter.toString((Object)t.get(i)));
            }
        }
        String imageIcon = null;
        String svgIcon = null;
        JSONObject icon = (JSONObject)json.get((Object)"icon");
        if (icon != null) {
            imageIcon = (String)icon.get((Object)"image");
            svgIcon = (String)icon.get((Object)"svg");
        }
        if (!("0..1".equals(cardinality = ObjectConverter.toString((Object)json.get((Object)"cardinality"))) || "1".equals(cardinality) || "0..n".equals(cardinality) || "1..n".equals(cardinality))) {
            cardinality = "0..1";
        }
        ArrayEx dataTypes = new ArrayEx();
        t = (JSONArray)json.get((Object)"datatypes");
        if (t != null) {
            int l = t.size();
            for (int i = 0; i < l; ++i) {
                String s = ObjectConverter.toString((Object)t.get(i));
                if (!"numeric".equals(s) && !"string".equals(s) && !"date".equals(s) && !"object".equals(s) && !"array".equals(s)) continue;
                dataTypes.add((Object)s);
            }
        }
        return new DataSlotDescriptorImpl(id, label, description, (ArrayEx<String>)tags, imageIcon, svgIcon, cardinality, (ArrayEx<String>)dataTypes);
    }

    public final DataSlotDescriptorImpl clearConfiguration() {
        this._hidden = false;
        this._configDataTypes = null;
        this._label = this._labelDefault;
        this._svgIcon = this._svgIconDefault;
        this._cardinality = this._cardinalityDefault;
        return this;
    }

    public final DataSlotDescriptorImpl configure(JSONObject slotConfig) {
        String svgIcon;
        String label;
        String cardinality;
        this._hidden = ObjectConverter.toBoolean((Object)slotConfig.get((Object)"hidden"));
        JSONArray configDataTypes = (JSONArray)slotConfig.get((Object)"dataTypes");
        if (configDataTypes != null) {
            this._configDataTypes = new ArrayEx();
            for (Object dataTypeObj : configDataTypes) {
                String dataType = (String)dataTypeObj;
                if (!this._dataTypes.contains((Object)dataType)) continue;
                this._configDataTypes.add((Object)dataType);
            }
        }
        if ((cardinality = (String)slotConfig.get((Object)"cardinality")) != null) {
            this._cardinality = cardinality;
        }
        if ((label = (String)slotConfig.get((Object)"label")) != null) {
            this._label = label;
        }
        if ((svgIcon = (String)slotConfig.get((Object)"svgIcon")) != null) {
            this._svgIcon = svgIcon;
        }
        JSONArray configTags = (JSONArray)slotConfig.get((Object)"tags");
        for (int i = 0; configTags != null && i < configTags.size(); ++i) {
            String tag = (String)configTags.get(i);
            if (this._tags.indexOf((Object)tag) != -1) continue;
            this._tags.add((Object)tag);
        }
        return this;
    }

    public final void setMessages(MessagesRegistry messages) {
        this._messages = messages;
    }

    @Override
    public final String id() {
        return this._id;
    }

    @Override
    public final String label() {
        if (this._messages == null) {
            return this._label;
        }
        return this._messages._nls(this._label, this._label);
    }

    @Override
    public final String description() {
        if (this._messages == null) {
            return this._description;
        }
        return this._messages._nls(this._description, this._description);
    }

    @Override
    public final ArrayEx<String> tags() {
        if (this._messages == null) {
            return this._tags;
        }
        ArrayEx msgTags = new ArrayEx();
        for (String tag : this._tags) {
            msgTags.add((Object)this._messages._nls(tag, tag));
        }
        return msgTags;
    }

    @Override
    public final String icon(String type) {
        if ("image".equals(type)) {
            return this._imageIcon;
        }
        return this._svgIcon;
    }

    @Override
    public final String cardinality() {
        return this._cardinality;
    }

    @Override
    public final boolean isMultiple() {
        return this._cardinality.equals("0..n") || this._cardinality.equals("1..n");
    }

    @Override
    public final boolean isRequired() {
        return this._cardinality.equals("1") || this._cardinality.equals("1..n");
    }

    @Override
    public final ArrayEx<String> dataTypes() {
        if (this._configDataTypes != null) {
            return this._configDataTypes;
        }
        return this._dataTypes;
    }

    @Override
    public boolean isHidden() {
        return this._hidden;
    }

    boolean isValidType(String type) {
        for (String s : this.dataTypes()) {
            if (!s.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataSlotDescriptorImpl copy() {
        DataSlotDescriptorImpl slot = new DataSlotDescriptorImpl(this._id, this._labelDefault, this._description, this._tags, this._imageIcon, this._svgIconDefault, this._cardinalityDefault, this._dataTypes);
        slot._messages = this._messages;
        slot._configDataTypes = null;
        slot._hidden = false;
        return slot;
    }
}

