/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.internal;

import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public class CSSConverter {
    public static final Double convertCSSSizeToPixelNumber(Object value, double extent, double em) {
        double v;
        if (value == null) {
            return null;
        }
        String s = ObjectConverter.toString((Object)value);
        int l = s.length();
        if (l == 0) {
            return null;
        }
        String number = s;
        boolean found = false;
        double multiplier = 1.0;
        if (l > 2) {
            number = s.substring(0, l - 2);
            String u = s.substring(l - 2).toLowerCase();
            if ("px".equals(u)) {
                found = true;
                multiplier = 1.0;
            } else if ("in".equals(u)) {
                found = true;
                multiplier = 96.0;
            } else if ("pt".equals(u)) {
                found = true;
                multiplier = 1.3333333333333333;
            } else if ("pc".equals(u)) {
                found = true;
                multiplier = 16.0;
            } else if ("em".equals(u)) {
                found = true;
                multiplier = em;
            } else if ("cm".equals(u)) {
                found = true;
                multiplier = 37.79527559055118;
            } else if ("mm".equals(u)) {
                found = true;
                multiplier = 3.7795275590551185;
            }
        }
        if (!found) {
            if (l > 1 && "%".equals(s.substring(l - 1))) {
                number = s.substring(0, l - 1);
                multiplier = extent / 100.0;
            } else {
                number = s;
                multiplier = 1.0;
            }
        }
        if (Double.isNaN(v = ObjectConverter.toDouble((Object)number))) {
            return null;
        }
        return v * multiplier;
    }

    public static final String convertCSSSizeToPixel(Object value, double extent, double em) {
        Double v = CSSConverter.convertCSSSizeToPixelNumber(value, extent, em);
        if (v == null) {
            return null;
        }
        return ObjectConverter.toString((Object)((double)Math.round(100.0 * v) / 100.0)) + "px";
    }
}

