/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.internal;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.OrdinalScale;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.ArrayList;
import java.util.List;

public class ClusteredSkipMissingCoordinateScale
extends CoordinateScaleImpl {
    private final ArrayEx<OrdinalScale> _scales;
    private List<Object> _originalDomain;
    private ValueFunction<Object, String> _originalDomainLabelAccessor;
    private double _firstWidth;

    private ClusteredSkipMissingCoordinateScale(ES6Map<Object, List<Object>> subDomainMap, List<Object> domain, List<Object> originalDomain) {
        ArrayEx nonNullDomains = new ArrayEx();
        ArrayEx nonNullOriginalDomains = new ArrayEx();
        for (int i = 0; i < domain.size(); ++i) {
            Object domainKey = domain.get(i);
            if (domainKey == null || subDomainMap.get(domainKey) == null || ((List)subDomainMap.get(domainKey)).size() <= 0) continue;
            nonNullDomains.add(domainKey);
            nonNullOriginalDomains.add(originalDomain.get(i));
        }
        this._scales = new ArrayEx();
        this._scales.add((Object)Rave.scale.ordinal().domain((List)nonNullDomains));
        for (Object domainKey : nonNullDomains) {
            this._scales.add((Object)Rave.scale.ordinal().domain((List)subDomainMap.get(domainKey)));
        }
        OrdinalScale scale = (OrdinalScale)this._scales.get(0);
        this._firstWidth = domain.size() > 1 ? ObjectConverter.toDouble((Object)scale.getValue(null, domain.get(0), 0, 0)) - ObjectConverter.toDouble((Object)scale.getValue(null, domain.get(1), 0, 0)) : 1.0;
        this._originalDomain = nonNullOriginalDomains;
    }

    public static ClusteredSkipMissingCoordinateScale create(ES6Map<Object, List<Object>> subDomainMap, List<Object> domain, List<? extends Object> originalDomain) {
        return new ClusteredSkipMissingCoordinateScale(subDomainMap, domain, originalDomain);
    }

    public static ClusteredSkipMissingCoordinateScale create(ES6Map<Object, List<Object>> subDomainMap, List<Object> domain) {
        if (subDomainMap == null || domain == null) {
            return null;
        }
        return ClusteredSkipMissingCoordinateScale.create(subDomainMap, domain, null);
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    public AbstractScale<?, ?> scale() {
        return (AbstractScale)this._scales.get(0);
    }

    @Override
    public CoordinateScaleImpl range(double v1, double v2, Double padding, Double outerPadding, boolean round) {
        OrdinalScale scale;
        boolean rev = v2 < v1;
        int s = this._scales.size();
        double entries = 0.0;
        ArrayEx range = new ArrayEx();
        for (int i = 1; i < s; ++i) {
            scale = (OrdinalScale)this._scales.get(i);
            entries += (double)scale.domain().size();
        }
        double intervalOffsetPercent = 0.0;
        for (int i = 1; i < s; ++i) {
            scale = (OrdinalScale)this._scales.get(i);
            double intervalPercent = (double)scale.domain().size() / entries;
            Double rangePoint = rev ? Double.valueOf(v2 + (v1 - v2) * (intervalOffsetPercent + intervalPercent * 0.5)) : Double.valueOf(v1 + (v2 - v1) * (intervalOffsetPercent + intervalPercent * 0.5));
            range.add((Object)rangePoint);
            intervalOffsetPercent += intervalPercent;
            double width = Math.abs(v2 - v1) * intervalPercent;
            if (round && ClusteredSkipMissingCoordinateScale.useRounding(0.0, width, scale.domain().size(), padding, outerPadding * 4.0)) {
                scale.rangeRoundBands((List)(rev ? new ArrayEx(new Object[]{width, 0}) : new ArrayEx(new Object[]{0, width})), padding, Double.valueOf(outerPadding * 4.0));
                continue;
            }
            scale.rangeBands((List)(rev ? new ArrayEx(new Object[]{width, 0}) : new ArrayEx(new Object[]{0, width})), padding, Double.valueOf(outerPadding * 4.0));
        }
        scale = (OrdinalScale)this._scales.get(0);
        List domain = scale.domain();
        ((OrdinalScale)this._scales.get(0)).range((List)range);
        if (domain.size() > 1) {
            scale.range((List)range);
            this._firstWidth = ObjectConverter.toDouble((Object)scale.getValue(null, domain.get(0), 0, 0)) - ObjectConverter.toDouble((Object)scale.getValue(null, domain.get(1), 0, 0));
        } else {
            scale.rangeBands((List)new ArrayEx(new Object[]{v1, v2}), Double.valueOf(0.0), Double.valueOf(0.0));
            this._firstWidth = scale.rangeBand.getValue().doubleValue();
        }
        return this;
    }

    @Override
    public Number center(Object data) {
        return this.getCoord(ClusteredSkipMissingCoordinateScale.toArray(data), 0.5);
    }

    @Override
    public Number lower(Object data) {
        return this.getCoord(ClusteredSkipMissingCoordinateScale.toArray(data), 0.0);
    }

    @Override
    public Number upper(Object data) {
        return this.getCoord(ClusteredSkipMissingCoordinateScale.toArray(data), 1.0);
    }

    @Override
    public double width() {
        return ObjectConverter.toDouble((Object)((OrdinalScale)this._scales.get((int)1)).rangeBand.getValue()) * this.getZoomFactor();
    }

    private Number getCoord(List<Object> data, double wmult) {
        if (data == null || data.size() == 0) {
            return null;
        }
        OrdinalScale scale = (OrdinalScale)this._scales.get(0);
        if (scale.getValue(null, data.get(0), 0, 0) == null) {
            return null;
        }
        List domain = scale.domain();
        double zoomFactor = this.getZoomFactor();
        double rangePoint = ObjectConverter.toDouble((Object)scale.getValue(null, data.get(0), 0, 0)) + scale.rangeBand.getValue().doubleValue() * 0.5;
        for (int i = 0; i < domain.size(); ++i) {
            if (domain.get(i) != data.get(0)) continue;
            scale = (OrdinalScale)this._scales.get(i + 1);
            List scaleRange = scale.getRangeExtent().getValue();
            double scaleMidPoint = Math.abs(ObjectConverter.toDouble(scaleRange.get(0)) - ObjectConverter.toDouble(scaleRange.get(scaleRange.size() - 1))) / 2.0;
            double midPoint = scale.getValue(null, data.get(1), 0, 0) != null ? Double.valueOf(ObjectConverter.toDouble((Object)scale.getValue(null, data.get(1), 0, 0))) : null;
            double band = scale.rangeBand.getValue().doubleValue();
            double point = midPoint + band * wmult;
            double diff = (scaleMidPoint - point) * zoomFactor;
            return rangePoint - diff;
        }
        return null;
    }

    private double getZoomFactor() {
        OrdinalScale scale = (OrdinalScale)this._scales.get(0);
        List domain = scale.domain();
        double width = domain.size() > 1 ? ObjectConverter.toDouble((Object)scale.getValue(null, domain.get(0), 0, 0)) - ObjectConverter.toDouble((Object)scale.getValue(null, domain.get(1), 0, 0)) : scale.rangeBand.getValue().doubleValue();
        return this._firstWidth == 0.0 ? 0.0 : width / this._firstWidth;
    }

    private static List<Object> toArray(Object data) {
        ArrayList<Object> arrayData;
        if (!(data instanceof List)) {
            arrayData = new ArrayList<Object>();
            arrayData.add(data);
        } else {
            arrayData = (ArrayList<Object>)data;
        }
        return arrayData;
    }

    @Override
    public List<Object> originalDomain() {
        return this._originalDomain;
    }

    @Override
    public void originalDomainLabelAccessor(ValueFunction<Object, String> accessor) {
        this._originalDomainLabelAccessor = accessor;
    }

    @Override
    public ValueFunction<Object, String> originalDomainLabelAccessor() {
        return this._originalDomainLabelAccessor;
    }

    @Override
    public List<Object> rangeExtent() {
        ArrayList<Object> rangeExtent = new ArrayList<Object>();
        if (this._scales.size() == 0) {
            rangeExtent.add(0);
            rangeExtent.add(0);
            return rangeExtent;
        }
        double startOffset = 0.0;
        double endOffset = 0.0;
        List rangePoints = ((OrdinalScale)this._scales.get(0)).range();
        double rangeStart = ObjectConverter.toDouble(rangePoints.get(0));
        double rangeEnd = ObjectConverter.toDouble(rangePoints.get(rangePoints.size() - 1));
        if (this._scales.size() >= 1) {
            List scaleRangeExtent = ((OrdinalScale)this._scales.get(1)).getRangeExtent().getValue();
            startOffset = Math.max(ObjectConverter.toDouble(scaleRangeExtent.get(0)), ObjectConverter.toDouble(scaleRangeExtent.get(1))) / 2.0;
            if (this._scales.size() > 1) {
                scaleRangeExtent = ((OrdinalScale)this._scales.get(this._scales.size() - 1)).getRangeExtent().getValue();
                endOffset = Math.max(ObjectConverter.toDouble(scaleRangeExtent.get(0)), ObjectConverter.toDouble(scaleRangeExtent.get(1))) / 2.0;
            }
        }
        rangeExtent.add(rangeStart - startOffset);
        rangeExtent.add(rangeEnd + endOffset);
        return rangeExtent;
    }
}

