/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.internal;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.layout.hierarchy.HierarchyNode;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import java.util.List;

public class HierarchyUtility<T extends HierarchyNode<T>> {
    private final HUFactory<T> _factory;

    public HierarchyUtility(HUFactory<T> factory) {
        this._factory = factory;
    }

    public HUResult buildHierarchy(Object originalRoot, SingleValueFunction<Object, Object> childrenAccessor, SingleValueFunction<Object, Object> valueAccessor, double defaultValue) {
        HUResult result = new HUResult();
        if (originalRoot == null) {
            result._minValue = 1.0;
            result._maxValue = 1.0;
            return result;
        }
        SingleValueFunction<Number, Object> vf = this.valueFunction(valueAccessor, defaultValue);
        result._root = this.make(result, originalRoot, vf, null);
        if (childrenAccessor == null) {
            result._originalLeaves.add(originalRoot);
            return result;
        }
        this.processTree(result, result._root, childrenAccessor, vf);
        return result;
    }

    private void processTree(HUResult result, T node, SingleValueFunction<Object, Object> childrenAccessor, SingleValueFunction<Number, Object> valueAccessor) {
        List oChildren = (List)childrenAccessor.getValue(((HierarchyNode)node).data);
        if (oChildren != null) {
            ArrayEx children = new ArrayEx();
            for (Object oChild : oChildren) {
                if (oChild == null) continue;
                T child = this.make(result, oChild, valueAccessor, node);
                children.add(child);
                this.processTree(result, child, childrenAccessor, valueAccessor);
            }
            if (children.size() != 0) {
                ((HierarchyNode)node).children = children;
            }
        }
        if (((HierarchyNode)node).children == null) {
            result._originalLeaves.add(((HierarchyNode)node).data);
        }
    }

    public HUResult buildTabular(List<Object> objects, SingleValueFunction<Object, Object> valueAccessor, double defaultValue) {
        ArrayEx children;
        HUResult result = new HUResult();
        if (objects == null || objects.size() == 0) {
            result._minValue = 1.0;
            result._maxValue = 1.0;
            return result;
        }
        SingleValueFunction<Number, Object> vf = this.valueFunction(valueAccessor, defaultValue);
        T root = this._factory.make();
        result._root = root;
        ((HierarchyNode)root).data = null;
        ((HierarchyNode)root).value = defaultValue;
        ((HierarchyNode)root).parent = null;
        ((HierarchyNode)root).depth = 0;
        ((HierarchyNode)root).children = children = new ArrayEx();
        for (Object oChild : objects) {
            if (oChild == null) continue;
            T child = this.make(result, oChild, vf, root);
            children.add(child);
            result._originalLeaves.add(oChild);
        }
        return result;
    }

    private T make(HUResult result, Object o, SingleValueFunction<Number, Object> vf, T parent) {
        T node = this._factory.make();
        ((HierarchyNode)node).data = o;
        ((HierarchyNode)node).value = ObjectConverter.toDouble((Object)vf.getValue(o));
        ((HierarchyNode)node).parent = parent;
        ((HierarchyNode)node).depth = parent != null ? ((HierarchyNode)parent).depth + 1 : 0;
        ((HierarchyNode)node).children = null;
        result._nodes.add(node);
        result._originalNodes.add(o);
        result._minValue = Math.min(result._minValue, ((HierarchyNode)node).value);
        result._maxValue = Math.max(result._maxValue, ((HierarchyNode)node).value);
        return node;
    }

    private SingleValueFunction<Number, Object> valueFunction(final SingleValueFunction<Object, Object> valueAccessor, final double defaultValue) {
        if (valueAccessor != null) {
            return new SingleValueFunction<Number, Object>(){

                public Number getValue(Object o) {
                    Double v = ObjectConverter.toDouble((Object)valueAccessor.getValue(o));
                    return v != null ? v : Double.valueOf(defaultValue);
                }
            };
        }
        return new SingleValueFunction<Number, Object>(){

            public Number getValue(Object o) {
                return defaultValue;
            }
        };
    }

    public class HUResult {
        public T _root = null;
        public final ArrayEx<T> _nodes = new ArrayEx();
        public final ArrayEx<Object> _originalNodes = new ArrayEx();
        public final ArrayEx<Object> _originalLeaves = new ArrayEx();
        public double _minValue = Double.POSITIVE_INFINITY;
        public double _maxValue = Double.NEGATIVE_INFINITY;
    }

    @FunctionClass(value="make")
    public static abstract class HUFactory<S extends HierarchyNode<S>> {
        public abstract S make();
    }
}

