/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.internal;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.LinearScale;
import com.ibm.vida.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.ArrayList;
import java.util.List;

public class LinearCoordinateScale
extends CoordinateScaleImpl {
    private final LinearScale _scale;
    private double _width;

    public static CoordinateScaleImpl create(List<Object> domain) {
        return domain != null ? new LinearCoordinateScale(domain) : null;
    }

    private LinearCoordinateScale(List<Object> domain) {
        this._scale = Rave.scale.linear().domain(domain);
        this._width = 0.0;
    }

    @Override
    public AbstractScale<?, ?> scale() {
        return this._scale;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public CoordinateScaleImpl range(double v1, double v2, Double padding, Double outerPadding, boolean round) {
        if (round) {
            this._scale.rangeRound((List)new ArrayEx(new Object[]{v1, v2}));
        } else {
            this._scale.range((List)new ArrayEx(new Object[]{v1, v2}));
        }
        return this;
    }

    @Override
    public Number center(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0));
    }

    @Override
    public Number lower(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0)) - this._width;
    }

    @Override
    public Number upper(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0)) + this._width;
    }

    @Override
    public double width() {
        return 2.0 * this._width;
    }

    @Override
    public void setWidth(double width) {
        if (width >= 0.0) {
            this._width = width / 2.0;
        }
    }

    @Override
    public CoordinateScaleImpl expandFraction(double fraction, boolean keepZero) {
        if (fraction > 0.0) {
            ArrayEx d = this._scale.domain();
            double d0 = ObjectConverter.toDouble((Object)d.get(0));
            double d1 = ObjectConverter.toDouble((Object)d.get(d.size() - 1));
            double dd = fraction * (d1 - d0);
            if (!keepZero || ObjectConverter.toDouble((Object)d.get(0)) != 0.0) {
                d.set(0, (Object)(d0 - dd));
            }
            if (!keepZero || ObjectConverter.toDouble((Object)d.get(d.size() - 1)) != 0.0) {
                d.set(d.size() - 1, (Object)(d1 + dd));
            }
            this._scale.domain((List)d);
        }
        return this;
    }

    @Override
    public CoordinateScaleImpl expandPixels(double pixels, boolean keepZero) {
        if (pixels > 0.0) {
            ArrayEx d;
            ArrayEx r = this._scale.range();
            double dr = Math.abs(ObjectConverter.toDouble((Object)r.get(0)) - ObjectConverter.toDouble((Object)r.get(r.size() - 1)));
            double reduction = 2.0 * pixels;
            if (keepZero && (ObjectConverter.toDouble((Object)(d = this._scale.domain()).get(0)) == 0.0 || ObjectConverter.toDouble((Object)d.get(d.size() - 1)) == 0.0)) {
                reduction = pixels;
            }
            if (dr > reduction) {
                return this.expandFraction(pixels / (dr - reduction), keepZero);
            }
        }
        return this;
    }

    @Override
    public CoordinateScaleImpl includeZero() {
        double d1;
        ArrayEx d = this._scale.domain();
        double d0 = ObjectConverter.toDouble((Object)d.get(0));
        if (d0 * (d1 = ObjectConverter.toDouble((Object)d.get(d.size() - 1))) > 0.0) {
            if (d0 < 0.0) {
                int index = d0 > d1 ? 0 : d.size() - 1;
                d.set(index, (Object)0.0);
            } else {
                int index = d1 >= d0 ? 0 : d.size() - 1;
                d.set(index, (Object)0.0);
            }
            this._scale.domain((List)d);
        }
        return this;
    }

    @Override
    public CoordinateScaleImpl expandZeroExtent(boolean keepZero) {
        double d1;
        ArrayEx d = this._scale.domain();
        List extent = Rave.extent((Object[])d.toArray());
        double d0 = ObjectConverter.toDouble(extent.get(0));
        if (d0 == (d1 = ObjectConverter.toDouble(extent.get(1)))) {
            if (d0 == 0.0) {
                if (!keepZero) {
                    d.set(0, (Object)-1.0);
                }
                d.set(d.size() - 1, (Object)1.0);
            } else {
                double del = Math.max(1.0, Math.abs(d0 / 100.0));
                d.set(0, (Object)(d0 - del));
                d.set(d.size() - 1, (Object)(d0 + del));
            }
            this._scale.domain((List)d);
        }
        return this;
    }

    @Override
    public CoordinateScaleImpl nice() {
        this._scale.nice();
        return this;
    }

    @Override
    public CoordinateScaleImpl nice(Number tickCount) {
        this._scale.nice(tickCount);
        return this;
    }

    @Override
    public CoordinateScaleImpl setMinValue(Object _minValue) {
        if (_minValue == null) {
            return this;
        }
        ArrayEx d = this._scale.domain();
        d.set(0, (Object)ObjectConverter.toDouble((Object)_minValue));
        this._scale.domain((List)d);
        return this;
    }

    @Override
    public CoordinateScaleImpl setMaxValue(Object _maxValue) {
        if (_maxValue == null) {
            return this;
        }
        ArrayEx d = this._scale.domain();
        d.set(d.size() - 1, _maxValue);
        this._scale.domain((List)d);
        return this;
    }

    @Override
    public List<Object> rangeExtent() {
        ArrayEx range = this._scale.range();
        ArrayList<Object> rangeExtent = new ArrayList<Object>();
        rangeExtent.add(range.get(range.size() - 1));
        rangeExtent.add(range.get(0));
        return rangeExtent;
    }
}

