/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.internal;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.LogScale;
import com.ibm.vida.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.ArrayList;
import java.util.List;

public class LogCoordinateScale
extends CoordinateScaleImpl {
    private LogScale _scale;
    private double _width;

    public static CoordinateScaleImpl create(List<Object> domain) {
        return domain != null ? new LogCoordinateScale(domain) : null;
    }

    private LogCoordinateScale(List<Object> domain) {
        this._scale = Rave.scale.log().domain(domain);
        this._width = 0.0;
    }

    @Override
    public AbstractScale<?, ?> scale() {
        return this._scale;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public boolean isLogarithmic() {
        return true;
    }

    @Override
    public CoordinateScaleImpl range(double v1, double v2, Double padding, Double outerPadding, boolean round) {
        if (round) {
            this._scale.rangeRound((List)new ArrayEx(new Object[]{v1, v2}));
        } else {
            this._scale.range((List)new ArrayEx(new Object[]{v1, v2}));
        }
        return this;
    }

    @Override
    public Number center(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0));
    }

    @Override
    public Number lower(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0)) - this._width;
    }

    @Override
    public Number upper(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0)) + this._width;
    }

    @Override
    public double width() {
        return 2.0 * this._width;
    }

    @Override
    public void setWidth(double width) {
        if (width >= 0.0) {
            this._width = width / 2.0;
        }
    }

    @Override
    public CoordinateScaleImpl nice() {
        this._scale.nice();
        return this;
    }

    @Override
    public CoordinateScaleImpl setMinValue(Object _minValue) {
        if (_minValue == null) {
            return this;
        }
        ArrayEx d = this._scale.domain();
        d.set(0, (Object)ObjectConverter.toDouble((Object)_minValue));
        this._scale.domain((List)d);
        return this;
    }

    @Override
    public CoordinateScaleImpl setMaxValue(Object _maxValue) {
        if (_maxValue == null) {
            return this;
        }
        ArrayEx d = this._scale.domain();
        d.set(d.size() - 1, _maxValue);
        this._scale.domain((List)d);
        return this;
    }

    @Override
    public List<Object> rangeExtent() {
        ArrayEx range = this._scale.range();
        ArrayList<Object> rangeExtent = new ArrayList<Object>();
        rangeExtent.add(range.get(range.size() - 1));
        rangeExtent.add(range.get(0));
        return rangeExtent;
    }
}

