/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.internal;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.internal.collections.OSet;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.time.IDate;
import com.ibm.vida.rave.core.util.Comparator;
import com.ibm.vida.rave.library.datamodel.DataSlotEntry;
import com.ibm.vida.rave.library.framework.internal.ClusteredCoordinateScale;
import com.ibm.vida.rave.library.framework.internal.ClusteredSkipMissingCoordinateScale;
import com.ibm.vida.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.vida.rave.library.framework.internal.LinearCoordinateScale;
import com.ibm.vida.rave.library.framework.internal.LogCoordinateScale;
import com.ibm.vida.rave.library.framework.internal.OrdinalCoordinateScale;
import com.ibm.vida.rave.library.framework.internal.OrdinalCoordinateScaleDatum;
import com.ibm.vida.rave.library.framework.internal.TimeCoordinateScale;
import java.util.List;

public class ScaleManager {
    public static ArrayEx<Object> numericDomainWithValueFunction(List<? extends Object> data, final SingleValueFunction<Object, Object> valueFunction) {
        if (data == null || valueFunction == null) {
            return null;
        }
        ValueFunction vf = new ValueFunction<List<?>, Object>(){

            public Object getValue(List<?> c, Object d, int i, int g) {
                return valueFunction.getValue(d);
            }
        };
        Object min = Rave.min(data, (ValueFunction)vf);
        if (min != null) {
            return new ArrayEx(new Object[]{min, Rave.max(data, (ValueFunction)vf)});
        }
        return null;
    }

    public static List<Object> numericDomain(List<? extends Object> data, DataSlotEntry accessor) {
        if (data == null || accessor == null || !"numeric".equals(accessor.type()) && !"date".equals(accessor.type())) {
            return null;
        }
        if (accessor.domain() != null) {
            return accessor.domain();
        }
        return ScaleManager.numericDomainWithValueFunction(data, accessor.accessor());
    }

    public static List<Object> ordinalDomainWithValueFunction(List<? extends Object> data, String dataType, SingleValueFunction<Object, Object> valueFunction, boolean sort) {
        if (data == null || valueFunction == null) {
            return null;
        }
        OSet set = new OSet();
        ArrayEx list = new ArrayEx();
        if ("date".equals(dataType)) {
            for (Object object : data) {
                long t;
                Object v = valueFunction.getValue(object);
                if (v == null || set.contains((Object)(t = ((IDate)v).getTime()))) continue;
                set.add((Object)t);
                list.add(v);
            }
        } else {
            for (Object object : data) {
                Object v = valueFunction.getValue(object);
                if (v == null || set.contains(v)) continue;
                set.add(v);
                list.add(v);
            }
        }
        if (sort) {
            if ("numeric".equals(dataType)) {
                list.sort((Comparator)new Comparator<Object>(){

                    public int compare(Object o1, Object o2) {
                        return ObjectConverter.toDouble((Object)o1) < ObjectConverter.toDouble((Object)o2) ? -1 : 1;
                    }
                });
            } else if ("date".equals(dataType)) {
                list.sort((Comparator)new Comparator<Object>(){

                    public int compare(Object o1, Object o2) {
                        return ((IDate)o1).getTime() < ((IDate)o2).getTime() ? -1 : 1;
                    }
                });
            } else {
                list.sort();
            }
        }
        return list;
    }

    public static List<Object> ordinalDomain(List<? extends Object> data, DataSlotEntry accessor, boolean sort) {
        if (data == null || accessor == null) {
            return null;
        }
        String type = accessor.type();
        if ("object".equals(type) || "array".equals(type)) {
            return null;
        }
        if (accessor.domain() != null) {
            return accessor.domain();
        }
        return ScaleManager.ordinalDomainWithValueFunction(data, type, accessor.accessor(), sort);
    }

    public static List<Object> ordinalDomain(List<? extends Object> data, DataSlotEntry accessor) {
        return ScaleManager.ordinalDomain(data, accessor, false);
    }

    public static CoordinateScaleImpl makeCoordinateScale(List<? extends Object> data, DataSlotEntry accessor) {
        if (data == null || accessor == null) {
            return null;
        }
        if ("numeric".equals(accessor.type())) {
            List<Object> domain = ScaleManager.numericDomain(data, accessor);
            return domain != null ? LinearCoordinateScale.create(domain) : null;
        }
        if ("string".equals(accessor.type())) {
            ArrayEx domain = null;
            ArrayEx originalDomain = null;
            if (data != null && accessor != null) {
                if (accessor.domain() != null) {
                    domain = accessor.domain();
                    ES6Map originalDomainMap = ES6Map.create();
                    for (Object object : domain) {
                        originalDomainMap.set(object, (Object)new OrdinalCoordinateScaleDatum(object));
                    }
                    for (Object object : data) {
                        Object key = accessor.getValue(object);
                        OrdinalCoordinateScaleDatum ordinalCoordinateScaleDatum = (OrdinalCoordinateScaleDatum)originalDomainMap.get(key);
                        if (ordinalCoordinateScaleDatum == null) continue;
                        ordinalCoordinateScaleDatum.push(object);
                    }
                    originalDomain = new ArrayEx();
                    for (Object object : domain) {
                        originalDomain.add(originalDomainMap.get(object));
                    }
                } else {
                    OSet set = new OSet();
                    ArrayEx list = new ArrayEx();
                    ES6Map eS6Map = ES6Map.create();
                    for (Object object : data) {
                        Object v = accessor.getValue(object);
                        if (v == null) continue;
                        if (!set.contains(v)) {
                            set.add(v);
                            list.add(v);
                            eS6Map.set(v, (Object)new OrdinalCoordinateScaleDatum(v));
                        }
                        ((OrdinalCoordinateScaleDatum)eS6Map.get(v)).push(object);
                    }
                    domain = list;
                    originalDomain = new ArrayEx();
                    for (Object object : domain) {
                        originalDomain.add(eS6Map.get(object));
                    }
                }
            }
            OrdinalCoordinateScale s = OrdinalCoordinateScale.create(domain, originalDomain);
            s.originalDomainLabelAccessor(new ValueFunction<Object, String>(){

                @SwiftMethodOverload(skipParameters={1})
                public String getValue(Object context, Object data, int index, int groupIndex) {
                    Object key = ((OrdinalCoordinateScaleDatum)data).key();
                    return ObjectConverter.toString((Object)key);
                }
            });
            return domain.size() > 0 ? s : null;
        }
        if ("date".equals(accessor.type())) {
            List<Object> domain = ScaleManager.numericDomain(data, accessor);
            return domain != null ? TimeCoordinateScale.create(domain) : null;
        }
        return null;
    }

    public static CoordinateScaleImpl makeLogCoordinateScale(List<Object> data, DataSlotEntry accessor) {
        if (data == null || accessor == null || !"numeric".equals(accessor.type())) {
            return null;
        }
        List<Object> domain = ScaleManager.numericDomain(data, accessor);
        return domain != null ? LogCoordinateScale.create(domain) : null;
    }

    public static CoordinateScaleImpl makeClusteredScale(List<? extends Object> data, List<DataSlotEntry> accessors) {
        if (data == null || accessors == null || accessors.size() == 0) {
            return null;
        }
        ArrayEx domains = new ArrayEx();
        for (DataSlotEntry accessor : accessors) {
            List<Object> domain = ScaleManager.ordinalDomain(data, accessor, false);
            if (domain == null || domain.size() == 0) {
                return null;
            }
            domains.add(domain);
        }
        List domain = (List)domains.get(0);
        ES6Map originalDomainMap = ES6Map.create();
        for (Object e : domain) {
            originalDomainMap.set(e, (Object)new OrdinalCoordinateScaleDatum(e));
        }
        for (Object object : data) {
            Object key = accessors.get(0).getValue(object);
            OrdinalCoordinateScaleDatum datum = (OrdinalCoordinateScaleDatum)originalDomainMap.get(key);
            if (datum == null) continue;
            datum.push(object);
        }
        ArrayEx originalDomain = new ArrayEx();
        for (Object key : domain) {
            originalDomain.add(originalDomainMap.get(key));
        }
        ClusteredCoordinateScale clusteredCoordinateScale = ClusteredCoordinateScale.create((List<List<Object>>)domains, (List<? extends Object>)originalDomain);
        clusteredCoordinateScale.originalDomainLabelAccessor(new ValueFunction<Object, String>(){

            @SwiftMethodOverload(skipParameters={1})
            public String getValue(Object context, Object data, int index, int groupIndex) {
                Object key = ((OrdinalCoordinateScaleDatum)data).key();
                return ObjectConverter.toString((Object)key);
            }
        });
        return clusteredCoordinateScale;
    }

    public static CoordinateScaleImpl makeClusteredSkipMissingScale(List<? extends Object> data, DataSlotEntry xAccessor, DataSlotEntry colorAccessor) {
        if (data == null || xAccessor == null) {
            return null;
        }
        ES6Map domainMap = ES6Map.create();
        List<Object> domain = ScaleManager.ordinalDomain(data, xAccessor, false);
        for (int i = 0; i < domain.size(); ++i) {
            domainMap.set(domain.get(i), (Object)new ArrayEx());
        }
        for (Object object : data) {
            Object value;
            Object object2 = xAccessor.getValue(object);
            if (object2 == null || !domainMap.has(object2) || (value = colorAccessor.getValue(object)) == null) continue;
            ((List)domainMap.get(object2)).add(value);
        }
        ES6Map originalDomainMap = ES6Map.create();
        for (Object object : domain) {
            originalDomainMap.set(object, (Object)new OrdinalCoordinateScaleDatum(object));
        }
        for (Object object : data) {
            Object key = xAccessor.getValue(object);
            OrdinalCoordinateScaleDatum datum = (OrdinalCoordinateScaleDatum)originalDomainMap.get(key);
            if (datum == null) continue;
            datum.push(object);
        }
        ArrayEx arrayEx = new ArrayEx();
        for (Object key : domain) {
            arrayEx.add(originalDomainMap.get(key));
        }
        ClusteredSkipMissingCoordinateScale clusteredSkipMissingCoordinateScale = ClusteredSkipMissingCoordinateScale.create((ES6Map<Object, List<Object>>)domainMap, domain, (List<? extends Object>)arrayEx);
        clusteredSkipMissingCoordinateScale.originalDomainLabelAccessor(new ValueFunction<Object, String>(){

            @SwiftMethodOverload(skipParameters={1})
            public String getValue(Object context, Object data, int index, int groupIndex) {
                Object key = ((OrdinalCoordinateScaleDatum)data).key();
                return ObjectConverter.toString((Object)key);
            }
        });
        return clusteredSkipMissingCoordinateScale;
    }
}

