/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.internal;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.time.Date;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.time.DateTimeScale;
import com.ibm.vida.rave.core.time.IDate;
import com.ibm.vida.rave.library.framework.internal.CoordinateScaleImpl;
import java.util.ArrayList;
import java.util.List;

public class TimeCoordinateScale
extends CoordinateScaleImpl {
    private final DateTimeScale _scale;
    private double _width;

    public static CoordinateScaleImpl create(List<Object> domain) {
        return domain != null ? new TimeCoordinateScale(domain) : null;
    }

    private TimeCoordinateScale(List<Object> domain) {
        this._scale = Rave.time.scale.create();
        this._scale.domain(domain);
        this._width = 0.0;
    }

    @Override
    public AbstractScale<?, ?> scale() {
        return this._scale;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isTime() {
        return true;
    }

    @Override
    public CoordinateScaleImpl range(double v1, double v2, Double padding, Double outerPadding, boolean round) {
        if (round) {
            this._scale.rangeRound((List)new ArrayEx(new Object[]{v1, v2}));
        } else {
            this._scale.range((List)new ArrayEx(new Object[]{v1, v2}));
        }
        return this;
    }

    @Override
    public Number center(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0));
    }

    @Override
    public Number lower(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0)) - this._width;
    }

    @Override
    public Number upper(Object data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, data, 0, 0)) + this._width;
    }

    @Override
    public double width() {
        return 2.0 * this._width;
    }

    @Override
    public void setWidth(double width) {
        if (width >= 0.0) {
            this._width = width / 2.0;
        }
    }

    @Override
    public CoordinateScaleImpl expandFraction(double fraction, boolean keepZero) {
        if (fraction > 0.0) {
            ArrayEx d = this._scale.domain();
            long d0 = ((IDate)d.get(0)).getTime();
            long d1 = ((IDate)d.get(d.size() - 1)).getTime();
            long dd = Math.round(fraction * (double)(d1 - d0));
            d.set(0, (Object)new Date(d0 - dd));
            d.set(d.size() - 1, (Object)new Date(d1 + dd));
            this._scale.domain((List)d);
        }
        return this;
    }

    @Override
    public CoordinateScaleImpl expandPixels(double pixels, boolean keepZero) {
        double reduction;
        ArrayEx r;
        double dr;
        if (pixels > 0.0 && (dr = Math.abs(ObjectConverter.toDouble((Object)(r = this._scale.range()).get(0)) - ObjectConverter.toDouble((Object)r.get(r.size() - 1)))) > (reduction = 2.0 * pixels)) {
            return this.expandFraction(pixels / (dr - reduction), keepZero);
        }
        return this;
    }

    @Override
    public CoordinateScaleImpl expandZeroExtent(boolean keepZero) {
        long d1;
        ArrayEx d = this._scale.domain();
        List extent = Rave.extent((Object[])d.toArray());
        long d0 = ((IDate)extent.get(0)).getTime();
        if (d0 == (d1 = ((IDate)extent.get(1)).getTime())) {
            d.set(0, (Object)new Date(d0 - 1000L));
            d.set(d.size() - 1, (Object)new Date(d0 + 1000L));
            this._scale.domain((List)d);
        }
        return this;
    }

    @Override
    public CoordinateScaleImpl nice() {
        this._scale.nice();
        return this;
    }

    @Override
    public List<Object> rangeExtent() {
        ArrayEx range = this._scale.range();
        ArrayList<Object> rangeExtent = new ArrayList<Object>();
        rangeExtent.add(range.get(range.size() - 1));
        rangeExtent.add(range.get(0));
        return rangeExtent;
    }
}

