/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.internal;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.transition.Transition;
import java.util.List;

class TransitionsCompleteMonitor {
    private int monitoredTransitionsCount;
    private TransitionsCompleteCallback _callback;

    TransitionsCompleteMonitor(TransitionsCompleteCallback callback) {
        this._callback = callback;
        this.monitoredTransitionsCount = 0;
    }

    void monitor(List<Transition> transitions) {
        for (Transition t : transitions) {
            int size = t.size();
            if (size <= 0) continue;
            ++this.monitoredTransitionsCount;
            TransitionCompleteMonitor monitor = new TransitionCompleteMonitor(this, size);
            t.transitionEndedCallback((RunFunction)monitor);
        }
        if (this.monitoredTransitionsCount == 0) {
            this._callback.transitionsComplete(this);
        }
    }

    private void transitionComplete() {
        --this.monitoredTransitionsCount;
        if (this.monitoredTransitionsCount == 0) {
            this._callback.transitionsComplete(this);
        }
    }

    private static class TransitionCompleteMonitor
    implements RunFunction<Transition> {
        private int _count;
        private TransitionsCompleteMonitor monitorsCollection;

        TransitionCompleteMonitor(TransitionsCompleteMonitor collection, int count) {
            this._count = count;
            this.monitorsCollection = collection;
        }

        public Object run(Transition context, Object ... args) {
            --this._count;
            if (this._count == 0) {
                this.monitorsCollection.transitionComplete();
            }
            return null;
        }
    }

    @FunctionClass(value="transitionsComplete")
    static interface TransitionsCompleteCallback {
        public void transitionsComplete(TransitionsCompleteMonitor var1);
    }
}

