/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.meta.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.collections.OSet;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.datamodel.DataModelDescriptor;
import com.ibm.vida.rave.library.datamodel.DataSetDescriptor;
import com.ibm.vida.rave.library.datamodel.DataSlotDescriptor;
import com.ibm.vida.rave.library.framework.Bundle;
import com.ibm.vida.rave.library.framework.BundleInfo;
import com.ibm.vida.rave.library.framework.Controller;
import com.ibm.vida.rave.library.framework.meta.ActionMeta;
import com.ibm.vida.rave.library.framework.meta.BundleConfiguration;
import com.ibm.vida.rave.library.framework.meta.GenericMetadata;
import com.ibm.vida.rave.library.framework.meta.PresentationItems;
import com.ibm.vida.rave.library.framework.meta.PreviewsMetadata;
import com.ibm.vida.rave.library.framework.meta.PropertyMeta;
import com.ibm.vida.rave.library.framework.meta.PropertyPresentationMeta;
import com.ibm.vida.rave.library.framework.meta.internal.GenericMetadataImpl;
import com.ibm.vida.rave.library.framework.meta.internal.PreviewsMetadataImpl;
import com.ibm.vida.rave.library.framework.meta.internal.PropertyPresentationMetaImpl;
import com.ibm.vida.rave.library.i18n.MessagesRegistry;

public class BundleConfigurationImpl<S>
implements BundleConfiguration {
    private final String _id;
    private final String _label;
    private final String _description;
    private final JSONObject _json;
    @SwiftWeak
    private final Bundle _bundle;
    private final BundleInfo _bundleInfo;
    private Controller _configInstance;
    private GenericMetadata _meta;
    private PreviewsMetadata _previewsMeta;
    private ArrayEx<String> _propertyPresentations;
    private ArrayEx<String> _dataModels;
    private JSONArray _dataSlots;
    private ArrayEx<String> _enabledActions;
    private MessagesRegistry _messages;

    BundleConfigurationImpl(Bundle bundle, BundleInfo bundleInfo, JSONObject json, MessagesRegistry messages) {
        this._json = json;
        this._bundle = bundle;
        this._bundleInfo = bundleInfo;
        this._messages = messages;
        JSONObject meta = (JSONObject)json.get((Object)"genericMeta");
        this._id = ObjectConverter.asString((Object)meta.get((Object)"id"));
        this._label = ObjectConverter.asString((Object)meta.get((Object)"label"));
        this._description = ObjectConverter.asString((Object)meta.get((Object)"description"));
        this._configInstance = null;
        this._meta = null;
        this._previewsMeta = null;
        this._propertyPresentations = null;
        this._dataModels = null;
        this._enabledActions = null;
    }

    @Override
    public final String id() {
        return this._id;
    }

    @Override
    @Deprecated
    public final String name() {
        return this.label();
    }

    @Override
    public final String label() {
        return this._bundle == null ? this._label : this.info().meta().id("label");
    }

    @Override
    public final String description() {
        return this._bundle == null ? this._description : this.info().meta().id("description");
    }

    public final JSONObject json() {
        return this._json;
    }

    @Override
    public final JSONObject toJSON() {
        JSONObject o;
        GenericMetadata meta = this.meta();
        BundleInfo info = this.info();
        JSONObject json = new JSONObject();
        json.put((Object)"bundleId", (Object)this._bundle.info().meta().id("id"));
        String[] ids = meta.ids();
        for (int i = 0; i < ids.length; ++i) {
            json.put((Object)ids[i], (Object)meta.id(ids[i]));
        }
        json.put((Object)"tags", (Object)this.convertStringArrayEx(meta.tags()));
        PreviewsMetadata preview = info.previews();
        ES6Map imageMap = ES6Map.create();
        ES6Map svgMap = ES6Map.create();
        ArrayEx a = new ArrayEx();
        for (String s : preview.getAllTags()) {
            a.clear();
            a.add((Object)s);
            String path = preview.getPreview("image", (ArrayEx<String>)a);
            if (!imageMap.has((Object)path)) {
                imageMap.set((Object)path, (Object)new JSONArray());
            }
            ((JSONArray)imageMap.get((Object)path)).add((Object)s);
            path = preview.getPreview("svg", (ArrayEx<String>)a);
            if (!svgMap.has((Object)path)) {
                svgMap.set((Object)path, (Object)new JSONArray());
            }
            ((JSONArray)svgMap.get((Object)path)).add((Object)s);
        }
        JSONObject jPreviews = new JSONObject();
        json.put((Object)"previews", (Object)jPreviews);
        JSONArray images = new JSONArray();
        JSONArray svg = new JSONArray();
        jPreviews.put((Object)"images", (Object)images);
        jPreviews.put((Object)"svg", (Object)svg);
        for (Object entry : imageMap.entries()) {
            o = new JSONObject();
            images.add((Object)o);
            o.put((Object)"file", entry.getKey());
            o.put((Object)"tags", entry.getValue());
        }
        for (Object entry : svgMap.entries()) {
            o = new JSONObject();
            svg.add((Object)o);
            o.put((Object)"file", entry.getKey());
            o.put((Object)"tags", entry.getValue());
        }
        JSONArray jDataModels = new JSONArray();
        json.put((Object)"dataModels", (Object)jDataModels);
        for (DataModelDescriptor dm : info.dataModels()) {
            JSONObject jDm = new JSONObject();
            jDataModels.add((Object)jDm);
            jDm.put((Object)"id", (Object)dm.id());
            jDm.put((Object)"label", (Object)dm.label());
            jDm.put((Object)"description", (Object)dm.description());
            jDm.put((Object)"tags", (Object)this.convertStringArrayEx(dm.tags()));
            JSONArray jDss = new JSONArray();
            jDm.put((Object)"dataSets", (Object)jDss);
            for (DataSetDescriptor ds : dm.dataSets()) {
                JSONObject jDs = new JSONObject();
                jDss.add((Object)jDs);
                jDs.put((Object)"id", (Object)ds.id());
                jDs.put((Object)"label", (Object)ds.label());
                jDs.put((Object)"description", (Object)ds.description());
                jDs.put((Object)"cardinality", (Object)ds.cardinality());
                jDs.put((Object)"type", (Object)ds.type());
                jDs.put((Object)"tags", (Object)this.convertStringArrayEx(ds.tags()));
                JSONArray jDataSlots = new JSONArray();
                jDs.put((Object)"dataSlots", (Object)jDataSlots);
                ArrayEx<DataSlotDescriptor> slots = ds.dataSlots();
                for (DataSlotDescriptor dsD : slots) {
                    JSONObject jSlot = new JSONObject();
                    jDataSlots.add((Object)jSlot);
                    jSlot.put((Object)"id", (Object)dsD.id());
                    jSlot.put((Object)"label", (Object)dsD.label());
                    jSlot.put((Object)"description", (Object)dsD.description());
                    jSlot.put((Object)"cardinality", (Object)dsD.cardinality());
                    JSONObject o2 = new JSONObject();
                    jSlot.put((Object)"icon", (Object)o2);
                    o2.put((Object)"image", (Object)dsD.icon("image"));
                    o2.put((Object)"svg", (Object)dsD.icon("svg"));
                    jSlot.put((Object)"dataTypes", (Object)this.convertStringArrayEx(dsD.dataTypes()));
                    jSlot.put((Object)"tags", (Object)this.convertStringArrayEx(dsD.tags()));
                }
            }
        }
        ArrayEx<PropertyMeta> ap = info.properties();
        ES6Map properties = ES6Map.create();
        for (PropertyMeta p : ap) {
            properties.set((Object)p.id(), (Object)p);
        }
        JSONArray jPps = new JSONArray();
        json.put((Object)"propertyPresentations", (Object)jPps);
        for (PropertyPresentationMeta pp : info.propertyPresentations()) {
            JSONObject o3 = new JSONObject();
            jPps.add((Object)o3);
            o3.put((Object)"id", (Object)pp.id());
            o3.put((Object)"name", (Object)pp.name());
            o3.put((Object)"description", (Object)pp.description());
            o3.put((Object)"tags", (Object)this.convertStringArray(pp.tags()));
            this.toJsonPresentationItems((ES6Map<String, PropertyMeta>)properties, o3, pp.presentationItems());
        }
        return json;
    }

    private final void toJsonPresentationItems(ES6Map<String, PropertyMeta> properties, JSONObject parent, PresentationItems[] items) {
        if (items.length > 0) {
            JSONArray array = new JSONArray();
            parent.put((Object)"presentationItems", (Object)array);
            for (int i = 0; i < items.length; ++i) {
                JSONObject object = new JSONObject();
                array.add((Object)object);
                if (items[i].type().compareTo("reference") == 0) {
                    PropertyMeta p = (PropertyMeta)properties.get((Object)items[i].id());
                    if (p == null) continue;
                    JSONObject property = new JSONObject();
                    object.put((Object)"property", (Object)property);
                    property.put((Object)"id", (Object)items[i].id());
                    property.put((Object)"name", (Object)p.name());
                    property.put((Object)"description", (Object)p.description());
                    property.put((Object)"type", (Object)p.type());
                    property.put((Object)"defaultValue", p.defaultValue());
                    property.put((Object)"required", (Object)p.required());
                    property.put((Object)"resetView", (Object)p.resetView());
                    property.put((Object)"tags", (Object)this.convertStringArrayEx(p.tags()));
                    continue;
                }
                if (items[i].type().compareTo("group") != 0) continue;
                JSONObject group = new JSONObject();
                object.put((Object)"propertyGroup", (Object)group);
                group.put((Object)"id", (Object)items[i].id());
                group.put((Object)"name", (Object)items[i].name());
                group.put((Object)"description", (Object)items[i].description());
                group.put((Object)"tags", (Object)this.convertStringArray(items[i].tags()));
                this.toJsonPresentationItems(properties, group, items[i].presentationItems());
            }
        }
    }

    @Override
    public final GenericMetadata meta() {
        if (this._bundle == null) {
            if (this._meta == null) {
                this._meta = ((GenericMetadataImpl)this._bundleInfo.meta()).copy();
                ((GenericMetadataImpl)this._meta).populate(this._json);
                ((GenericMetadataImpl)this._meta).setMessages(((GenericMetadataImpl)this._bundleInfo.meta()).getMessages());
            }
            return this._meta;
        }
        return this.info().meta();
    }

    public final PreviewsMetadata previews() {
        if (this._previewsMeta == null) {
            this._previewsMeta = ((PreviewsMetadataImpl)this._bundleInfo.previews()).copy();
            this._previewsMeta.configure(this._json);
        }
        return this._previewsMeta;
    }

    @Override
    public final ArrayEx<String> propertyPresentations() {
        if (this._propertyPresentations == null) {
            this._propertyPresentations = new ArrayEx();
            OSet<String> hidden = BundleConfigurationImpl.makeIdSet((JSONArray)this._json.get((Object)"propertyPresentations"), "hidden", true);
            for (PropertyPresentationMeta pp : this._bundleInfo.propertyPresentations()) {
                if (hidden.contains((Object)((PropertyPresentationMetaImpl)pp).id())) continue;
                this._propertyPresentations.add((Object)((PropertyPresentationMetaImpl)pp).id());
            }
        }
        return this._propertyPresentations;
    }

    @Override
    public final ArrayEx<String> dataModels() {
        if (this._dataModels == null) {
            this._dataModels = new ArrayEx();
            OSet<String> hidden = BundleConfigurationImpl.makeIdSet((JSONArray)this._json.get((Object)"datamodels"), "hidden", true);
            for (DataModelDescriptor dmd : this._bundleInfo.dataModels()) {
                if (hidden.contains((Object)dmd.id())) continue;
                this._dataModels.add((Object)dmd.id());
            }
        }
        return this._dataModels;
    }

    @Override
    public final JSONArray dataSlots() {
        if (this._dataSlots == null) {
            this._dataSlots = (JSONArray)this._json.get((Object)"dataSlots");
        }
        return this._dataSlots;
    }

    @Override
    public final ArrayEx<String> enabledActions() {
        if (this._enabledActions == null) {
            this._enabledActions = new ArrayEx();
            OSet<String> disabled = BundleConfigurationImpl.makeIdSet((JSONArray)this._json.get((Object)"actions"), "enabled", false);
            for (ActionMeta a : this._bundleInfo.actions()) {
                if (disabled.contains((Object)a.id())) continue;
                this._enabledActions.add((Object)a.id());
            }
        }
        return this._enabledActions;
    }

    private static OSet<String> makeIdSet(JSONArray array, String key, boolean value) {
        OSet result = new OSet();
        if (array != null) {
            for (Object o : array) {
                Boolean v;
                if (o == null) continue;
                String id = ObjectConverter.asString((Object)((JSONObject)o).get((Object)"id"));
                Boolean bl = v = ((JSONObject)o).get((Object)key) != null ? Boolean.valueOf(ObjectConverter.toBoolean((Object)((JSONObject)o).get((Object)key))) : null;
                if (id == null || v == null || v != value) continue;
                result.add((Object)id);
            }
        }
        return result;
    }

    @Override
    public BundleInfo info() {
        if (this._bundle == null) {
            return null;
        }
        if (this._configInstance == null) {
            this._configInstance = this._bundle.create(this._id, false);
        }
        return this._configInstance.info();
    }

    private JSONArray convertStringArrayEx(ArrayEx<String> a) {
        JSONArray r = new JSONArray();
        for (String s : a) {
            r.add((Object)s);
        }
        return r;
    }

    private JSONArray convertStringArray(String[] a) {
        JSONArray r = new JSONArray();
        for (String s : a) {
            r.add((Object)s);
        }
        return r;
    }
}

