/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.meta.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.Library;
import com.ibm.vida.rave.library.framework.meta.PreviewsMetadata;
import com.ibm.vida.rave.library.framework.meta.internal.PreviewMeta;

public class PreviewsMetadataImpl
implements PreviewsMetadata {
    private final ArrayEx<PreviewMeta> svgPreview = new ArrayEx();
    private final ArrayEx<PreviewMeta> imgPreview = new ArrayEx();
    private final ArrayEx<String> allTags = new ArrayEx();

    public final void populate(JSONObject o) {
        this.svgPreview.clear();
        this.imgPreview.clear();
        JSONObject previews = (JSONObject)o.get((Object)"previews");
        if (previews != null) {
            for (Object k : previews.keySet()) {
                String key = ObjectConverter.asString(k);
                if (key.equals("svg")) {
                    JSONArray svgArray = (JSONArray)previews.get((Object)key);
                    for (Object svg : svgArray) {
                        this.processPreview(svg, "svg");
                    }
                    continue;
                }
                JSONArray imgArray = (JSONArray)previews.get((Object)key);
                for (Object img : imgArray) {
                    this.processPreview(img, "image");
                }
            }
        }
    }

    private void processPreview(Object object, String format) {
        JSONObject jsonObj = (JSONObject)object;
        String file = ObjectConverter.toString((Object)jsonObj.get((Object)"file"));
        JSONArray tagsArray = (JSONArray)jsonObj.get((Object)"tags");
        ArrayEx tags = new ArrayEx();
        for (Object t : tagsArray) {
            String tag = ObjectConverter.toString(t);
            tags.add((Object)tag);
            if (this.allTags.contains((Object)tag)) continue;
            this.allTags.add((Object)tag);
        }
        if (format.equals("svg")) {
            this.svgPreview.add((Object)new PreviewMeta(file, (ArrayEx<String>)tags, format));
        } else {
            this.imgPreview.add((Object)new PreviewMeta(file, (ArrayEx<String>)tags, format));
        }
    }

    @Override
    public final void configure(JSONObject o) {
        this.populate(o);
    }

    @Override
    public ArrayEx<String> getAllTags() {
        return this.allTags;
    }

    @Override
    public ArrayEx<String> getPreviews(String format) {
        ArrayEx<PreviewMeta> previews = format.equals("svg") ? this.svgPreview : this.imgPreview;
        ArrayEx result = new ArrayEx();
        for (PreviewMeta view : previews) {
            result.add((Object)view.file());
        }
        return result;
    }

    @Override
    public String getPreview(String format, ArrayEx<String> tags) {
        ArrayEx<PreviewMeta> previews = null;
        if (format == null || format.equals("svg")) {
            previews = this.svgPreview;
        } else if (format.equals("image")) {
            previews = this.imgPreview;
        }
        if (previews == null) {
            Library.logError(302);
            return null;
        }
        if (tags == null) {
            return previews.size() > 0 ? ((PreviewMeta)previews.get(0)).file() : null;
        }
        int maxCount = -1;
        PreviewMeta result = null;
        for (PreviewMeta meta : previews) {
            ArrayEx<String> metaTags = meta.tags();
            int count = this.MatchTags(metaTags, tags);
            if (count <= maxCount) continue;
            maxCount = count;
            result = meta;
        }
        return result == null ? null : result.file();
    }

    public ArrayEx<PreviewMeta> getSvgPreviewMeta() {
        ArrayEx result = new ArrayEx();
        for (PreviewMeta view : this.svgPreview) {
            result.add((Object)view);
        }
        return result;
    }

    private int MatchTags(ArrayEx<String> available, ArrayEx<String> expected) {
        int result = 0;
        for (String tag : expected) {
            if (!available.contains((Object)tag)) continue;
            ++result;
        }
        return result;
    }

    public PreviewsMetadataImpl copy() {
        PreviewMeta m;
        PreviewsMetadataImpl result = new PreviewsMetadataImpl();
        for (String t : this.allTags) {
            result.allTags.add((Object)t);
        }
        for (PreviewMeta meta : this.svgPreview) {
            m = meta.copy();
            result.svgPreview.add((Object)m);
        }
        for (PreviewMeta meta : this.imgPreview) {
            m = meta.copy();
            result.imgPreview.add((Object)m);
        }
        return result;
    }
}

