/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.meta.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.framework.meta.PresentationItems;
import com.ibm.vida.rave.library.framework.meta.internal.PropertyReferenceMeta;
import com.ibm.vida.rave.library.i18n.MessagesRegistry;
import com.ibm.vida.rave.library.property.PropertyImpl;
import com.ibm.vida.rave.library.property.PropertySet;

public class PropertyGroupMeta
implements PresentationItems {
    private String groupID;
    private String groupName;
    private String groupDescription;
    private String[] groupTags;
    private String groupIcon;
    private MessagesRegistry messagesRegistry;
    private ArrayEx<PresentationItems> groupPresentationItems;

    public PropertyGroupMeta(MessagesRegistry registry) {
        this.messagesRegistry = registry;
    }

    @Override
    public String id() {
        return this.groupID;
    }

    @Override
    public String type() {
        return "group";
    }

    @Override
    public String name() {
        return this.messagesRegistry._nls(this.groupName, this.groupName);
    }

    @Override
    public String description() {
        return this.messagesRegistry._nls(this.groupDescription, this.groupDescription);
    }

    @Override
    public String[] tags() {
        return this.groupTags;
    }

    @Override
    public String icon() {
        return this.groupIcon;
    }

    @Override
    public PresentationItems[] presentationItems() {
        PresentationItems[] presentationItems = new PresentationItems[this.groupPresentationItems.size()];
        int i = 0;
        for (PresentationItems item : this.groupPresentationItems) {
            presentationItems[i++] = item;
        }
        return presentationItems;
    }

    public void setID(String id) {
        this.groupID = id;
    }

    public void setGroupName(String group) {
        this.groupName = group;
    }

    public void setGroupDescription(String description) {
        this.groupDescription = description;
    }

    public void setGroupTags(String[] tags) {
        this.groupTags = tags;
    }

    public void setGroupIcon(String icon) {
        this.groupIcon = icon;
    }

    public void parse(JSONArray pItems) {
        if (pItems != null) {
            int len = pItems.size();
            this.groupPresentationItems = new ArrayEx();
            for (int i = 0; i < len; ++i) {
                JSONObject item = (JSONObject)pItems.get(i);
                String propertyRef = ObjectConverter.asString((Object)item.get((Object)"propertyID"));
                if (propertyRef != null) {
                    PropertyReferenceMeta property = new PropertyReferenceMeta();
                    property.setID(propertyRef);
                    this.groupPresentationItems.add((Object)property);
                    continue;
                }
                PropertyGroupMeta propertyGroup = new PropertyGroupMeta(this.messagesRegistry);
                JSONObject propertyGroupMeta = (JSONObject)item.get((Object)"propertyGroup");
                propertyGroup.setID(ObjectConverter.asString((Object)propertyGroupMeta.get((Object)"id")));
                propertyGroup.setGroupName(ObjectConverter.asString((Object)propertyGroupMeta.get((Object)"label")));
                propertyGroup.setGroupDescription(ObjectConverter.asString((Object)propertyGroupMeta.get((Object)"description")));
                propertyGroup.setGroupIcon(ObjectConverter.asString((Object)propertyGroupMeta.get((Object)"icon")));
                JSONArray gTags = (JSONArray)propertyGroupMeta.get((Object)"tags");
                if (gTags != null) {
                    int glen = gTags.size();
                    String[] groupTagsArray = new String[glen];
                    for (int j = 0; j < len; ++j) {
                        groupTagsArray[i] = ObjectConverter.asString((Object)gTags.get(i));
                    }
                    propertyGroup.setGroupTags(groupTagsArray);
                } else {
                    propertyGroup.setGroupTags(null);
                }
                JSONArray groupPItems = (JSONArray)propertyGroupMeta.get((Object)"presentationItems");
                propertyGroup.parse(groupPItems);
                this.groupPresentationItems.add((Object)propertyGroup);
            }
        } else {
            this.groupPresentationItems = null;
        }
    }

    protected PropertyGroupMeta copy() {
        PropertyGroupMeta pgm = new PropertyGroupMeta(this.messagesRegistry);
        pgm.groupDescription = this.groupDescription;
        pgm.groupIcon = this.groupIcon;
        pgm.groupID = this.groupID;
        pgm.groupName = this.groupName;
        int i = 0;
        pgm.groupTags = new String[this.groupTags.length];
        for (String tag : this.groupTags) {
            pgm.groupTags[i++] = tag;
        }
        pgm.groupPresentationItems = new ArrayEx();
        for (PresentationItems item : this.groupPresentationItems) {
            if (item.type().equals("reference")) {
                pgm.groupPresentationItems.add((Object)item);
                continue;
            }
            pgm.groupPresentationItems.add((Object)((PropertyGroupMeta)item).copy());
        }
        return pgm;
    }

    public void validateProperties(PropertySet properties) {
        ArrayEx itemsToRemove = null;
        for (PresentationItems item : this.groupPresentationItems) {
            if (item.type().equals("reference")) {
                PropertyImpl p = (PropertyImpl)properties.property(item.id());
                if (!p.hidden()) continue;
                if (itemsToRemove == null) {
                    itemsToRemove = new ArrayEx();
                }
                itemsToRemove.add((Object)item);
                continue;
            }
            ((PropertyGroupMeta)item).validateProperties(properties);
        }
        if (itemsToRemove != null) {
            for (PresentationItems item : itemsToRemove) {
                int index = this.groupPresentationItems.indexOf((Object)item);
                this.groupPresentationItems.remove(index);
            }
        }
    }
}

