/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.framework.meta.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.framework.meta.PresentationItems;
import com.ibm.vida.rave.library.framework.meta.PropertyPresentationMeta;
import com.ibm.vida.rave.library.framework.meta.internal.PropertyGroupMeta;
import com.ibm.vida.rave.library.framework.meta.internal.PropertyReferenceMeta;
import com.ibm.vida.rave.library.i18n.MessagesRegistry;
import com.ibm.vida.rave.library.property.PropertyImpl;
import com.ibm.vida.rave.library.property.PropertySet;

public class PropertyPresentationMetaImpl
implements PropertyPresentationMeta {
    private String _id;
    private String _name;
    private String _description;
    private String[] _tags;
    private String _icon;
    private MessagesRegistry messagesRegistry;
    private ArrayEx<PresentationItems> _presentationItems;

    public PropertyPresentationMetaImpl(MessagesRegistry registry) {
        this.messagesRegistry = registry;
    }

    @Override
    public String id() {
        return this._id;
    }

    @Override
    public String name() {
        return this.messagesRegistry._nls(this._name, this._name);
    }

    @Override
    public String description() {
        return this.messagesRegistry._nls(this._description, this._description);
    }

    @Override
    public String[] tags() {
        return this._tags;
    }

    @Override
    public String icon() {
        return this._icon;
    }

    @Override
    public PresentationItems[] presentationItems() {
        PresentationItems[] presentationItems = new PresentationItems[this._presentationItems.size()];
        int i = 0;
        for (PresentationItems item : this._presentationItems) {
            presentationItems[i++] = item;
        }
        return presentationItems;
    }

    public PropertyPresentationMetaImpl parse(JSONObject json) {
        PropertyPresentationMetaImpl pp = new PropertyPresentationMetaImpl(this.messagesRegistry);
        pp._id = ObjectConverter.toString((Object)json.get((Object)"id"));
        pp._name = ObjectConverter.toString((Object)json.get((Object)"label"));
        pp._description = ObjectConverter.toString((Object)json.get((Object)"description"));
        JSONArray pTags = (JSONArray)json.get((Object)"tags");
        if (pTags != null) {
            int len = pTags.size();
            pp._tags = new String[len];
            for (int i = 0; i < len; ++i) {
                pp._tags[i] = ObjectConverter.asString((Object)pTags.get(i));
            }
        } else {
            pp._tags = null;
        }
        pp._icon = ObjectConverter.asString((Object)json.get((Object)"icon"));
        JSONArray pItems = (JSONArray)json.get((Object)"presentationItems");
        if (pItems != null) {
            int len = pItems.size();
            pp._presentationItems = new ArrayEx();
            for (int i = 0; i < len; ++i) {
                JSONObject item = (JSONObject)pItems.get(i);
                String propertyRef = ObjectConverter.asString((Object)item.get((Object)"propertyID"));
                if (propertyRef != null) {
                    PropertyReferenceMeta property = new PropertyReferenceMeta();
                    property.setID(propertyRef);
                    pp._presentationItems.add((Object)property);
                    continue;
                }
                PropertyGroupMeta propertyGroup = new PropertyGroupMeta(this.messagesRegistry);
                JSONObject propertyGroupMeta = (JSONObject)item.get((Object)"propertyGroup");
                propertyGroup.setID(ObjectConverter.asString((Object)propertyGroupMeta.get((Object)"id")));
                propertyGroup.setGroupName(ObjectConverter.asString((Object)propertyGroupMeta.get((Object)"label")));
                propertyGroup.setGroupDescription(ObjectConverter.asString((Object)propertyGroupMeta.get((Object)"description")));
                propertyGroup.setGroupIcon(ObjectConverter.asString((Object)propertyGroupMeta.get((Object)"icon")));
                JSONArray groupTags = (JSONArray)propertyGroupMeta.get((Object)"tags");
                if (groupTags != null) {
                    int glen = groupTags.size();
                    String[] groupTagsArray = new String[glen];
                    for (int j = 0; j < glen; ++j) {
                        groupTagsArray[j] = ObjectConverter.asString((Object)groupTags.get(j));
                    }
                    propertyGroup.setGroupTags(groupTagsArray);
                } else {
                    propertyGroup.setGroupTags(null);
                }
                JSONArray groupPItems = (JSONArray)propertyGroupMeta.get((Object)"presentationItems");
                propertyGroup.parse(groupPItems);
                pp._presentationItems.add((Object)propertyGroup);
            }
        } else {
            pp._presentationItems = null;
        }
        return pp;
    }

    public PropertyPresentationMetaImpl copy() {
        PropertyPresentationMetaImpl pp = new PropertyPresentationMetaImpl(MessagesRegistry.EmptyRegistry());
        pp._id = this._id;
        pp._name = this._name;
        pp._description = this._description;
        pp._tags = new String[this._tags.length];
        pp._presentationItems = new ArrayEx();
        pp._icon = this._icon;
        int i = 0;
        for (String tag : this._tags) {
            pp._tags[i++] = tag;
        }
        for (PresentationItems item : this._presentationItems) {
            if (item.type().equals("reference")) {
                pp._presentationItems.add((Object)item);
                continue;
            }
            pp._presentationItems.add((Object)((PropertyGroupMeta)item).copy());
        }
        return pp;
    }

    public void validateProperties(PropertySet properties) {
        ArrayEx itemsToRemove = null;
        for (PresentationItems item : this._presentationItems) {
            if (item.type().equals("reference")) {
                PropertyImpl p = (PropertyImpl)properties.property(item.id());
                if (!p.hidden()) continue;
                if (itemsToRemove == null) {
                    itemsToRemove = new ArrayEx();
                }
                itemsToRemove.add((Object)item);
                continue;
            }
            ((PropertyGroupMeta)item).validateProperties(properties);
        }
        if (itemsToRemove != null) {
            for (PresentationItems item : itemsToRemove) {
                int index = this._presentationItems.indexOf((Object)item);
                this._presentationItems.remove(index);
            }
        }
    }
}

