/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public class BundleBower {
    private JSONObject dependencies;
    private String version;
    private String build;
    @InlineStringConstant
    private static final String DEPENDENCIES = "dependencies";
    @InlineStringConstant
    private static final String VERSION = "version";
    @InlineStringConstant
    private static final String BUILD = "build";
    @InlineStringConstant
    private static final String PATH_SEPARATOR = "/";
    @InlineStringConstant
    private static final String JS_EXT = ".js";
    @InlineStringConstant
    private static final String JS_EXT_MIN = ".min.js";
    private final ArrayEx<String> dependencyExceptions = new ArrayEx();

    public BundleBower() {
        this.dependencyExceptions.add((Object)"rave");
        this.dependencyExceptions.add((Object)"rave-library");
    }

    final void define(JSONObject bower) {
        if (bower == null) {
            return;
        }
        this.dependencies = (JSONObject)bower.get((Object)DEPENDENCIES);
        this.version = ObjectConverter.toString((Object)bower.get((Object)VERSION));
        this.build = ObjectConverter.toString((Object)bower.get((Object)BUILD));
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    final OMap<String, String> getDependenciesPaths(boolean minified, String libLocation, OMap<String, String> loadedPrereqs) {
        OMap paths = new OMap();
        if (this.dependencies != null) {
            Object[] entries = this.dependencies.keySet().toArray();
            for (int i = 0; i < entries.length; ++i) {
                String name = ObjectConverter.toString((Object)entries[i]);
                if (!this.canAddDependency(name, loadedPrereqs)) continue;
                String uri = libLocation.concat(PATH_SEPARATOR + name);
                paths.put((Object)name, (Object)uri.concat(minified ? JS_EXT_MIN : JS_EXT));
            }
        }
        return paths;
    }

    private boolean canAddDependency(String name, OMap<String, String> loadedPrereqs) {
        return !loadedPrereqs.containsKey((Object)name) && !this.dependencyExceptions.contains((Object)name);
    }
}

