/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.palette;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.library.datamodel.DataSet;
import com.ibm.vida.rave.library.datamodel.DataSlot;
import com.ibm.vida.rave.library.datamodel.DataSlotEntry;
import com.ibm.vida.rave.library.framework.internal.OrdinalCoordinateScaleDatum;
import com.ibm.vida.rave.library.framework.internal.ScaleManager;
import java.util.List;

public abstract class Palette
implements ValueFunction<SceneNode, Object> {
    @InlineStringConstant
    private static final String DATATYPE_NUMERIC = "numeric";
    @InlineStringConstant
    private static final String DATATYPE_STRING = "string";
    private final String _id;
    private final String _label;
    private final String _description;
    private final String _icon;
    protected String nullColor;
    protected SingleValueFunction<Object, Object> dataAccessor;
    protected String type;
    private int _domainValidity;
    private List<Object> _originalDomain;
    private ValueFunction<Object, String> _originalDomainLabelAccessor;
    protected static int VALID_DOMAIN = 0;
    protected static int INVALID_DOMAIN_DATATYPE = 1;
    protected static int INVALID_DOMAIN_EMPTY = 2;
    protected static int INVALID_DOMAIN_NULL = 3;

    public Palette(JSONObject jsonPalette) {
        this._id = ObjectConverter.asString((Object)jsonPalette.get((Object)"id"));
        this._label = ObjectConverter.asString((Object)jsonPalette.get((Object)"label"));
        this._description = ObjectConverter.asString((Object)jsonPalette.get((Object)"description"));
        this._icon = ObjectConverter.asString((Object)jsonPalette.get((Object)"icon"));
        this.nullColor = null;
        this._domainValidity = VALID_DOMAIN;
        this.dataAccessor = new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                return data;
            }
        };
    }

    public final String getId() {
        return this._id;
    }

    public final String getLabel() {
        return this._label;
    }

    public final String getDescription() {
        return this._description;
    }

    public final String getIcon() {
        return this._icon;
    }

    public final String getType() {
        return this.type;
    }

    public int getDomainValidity() {
        return this._domainValidity;
    }

    public final void setAccessor(SingleValueFunction<Object, Object> singleValueFunction) {
        this.dataAccessor = singleValueFunction;
    }

    public void setData(List<Object> domain, DataSet dataSet, String slot) {
        DataSlot dataSlot = dataSet.slot(slot);
        this.setDomain(domain, dataSlot != null ? dataSlot.entry() : null, null, null);
    }

    public void setData(DataSet dataSet, String slot) {
        DataSlot dataSlot = dataSet.slot(slot);
        DataSlotEntry colorAccessor = dataSlot != null ? dataSlot.entry() : null;
        List data = (List)dataSet.data();
        ArrayEx originalDomain = null;
        ValueFunction<Object, String> originalDomainLabelAccessor = null;
        List<Object> domain = null;
        if (colorAccessor != null && (domain = DATATYPE_NUMERIC.equals(colorAccessor.type()) ? ScaleManager.ordinalDomain(data, colorAccessor, true) : ScaleManager.ordinalDomain(data, colorAccessor, false)) != null) {
            ES6Map originalDomainMap = ES6Map.create();
            for (Object key : domain) {
                originalDomainMap.set(key, (Object)new OrdinalCoordinateScaleDatum(key));
            }
            for (Object o : data) {
                Object key = colorAccessor.getValue(o);
                OrdinalCoordinateScaleDatum datum = (OrdinalCoordinateScaleDatum)originalDomainMap.get(key);
                if (datum == null) continue;
                datum.push(o);
            }
            originalDomain = new ArrayEx();
            for (Object d : domain) {
                originalDomain.add(originalDomainMap.get(d));
            }
            originalDomainLabelAccessor = new ValueFunction<Object, String>(){

                @SwiftMethodOverload(skipParameters={1})
                public String getValue(Object context, Object data, int index, int groupIndex) {
                    Object key = ((OrdinalCoordinateScaleDatum)data).key();
                    return ObjectConverter.toString((Object)key);
                }
            };
        }
        this.setDomain(domain, colorAccessor, (List<? extends Object>)originalDomain, originalDomainLabelAccessor);
    }

    private void setDomain(List<Object> domain, DataSlotEntry colorAccessor, List<? extends Object> originalDomain, ValueFunction<Object, String> originalDomainLabelAccessor) {
        if (domain == null) {
            this._domainValidity = INVALID_DOMAIN_NULL;
            this.invalidateDomain();
        } else if (domain.size() <= 0) {
            this._domainValidity = INVALID_DOMAIN_EMPTY;
            this.invalidateDomain();
        } else if (!this.canHandleDataType(colorAccessor != null ? colorAccessor.type() : null)) {
            this._domainValidity = INVALID_DOMAIN_DATATYPE;
            this.invalidateDomain();
        } else {
            this._domainValidity = VALID_DOMAIN;
            this.domain(domain);
            this._originalDomain = originalDomain;
            this._originalDomainLabelAccessor = originalDomainLabelAccessor;
        }
    }

    public final void setNullColor(String color) {
        this.nullColor = color;
    }

    @SwiftMethodOverload(overloads={"String"})
    public abstract void addColor(Object var1);

    public abstract void addAllColors(JSONArray var1);

    @SwiftMethodOverload(overloads={"String"})
    public abstract void removeColor(Object var1);

    protected abstract void domain(List<Object> var1);

    protected abstract void invalidateDomain();

    public abstract AbstractScale<Object, Object> getScale();

    protected abstract boolean canHandleDataType(String var1);

    public abstract Object getValue(SceneNode var1, Object var2, int var3, int var4);

    public List<Object> originalDomain() {
        return this._originalDomain;
    }

    public void originalDomainLabelAccessor(ValueFunction<Object, String> format) {
        this._originalDomainLabelAccessor = format;
    }

    public ValueFunction<Object, String> originalDomainLabelAccessor() {
        return this._originalDomainLabelAccessor;
    }
}

