/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.palette.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.OrdinalScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.library.palette.Palette;
import java.util.List;

public class ConditionalPalette
extends Palette {
    private static final String INVALID_DOMAIN = "";
    private final OrdinalScale colors;
    private final OMap<Object, String> paletteMap;
    public static final String Type = "conditional";

    public ConditionalPalette(JSONObject jsonPalette) {
        super(jsonPalette);
        this.type = Type;
        this.paletteMap = new OMap();
        this.colors = Rave.scale.ordinal();
        this.addAllColors((JSONArray)jsonPalette.get((Object)"fills"));
    }

    @Override
    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
        Object dataValue = this.getDomainValidity() == VALID_DOMAIN ? this.dataAccessor.getValue(data) : (this.getDomainValidity() == INVALID_DOMAIN_NULL ? INVALID_DOMAIN : null);
        return dataValue != null ? this.paletteMap.get(dataValue) : this.nullColor;
    }

    @Override
    public void addAllColors(JSONArray fills) {
        ArrayEx domain = new ArrayEx();
        ArrayEx range = new ArrayEx();
        for (Object fill : fills) {
            String color = ObjectConverter.toString((Object)((JSONObject)fill).get((Object)"fill"));
            JSONArray values = (JSONArray)((JSONObject)fill).get((Object)"values");
            for (Object value : values) {
                if (this.paletteMap.containsKey((Object)ObjectConverter.toString(value))) continue;
                String strVal = ObjectConverter.toString(value);
                this.paletteMap.put((Object)strVal, (Object)color);
                domain.add(strVal);
                range.add(color);
            }
        }
        this.colors.domain((List)domain);
        this.colors.range((List)range);
    }

    private void setupColorScale(List<Object> domain, List<Object> range) {
        this.colors.domain(domain).range(range);
    }

    @Override
    public void addColor(Object color) {
        List domain = this.colors.domain();
        List range = this.colors.range();
        this.addColorImpl((JSONObject)color, domain, range);
        this.setupColorScale(domain, range);
    }

    private void addColorImpl(JSONObject jsonColor, List<Object> domain, List<Object> range) {
        String color = ObjectConverter.toString((Object)jsonColor.get((Object)"fill"));
        JSONArray values = (JSONArray)jsonColor.get((Object)"values");
        for (Object value : values) {
            if (this.paletteMap.containsKey((Object)ObjectConverter.toString(value))) continue;
            String strVal = ObjectConverter.toString(value);
            this.paletteMap.put((Object)strVal, (Object)color);
            domain.add(strVal);
            range.add(color);
        }
    }

    @Override
    public void removeColor(Object colorObj) {
        List domain = this.colors.domain();
        List range = this.colors.range();
        JSONObject jsonColor = (JSONObject)colorObj;
        String color = ObjectConverter.toString((Object)jsonColor.get((Object)"fill"));
        JSONArray values = (JSONArray)jsonColor.get((Object)"values");
        for (Object value : values) {
            int ind = domain.indexOf(value);
            if (ind <= -1 || !ObjectConverter.toString(range.get(ind)).equals(color)) continue;
            this.paletteMap.remove(value);
            domain.remove(ind);
            range.remove(ind);
        }
        this.setupColorScale(domain, range);
    }

    @Override
    protected void domain(List<Object> domain) {
    }

    @Override
    public AbstractScale<Object, Object> getScale() {
        return this.colors;
    }

    @Override
    protected void invalidateDomain() {
    }

    @Override
    protected boolean canHandleDataType(String type) {
        return true;
    }
}

