/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.palette.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.internal.nativeImpl.RaveLibraryResourceLoader;
import com.ibm.vida.rave.library.palette.Palette;
import com.ibm.vida.rave.library.palette.internal.PaletteSet;
import com.ibm.vida.rave.library.service.LibraryError;

public final class PaletteManager {
    @InlineStringConstant
    private static final String PALETTE_MANAGER_DATA_KEY = "PALETTE_MANAGER_DATA_KEY";
    private final JSONObject obj = (JSONObject)new RaveLibraryResourceLoader("/resources/").requireJSON("./configuration/configuration.json");
    private JSONObject paletteConfig;

    private PaletteManagerData getPaletteManagerData() {
        PaletteManagerData paletteManagerData = (PaletteManagerData)RaveContextManager.INSTANCE.getRaveContext().getData(PALETTE_MANAGER_DATA_KEY);
        if (paletteManagerData == null) {
            paletteManagerData = new PaletteManagerData();
            RaveContextManager.INSTANCE.getRaveContext().putData(PALETTE_MANAGER_DATA_KEY, (Object)paletteManagerData);
            this.populate(this.obj);
        }
        return paletteManagerData;
    }

    public void populate(JSONObject config) {
        if (config != null) {
            this.paletteConfig = (JSONObject)config.get((Object)"paletteConfiguration");
            if (this.paletteConfig != null) {
                this.getPaletteManagerData().palettes.populate((JSONArray)this.paletteConfig.get((Object)"palettes"));
                Object defaultPaletteId = this.paletteConfig.get((Object)"defaultPaletteID");
                if (defaultPaletteId != null) {
                    this.setDefaultPalette(ObjectConverter.toString((Object)defaultPaletteId));
                }
            }
        }
    }

    public void setDefaultPalette(String paletteId) {
        this.getPaletteManagerData().defaultPalette = paletteId;
    }

    public String getDefaultId() {
        return this.getPaletteManagerData().defaultPalette;
    }

    public Palette getDefaultPalette() {
        PaletteManagerData paletteManagerData = this.getPaletteManagerData();
        return paletteManagerData.palettes.get(paletteManagerData.defaultPalette);
    }

    public Palette getPalette(String paletteId) {
        return this.getPaletteManagerData().palettes.get(paletteId);
    }

    public Palette getAdjustedColorPalette(String paletteId, double adjustment) {
        JSONObject originalPalette = this.getPaletteManagerData().palettes.getPaletteJSON(paletteId);
        String adjustedPaletteId = (String)originalPalette.get((Object)"id") + "_" + adjustment;
        Palette adjustedPalette = this.getPaletteManagerData().palettes.get(adjustedPaletteId);
        if (adjustedPalette == null) {
            JSONObject adjustedPaletteClone = new JSONObject();
            adjustedPaletteClone.put((Object)"id", (Object)adjustedPaletteId);
            adjustedPaletteClone.put((Object)"valueType", (Object)((String)originalPalette.get((Object)"valueType")));
            String fillType = (String)originalPalette.get((Object)"fillType");
            adjustedPaletteClone.put((Object)"fillType", (Object)fillType);
            boolean simpleFill = fillType.compareTo("simple") == 0;
            JSONArray originalFills = (JSONArray)originalPalette.get((Object)"fills");
            JSONArray newFills = new JSONArray();
            adjustedPaletteClone.put((Object)"fills", (Object)newFills);
            for (int i = 0; i < originalFills.size(); ++i) {
                if (simpleFill) {
                    String fill = (String)originalFills.get(i);
                    fill = adjustment < 0.0 ? Rave.rgb((Object)fill).darker(adjustment * -1.0).toString() : Rave.rgb((Object)fill).brighter(adjustment).toString();
                    newFills.add((Object)fill);
                    continue;
                }
                JSONObject oFill = (JSONObject)originalFills.get(i);
                String fill = (String)oFill.get((Object)"fill");
                fill = adjustment < 0.0 ? Rave.rgb((Object)fill).darker(adjustment * -1.0).toString() : Rave.rgb((Object)fill).brighter(adjustment).toString();
                JSONObject newFill = new JSONObject();
                newFill.put((Object)"at", (Object)ObjectConverter.asDouble((Object)oFill.get((Object)"at")));
                newFill.put((Object)"fill", (Object)fill);
                newFills.add((Object)newFill);
            }
            this.getPaletteManagerData().palettes.add(adjustedPaletteClone);
            adjustedPalette = this.getPaletteManagerData().palettes.get(adjustedPaletteId);
        }
        return adjustedPalette;
    }

    public void addPalette(JSONObject palette) {
        this.getPaletteManagerData().palettes.add(palette);
    }

    public void removePalette(String paletteId, LibraryError error) {
        this.getPaletteManagerData().palettes.remove(paletteId, error);
    }

    public void addPalettes(JSONArray palettes) {
        PaletteSet paletteSet = this.getPaletteManagerData().palettes;
        for (Object palette : palettes) {
            paletteSet.add((JSONObject)palette);
        }
    }

    public ArrayEx<Palette> getAllPalettes() {
        return this.getPaletteManagerData().palettes.getAll();
    }

    public ArrayEx<String> getAllPaletteIds() {
        return this.getPaletteManagerData().palettes.getAllIds();
    }

    public JSONObject getJSONPalette(String id) {
        return this.getPaletteManagerData().palettes.getPaletteJSON(id);
    }

    private static class PaletteManagerData {
        final PaletteSet palettes = new PaletteSet();
        String defaultPalette;

        private PaletteManagerData() {
        }
    }
}

