/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.property;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.library.Library;
import com.ibm.vida.rave.library.framework.meta.PropertyMeta;
import com.ibm.vida.rave.library.property.Property;
import com.ibm.vida.rave.library.property.PropertyType;

public class PropertyImpl
implements Property {
    private Object _value;
    private final PropertyType _propertyType;
    @SwiftWeak(value=false)
    private PropertyImpl _parent;
    private boolean _readonly = false;
    private boolean _hidden = false;

    protected PropertyImpl(PropertyType propertyType, PropertyImpl parent) {
        this._propertyType = propertyType;
        this._parent = parent;
        this._value = propertyType.typeId() == 21 ? new JSONObject() : propertyType.defaultValue();
    }

    final boolean readonly() {
        return this._readonly;
    }

    final void setReadonly() {
        this._readonly = true;
    }

    public final boolean hidden() {
        return this._hidden;
    }

    final void setHidden() {
        this._hidden = true;
    }

    @Override
    public PropertyMeta meta() {
        return this._propertyType;
    }

    @Override
    public Property parent() {
        return this._parent;
    }

    @Override
    public Object reset() {
        Object defs;
        if (!this.readonly() && (defs = this._propertyType.defaultValue()) != null) {
            this.setValue(defs);
        }
        return this._value;
    }

    @Override
    public Object value() {
        return this._value;
    }

    @Override
    public boolean value(Object obj) {
        if (this.readonly()) {
            Library.logError(35, "Property validate");
            return false;
        }
        if (obj == null) {
            if (this._propertyType.required()) {
                if (this._propertyType.defaultValue() == null) {
                    Library.logError(40, "Property validate");
                    return false;
                }
                if (!this._propertyType.validateValue(this._propertyType.defaultValue())) {
                    return false;
                }
                this.reset();
                return true;
            }
        } else if (!this._propertyType.validateValue(obj)) {
            return false;
        }
        return this.setValue(obj);
    }

    private boolean setValue(Object obj) {
        this._value = this._propertyType.canonicalValue(obj);
        if (this._parent != null && this._parent.meta().typeId() == 21) {
            JSONObject valueInstance = (JSONObject)this._parent.value();
            valueInstance.put((Object)this._propertyType.simpleId(), this._value);
        }
        return true;
    }
}

