/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.property;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.Library;
import com.ibm.vida.rave.library.framework.meta.PropertyMeta;
import com.ibm.vida.rave.library.i18n.MessagesRegistry;
import com.ibm.vida.rave.library.palette.Palette;
import com.ibm.vida.rave.library.property.PalettePropertyOption;
import com.ibm.vida.rave.library.property.PropertyOption;
import com.ibm.vida.rave.library.property.PropertyProcessingInfo;
import com.ibm.vida.rave.library.property.PropertyType;
import com.ibm.vida.rave.library.property.PropertyUtil;
import java.util.List;

public class PropertyPaletteType
extends PropertyType<String> {
    private ArrayEx<String> paletteTypes;

    protected PropertyPaletteType(String propertyId, String qualifiedId, PropertyType parent, MessagesRegistry messages) {
        super(propertyId, qualifiedId, parent, messages);
    }

    @Override
    public List<PropertyOption<String>> options() {
        ArrayEx dynamicOptions = new ArrayEx();
        ArrayEx<Palette> libraryOptions = Library.palettes.getAllPalettes();
        for (Palette palette : libraryOptions) {
            if (!this.paletteTypes.contains((Object)palette.getType())) continue;
            dynamicOptions.add((Object)new PalettePropertyOption(palette.getId(), palette.getLabel(), this._messages));
        }
        return dynamicOptions;
    }

    @Override
    public Object defaultValue() {
        Object defaultValue = super.defaultValue();
        if (defaultValue == null) {
            return Library.palettes.getDefaultId();
        }
        return defaultValue;
    }

    @Override
    public String type() {
        return "palette";
    }

    @Override
    public int typeId() {
        return 16;
    }

    @Override
    protected void initType(JSONObject propertyJSON, PropertyProcessingInfo info) {
        super.initType(propertyJSON, info);
        if (!info.validate || !info.hasInvalidProperties) {
            Object obj = propertyJSON.get((Object)"options");
            if (obj != null) {
                if (PropertyUtil.INSTANCE.validateBasicType(obj, 20)) {
                    JSONArray optionsArray = (JSONArray)obj;
                    int len = optionsArray.size();
                    this.paletteTypes = new ArrayEx();
                    for (int i = 0; i < len; ++i) {
                        this.paletteTypes.add((Object)ObjectConverter.toString((Object)optionsArray.get(i)));
                    }
                    if (info.validate && !PropertyUtil.INSTANCE.validateSimpleOptions(optionsArray, this)) {
                        info.processError();
                        return;
                    }
                } else {
                    info.processError();
                    if (info.validate) {
                        return;
                    }
                }
            }
            if (this.defaultValue() != null && info.validate && !this.validateValue(this.defaultValue())) {
                info.processError();
                return;
            }
        }
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public boolean validateValue(Object obj) {
        return PropertyUtil.INSTANCE.validateBasicType(obj, 10) || this.paletteTypes == null || this.paletteTypes.size() < 1 || PropertyUtil.INSTANCE.validateObjectExistInList((List<?>)this.paletteTypes, obj);
    }

    @Override
    public PropertyMeta copy(PropertyMeta<Object> parent) {
        PropertyPaletteType ppt = new PropertyPaletteType(this.simpleId(), this.id(), (PropertyType)parent, this._messages);
        this.pTypeCopy(ppt);
        ppt.paletteTypes = new ArrayEx();
        for (String palette : this.paletteTypes) {
            ppt.paletteTypes.add((Object)palette);
        }
        return ppt;
    }
}

