/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.property;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.collections.OSet;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.framework.meta.PropertyMeta;
import com.ibm.vida.rave.library.i18n.MessagesRegistry;
import com.ibm.vida.rave.library.property.ObjectPropertyImpl;
import com.ibm.vida.rave.library.property.Property;
import com.ibm.vida.rave.library.property.PropertyImpl;
import com.ibm.vida.rave.library.property.PropertyObjectType;
import com.ibm.vida.rave.library.property.PropertyProcessingInfo;
import com.ibm.vida.rave.library.property.PropertyProcessor;
import com.ibm.vida.rave.library.property.PropertyType;

public class PropertySet {
    private final OMap<String, PropertyImpl> _flattennedPropMap = new OMap();
    private ArrayEx<Property> _visibleProperties = null;
    private ArrayEx<PropertyMeta> _visibleMeta = null;

    public void populate(ArrayEx<PropertyMeta> properties) {
        for (PropertyMeta propertyMeta : properties) {
            this.addTopLevelProperty((PropertyType)propertyMeta.copy(null));
        }
        this._visibleProperties = null;
        this._visibleMeta = null;
    }

    public void populate(JSONObject props, MessagesRegistry messages, boolean validate) {
        PropertyProcessingInfo info = PropertyProcessor.processProperties(props, messages, validate);
        this.populate(info.properties);
    }

    private void addTopLevelProperty(PropertyType propertyType) {
        PropertyImpl prop = (PropertyImpl)this._flattennedPropMap.get((Object)propertyType.id());
        if (prop == null) {
            this.addProperty(propertyType, null);
        } else {
            this.mergeProperty(prop, propertyType, null);
        }
    }

    private void addProperty(PropertyType propertyType, PropertyImpl parent) {
        PropertyImpl newProperty = null;
        if (propertyType.typeId() == 21) {
            PropertyObjectType objPropType = (PropertyObjectType)propertyType;
            newProperty = new ObjectPropertyImpl(objPropType, parent);
            this._flattennedPropMap.put((Object)propertyType.id(), (Object)newProperty);
            for (String key : objPropType.childProperties().keySet()) {
                PropertyType childProperty = (PropertyType)objPropType.childProperties().get((Object)key);
                this.addProperty(childProperty, newProperty);
            }
        } else {
            newProperty = new PropertyImpl(propertyType, parent);
            this._flattennedPropMap.put((Object)propertyType.id(), (Object)newProperty);
        }
        if (parent != null && parent.meta().typeId() == 21) {
            ((ObjectPropertyImpl)parent).childProperties().put((Object)newProperty.meta().simpleId(), (Object)newProperty);
        }
    }

    private void mergeProperty(PropertyImpl existingProperty, PropertyType newPropertyType, PropertyImpl parent) {
        if (existingProperty.meta().typeId() == 21 && newPropertyType.typeId() == 21) {
            ObjectPropertyImpl existingObj = (ObjectPropertyImpl)existingProperty;
            PropertyObjectType newObjType = (PropertyObjectType)newPropertyType;
            OSet newObjectTypeChildIds = new OSet();
            for (String key : newObjType.childProperties().keySet()) {
                newObjectTypeChildIds.add((Object)key);
                PropertyType newChildPropertyType = (PropertyType)newObjType.childProperties().get((Object)key);
                PropertyImpl existingChildProperty = (PropertyImpl)existingObj.childProperties().get((Object)key);
                if (existingChildProperty != null) {
                    this.mergeProperty(existingChildProperty, newChildPropertyType, existingObj);
                    continue;
                }
                this.fuseProperty(newChildPropertyType, existingObj);
            }
            for (Object key : newObjectTypeChildIds.toArray()) {
                newObjType.childProperties().remove((Object)ObjectConverter.toString((Object)key));
            }
        } else {
            this.overwriteProperty(existingProperty, newPropertyType, parent);
        }
    }

    private void overwriteProperty(PropertyImpl existingProperty, PropertyType newPropertyType, PropertyImpl parent) {
        if (existingProperty.meta().typeId() == 21) {
            ObjectPropertyImpl objProperty = (ObjectPropertyImpl)existingProperty;
            OMap<String, Property> children = objProperty.childProperties();
            for (String propertyId : children.keySet()) {
                Property childProperty = (Property)children.get((Object)propertyId);
                this.removePropertyFromFlatMap(childProperty);
            }
        }
        if (parent != null && parent.meta().typeId() == 21) {
            this.fuseProperty(newPropertyType, (ObjectPropertyImpl)parent);
        } else {
            newPropertyType._parent = ((PropertyType)existingProperty.meta())._parent;
            this.addProperty(newPropertyType, parent);
        }
        ((PropertyType)existingProperty.meta())._parent = null;
    }

    private void fuseProperty(PropertyType newChildPropertyType, ObjectPropertyImpl existingParentObj) {
        this.addProperty(newChildPropertyType, existingParentObj);
        PropertyObjectType existingParentObjType = (PropertyObjectType)existingParentObj.meta();
        existingParentObjType.childProperties().put((Object)newChildPropertyType.simpleId(), (Object)newChildPropertyType);
        newChildPropertyType._parent = existingParentObjType;
        JSONObject defaultInstance = (JSONObject)existingParentObj.meta().defaultValue();
        defaultInstance.put((Object)newChildPropertyType.simpleId(), newChildPropertyType.defaultValue());
        JSONObject valueInstance = (JSONObject)existingParentObj.value();
        valueInstance.put((Object)newChildPropertyType.simpleId(), newChildPropertyType.defaultValue());
    }

    private void removePropertyFromFlatMap(Property property) {
        this._flattennedPropMap.remove((Object)property.meta().id());
        if (property.meta().typeId() == 21) {
            ObjectPropertyImpl objProperty = (ObjectPropertyImpl)property;
            for (String propertyId : objProperty.childProperties().keySet()) {
                Property childProperty = (Property)objProperty.childProperties().get((Object)propertyId);
                this.removePropertyFromFlatMap(childProperty);
            }
        }
    }

    public final void configure(JSONObject json) {
        Object v = json.get((Object)"properties");
        if (v != null) {
            for (Object o : (JSONArray)v) {
                Boolean b;
                JSONObject config = (JSONObject)o;
                PropertyImpl prop = (PropertyImpl)this._flattennedPropMap.get((Object)ObjectConverter.toString((Object)config.get((Object)"id")));
                if (prop == null) continue;
                Object value = config.get((Object)"value");
                if (value != null && !prop.readonly()) {
                    prop.value(value);
                    prop.meta().setDefaultValue(value);
                }
                if ((b = Boolean.valueOf(ObjectConverter.toBoolean((Object)config.get((Object)"hidden")))) != null && b.booleanValue()) {
                    prop.setHidden();
                }
                if ((b = Boolean.valueOf(ObjectConverter.toBoolean((Object)config.get((Object)"readonly")))) == null || !b.booleanValue()) continue;
                prop.setReadonly();
            }
            this._visibleProperties = null;
            this._visibleMeta = null;
        }
    }

    public Property property(String id) {
        if (id != null) {
            return (Property)this._flattennedPropMap.get((Object)id);
        }
        return null;
    }

    public final ArrayEx<Property> properties() {
        if (this._visibleProperties == null) {
            this.buildVisibleProperties();
        }
        return this._visibleProperties;
    }

    public final ArrayEx<PropertyMeta> meta() {
        if (this._visibleMeta == null) {
            this.buildVisibleProperties();
        }
        return this._visibleMeta;
    }

    private final void buildVisibleProperties() {
        this._visibleProperties = new ArrayEx();
        this._visibleMeta = new ArrayEx();
        for (String id : this._flattennedPropMap.keySet()) {
            PropertyImpl prop = (PropertyImpl)this._flattennedPropMap.get((Object)id);
            if (prop.meta().typeId() == 21 || prop.hidden()) continue;
            this._visibleProperties.add((Object)prop);
            this._visibleMeta.add((Object)prop.meta());
        }
    }

    public static ArrayEx<PropertyMeta> merge(ArrayEx<PropertyMeta> properties) {
        PropertySet propertySet = new PropertySet();
        propertySet.populate(properties);
        ArrayEx<Property> props = propertySet.properties();
        ArrayEx mergedMeta = new ArrayEx();
        for (Property p : props) {
            mergedMeta.add((Object)p.meta());
        }
        return mergedMeta;
    }
}

