/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.library.service;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.library.service.LibraryError;

public class ErrorDispatcher {
    public static final ErrorDispatcher INSTANCE = new ErrorDispatcher();
    @InlineStringConstant
    private static final String ERROR_REPORTER_KEY = "ERROR_REPORTER_KEY";

    private LibraryError.ReportError getReporter() {
        return (LibraryError.ReportError)RaveContextManager.INSTANCE.getRaveContext().getData(ERROR_REPORTER_KEY);
    }

    private ErrorDispatcher() {
    }

    public void setReporter(LibraryError.ReportError reporter) {
        RaveContextManager.INSTANCE.getRaveContext().putData(ERROR_REPORTER_KEY, (Object)reporter);
    }

    public void error(LibraryError error) {
        LibraryError.ReportError reporter = this.getReporter();
        if (reporter != null) {
            reporter.error(error);
        }
    }

    public final void logError(int code) {
        this.error(LibraryError.create(code));
    }

    public final void logError(int code, String location) {
        this.error(LibraryError.create(code, location));
    }

    public final void logError(int code, String location, String bundleName) {
        this.error(LibraryError.create(code, location, bundleName));
    }
}

